/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.s3control.model.UpdateAccessGrantsLocationRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.XMLWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class UpdateAccessGrantsLocationRequestMarshaller
implements Marshaller<Request<UpdateAccessGrantsLocationRequest>, UpdateAccessGrantsLocationRequest> {
    public Request<UpdateAccessGrantsLocationRequest> marshall(UpdateAccessGrantsLocationRequest updateAccessGrantsLocationRequest) {
        if (updateAccessGrantsLocationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateAccessGrantsLocationRequest, "AWSS3Control");
        request.setHttpMethod(HttpMethodName.PUT);
        if (updateAccessGrantsLocationRequest.getAccountId() != null) {
            request.addHeader("x-amz-account-id", StringUtils.fromString((String)updateAccessGrantsLocationRequest.getAccountId()));
        }
        String uriResourcePath = "/v20180820/accessgrantsinstance/location/{id}";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "id", updateAccessGrantsLocationRequest.getAccessGrantsLocationId());
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            XMLWriter xmlWriter = new XMLWriter((Writer)stringWriter, "http://awss3control.amazonaws.com/doc/2018-08-20/");
            xmlWriter.startElement("UpdateAccessGrantsLocationRequest");
            if (updateAccessGrantsLocationRequest != null && updateAccessGrantsLocationRequest.getIAMRoleArn() != null) {
                xmlWriter.startElement("IAMRoleArn").value(updateAccessGrantsLocationRequest.getIAMRoleArn()).endElement();
            }
            xmlWriter.endElement();
            request.setContent((InputStream)new StringInputStream(stringWriter.getBuffer().toString()));
            request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8).length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }
        return request;
    }
}

