/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.s3control.model.PublicAccessBlockConfiguration;
import com.amazonaws.services.s3control.model.PutPublicAccessBlockRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.XMLWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class PutPublicAccessBlockRequestMarshaller
implements Marshaller<Request<PutPublicAccessBlockRequest>, PutPublicAccessBlockRequest> {
    public Request<PutPublicAccessBlockRequest> marshall(PutPublicAccessBlockRequest putPublicAccessBlockRequest) {
        if (putPublicAccessBlockRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)putPublicAccessBlockRequest, "AWSS3Control");
        request.setHttpMethod(HttpMethodName.PUT);
        if (putPublicAccessBlockRequest.getAccountId() != null) {
            request.addHeader("x-amz-account-id", StringUtils.fromString((String)putPublicAccessBlockRequest.getAccountId()));
        }
        String uriResourcePath = "/v20180820/configuration/publicAccessBlock";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            XMLWriter xmlWriter = new XMLWriter((Writer)stringWriter, "http://awss3control.amazonaws.com/doc/2018-08-20/");
            PublicAccessBlockConfiguration publicAccessBlockConfiguration = putPublicAccessBlockRequest.getPublicAccessBlockConfiguration();
            if (publicAccessBlockConfiguration != null) {
                xmlWriter.startElement("PublicAccessBlockConfiguration");
                if (publicAccessBlockConfiguration.getBlockPublicAcls() != null) {
                    xmlWriter.startElement("BlockPublicAcls").value((Object)publicAccessBlockConfiguration.getBlockPublicAcls()).endElement();
                }
                if (publicAccessBlockConfiguration.getIgnorePublicAcls() != null) {
                    xmlWriter.startElement("IgnorePublicAcls").value((Object)publicAccessBlockConfiguration.getIgnorePublicAcls()).endElement();
                }
                if (publicAccessBlockConfiguration.getBlockPublicPolicy() != null) {
                    xmlWriter.startElement("BlockPublicPolicy").value((Object)publicAccessBlockConfiguration.getBlockPublicPolicy()).endElement();
                }
                if (publicAccessBlockConfiguration.getRestrictPublicBuckets() != null) {
                    xmlWriter.startElement("RestrictPublicBuckets").value((Object)publicAccessBlockConfiguration.getRestrictPublicBuckets()).endElement();
                }
                xmlWriter.endElement();
            }
            request.setContent((InputStream)new StringInputStream(stringWriter.getBuffer().toString()));
            request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8).length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }
        return request;
    }
}

