/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.s3control.model.DeleteJobTaggingRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import com.amazonaws.util.StringUtils;

public class DeleteJobTaggingRequestMarshaller
implements Marshaller<Request<DeleteJobTaggingRequest>, DeleteJobTaggingRequest> {
    public Request<DeleteJobTaggingRequest> marshall(DeleteJobTaggingRequest deleteJobTaggingRequest) {
        if (deleteJobTaggingRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deleteJobTaggingRequest, "AWSS3Control");
        request.setHttpMethod(HttpMethodName.DELETE);
        if (deleteJobTaggingRequest.getAccountId() != null) {
            request.addHeader("x-amz-account-id", StringUtils.fromString((String)deleteJobTaggingRequest.getAccountId()));
        }
        String uriResourcePath = "/v20180820/jobs/{id}/tagging";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "id", deleteJobTaggingRequest.getJobId());
        request.setResourcePath(uriResourcePath);
        return request;
    }
}

