/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.s3control.model.DeleteMultiRegionAccessPointInput;
import com.amazonaws.services.s3control.model.DeleteMultiRegionAccessPointRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.IdempotentUtils;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.XMLWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class DeleteMultiRegionAccessPointRequestMarshaller
implements Marshaller<Request<DeleteMultiRegionAccessPointRequest>, DeleteMultiRegionAccessPointRequest> {
    public Request<DeleteMultiRegionAccessPointRequest> marshall(DeleteMultiRegionAccessPointRequest deleteMultiRegionAccessPointRequest) {
        if (deleteMultiRegionAccessPointRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deleteMultiRegionAccessPointRequest, "AWSS3Control");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteMultiRegionAccessPointRequest.getAccountId() != null) {
            request.addHeader("x-amz-account-id", StringUtils.fromString((String)deleteMultiRegionAccessPointRequest.getAccountId()));
        }
        String uriResourcePath = "/v20180820/async-requests/mrap/delete";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            XMLWriter xmlWriter = new XMLWriter((Writer)stringWriter, "http://awss3control.amazonaws.com/doc/2018-08-20/");
            xmlWriter.startElement("DeleteMultiRegionAccessPointRequest");
            if (deleteMultiRegionAccessPointRequest != null) {
                xmlWriter.startElement("ClientToken").value(IdempotentUtils.resolveString((String)deleteMultiRegionAccessPointRequest.getClientToken())).endElement();
                DeleteMultiRegionAccessPointInput details = deleteMultiRegionAccessPointRequest.getDetails();
                if (details != null) {
                    xmlWriter.startElement("Details");
                    if (details.getName() != null) {
                        xmlWriter.startElement("Name").value(details.getName()).endElement();
                    }
                    xmlWriter.endElement();
                }
            }
            xmlWriter.endElement();
            request.setContent((InputStream)new StringInputStream(stringWriter.getBuffer().toString()));
            request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8).length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }
        return request;
    }
}

