/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.model;

import com.amazonaws.services.s3control.model.S3CannedAccessControlList;
import com.amazonaws.services.s3control.model.S3Grant;
import com.amazonaws.services.s3control.model.S3MetadataDirective;
import com.amazonaws.services.s3control.model.S3ObjectLockLegalHoldStatus;
import com.amazonaws.services.s3control.model.S3ObjectLockMode;
import com.amazonaws.services.s3control.model.S3ObjectMetadata;
import com.amazonaws.services.s3control.model.S3StorageClass;
import com.amazonaws.services.s3control.model.S3Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class S3CopyObjectOperation
implements Serializable,
Cloneable {
    private String targetResource;
    private String cannedAccessControlList;
    private List<S3Grant> accessControlGrants;
    private String metadataDirective;
    private Date modifiedSinceConstraint;
    private S3ObjectMetadata newObjectMetadata;
    private List<S3Tag> newObjectTagging;
    private String redirectLocation;
    private Boolean requesterPays;
    private String storageClass;
    private Date unModifiedSinceConstraint;
    private String sSEAwsKmsKeyId;
    private String targetKeyPrefix;
    private String objectLockLegalHoldStatus;
    private String objectLockMode;
    private Date objectLockRetainUntilDate;

    public void setTargetResource(String targetResource) {
        this.targetResource = targetResource;
    }

    public String getTargetResource() {
        return this.targetResource;
    }

    public S3CopyObjectOperation withTargetResource(String targetResource) {
        this.setTargetResource(targetResource);
        return this;
    }

    public void setCannedAccessControlList(String cannedAccessControlList) {
        this.cannedAccessControlList = cannedAccessControlList;
    }

    public String getCannedAccessControlList() {
        return this.cannedAccessControlList;
    }

    public S3CopyObjectOperation withCannedAccessControlList(String cannedAccessControlList) {
        this.setCannedAccessControlList(cannedAccessControlList);
        return this;
    }

    public S3CopyObjectOperation withCannedAccessControlList(S3CannedAccessControlList cannedAccessControlList) {
        this.cannedAccessControlList = cannedAccessControlList.toString();
        return this;
    }

    public List<S3Grant> getAccessControlGrants() {
        return this.accessControlGrants;
    }

    public void setAccessControlGrants(Collection<S3Grant> accessControlGrants) {
        if (accessControlGrants == null) {
            this.accessControlGrants = null;
            return;
        }
        this.accessControlGrants = new ArrayList<S3Grant>(accessControlGrants);
    }

    public S3CopyObjectOperation withAccessControlGrants(S3Grant ... accessControlGrants) {
        if (this.accessControlGrants == null) {
            this.setAccessControlGrants(new ArrayList<S3Grant>(accessControlGrants.length));
        }
        for (S3Grant ele : accessControlGrants) {
            this.accessControlGrants.add(ele);
        }
        return this;
    }

    public S3CopyObjectOperation withAccessControlGrants(Collection<S3Grant> accessControlGrants) {
        this.setAccessControlGrants(accessControlGrants);
        return this;
    }

    public void setMetadataDirective(String metadataDirective) {
        this.metadataDirective = metadataDirective;
    }

    public String getMetadataDirective() {
        return this.metadataDirective;
    }

    public S3CopyObjectOperation withMetadataDirective(String metadataDirective) {
        this.setMetadataDirective(metadataDirective);
        return this;
    }

    public S3CopyObjectOperation withMetadataDirective(S3MetadataDirective metadataDirective) {
        this.metadataDirective = metadataDirective.toString();
        return this;
    }

    public void setModifiedSinceConstraint(Date modifiedSinceConstraint) {
        this.modifiedSinceConstraint = modifiedSinceConstraint;
    }

    public Date getModifiedSinceConstraint() {
        return this.modifiedSinceConstraint;
    }

    public S3CopyObjectOperation withModifiedSinceConstraint(Date modifiedSinceConstraint) {
        this.setModifiedSinceConstraint(modifiedSinceConstraint);
        return this;
    }

    public void setNewObjectMetadata(S3ObjectMetadata newObjectMetadata) {
        this.newObjectMetadata = newObjectMetadata;
    }

    public S3ObjectMetadata getNewObjectMetadata() {
        return this.newObjectMetadata;
    }

    public S3CopyObjectOperation withNewObjectMetadata(S3ObjectMetadata newObjectMetadata) {
        this.setNewObjectMetadata(newObjectMetadata);
        return this;
    }

    public List<S3Tag> getNewObjectTagging() {
        return this.newObjectTagging;
    }

    public void setNewObjectTagging(Collection<S3Tag> newObjectTagging) {
        if (newObjectTagging == null) {
            this.newObjectTagging = null;
            return;
        }
        this.newObjectTagging = new ArrayList<S3Tag>(newObjectTagging);
    }

    public S3CopyObjectOperation withNewObjectTagging(S3Tag ... newObjectTagging) {
        if (this.newObjectTagging == null) {
            this.setNewObjectTagging(new ArrayList<S3Tag>(newObjectTagging.length));
        }
        for (S3Tag ele : newObjectTagging) {
            this.newObjectTagging.add(ele);
        }
        return this;
    }

    public S3CopyObjectOperation withNewObjectTagging(Collection<S3Tag> newObjectTagging) {
        this.setNewObjectTagging(newObjectTagging);
        return this;
    }

    public void setRedirectLocation(String redirectLocation) {
        this.redirectLocation = redirectLocation;
    }

    public String getRedirectLocation() {
        return this.redirectLocation;
    }

    public S3CopyObjectOperation withRedirectLocation(String redirectLocation) {
        this.setRedirectLocation(redirectLocation);
        return this;
    }

    public void setRequesterPays(Boolean requesterPays) {
        this.requesterPays = requesterPays;
    }

    public Boolean getRequesterPays() {
        return this.requesterPays;
    }

    public S3CopyObjectOperation withRequesterPays(Boolean requesterPays) {
        this.setRequesterPays(requesterPays);
        return this;
    }

    public Boolean isRequesterPays() {
        return this.requesterPays;
    }

    public void setStorageClass(String storageClass) {
        this.storageClass = storageClass;
    }

    public String getStorageClass() {
        return this.storageClass;
    }

    public S3CopyObjectOperation withStorageClass(String storageClass) {
        this.setStorageClass(storageClass);
        return this;
    }

    public S3CopyObjectOperation withStorageClass(S3StorageClass storageClass) {
        this.storageClass = storageClass.toString();
        return this;
    }

    public void setUnModifiedSinceConstraint(Date unModifiedSinceConstraint) {
        this.unModifiedSinceConstraint = unModifiedSinceConstraint;
    }

    public Date getUnModifiedSinceConstraint() {
        return this.unModifiedSinceConstraint;
    }

    public S3CopyObjectOperation withUnModifiedSinceConstraint(Date unModifiedSinceConstraint) {
        this.setUnModifiedSinceConstraint(unModifiedSinceConstraint);
        return this;
    }

    public void setSSEAwsKmsKeyId(String sSEAwsKmsKeyId) {
        this.sSEAwsKmsKeyId = sSEAwsKmsKeyId;
    }

    public String getSSEAwsKmsKeyId() {
        return this.sSEAwsKmsKeyId;
    }

    public S3CopyObjectOperation withSSEAwsKmsKeyId(String sSEAwsKmsKeyId) {
        this.setSSEAwsKmsKeyId(sSEAwsKmsKeyId);
        return this;
    }

    public void setTargetKeyPrefix(String targetKeyPrefix) {
        this.targetKeyPrefix = targetKeyPrefix;
    }

    public String getTargetKeyPrefix() {
        return this.targetKeyPrefix;
    }

    public S3CopyObjectOperation withTargetKeyPrefix(String targetKeyPrefix) {
        this.setTargetKeyPrefix(targetKeyPrefix);
        return this;
    }

    public void setObjectLockLegalHoldStatus(String objectLockLegalHoldStatus) {
        this.objectLockLegalHoldStatus = objectLockLegalHoldStatus;
    }

    public String getObjectLockLegalHoldStatus() {
        return this.objectLockLegalHoldStatus;
    }

    public S3CopyObjectOperation withObjectLockLegalHoldStatus(String objectLockLegalHoldStatus) {
        this.setObjectLockLegalHoldStatus(objectLockLegalHoldStatus);
        return this;
    }

    public S3CopyObjectOperation withObjectLockLegalHoldStatus(S3ObjectLockLegalHoldStatus objectLockLegalHoldStatus) {
        this.objectLockLegalHoldStatus = objectLockLegalHoldStatus.toString();
        return this;
    }

    public void setObjectLockMode(String objectLockMode) {
        this.objectLockMode = objectLockMode;
    }

    public String getObjectLockMode() {
        return this.objectLockMode;
    }

    public S3CopyObjectOperation withObjectLockMode(String objectLockMode) {
        this.setObjectLockMode(objectLockMode);
        return this;
    }

    public S3CopyObjectOperation withObjectLockMode(S3ObjectLockMode objectLockMode) {
        this.objectLockMode = objectLockMode.toString();
        return this;
    }

    public void setObjectLockRetainUntilDate(Date objectLockRetainUntilDate) {
        this.objectLockRetainUntilDate = objectLockRetainUntilDate;
    }

    public Date getObjectLockRetainUntilDate() {
        return this.objectLockRetainUntilDate;
    }

    public S3CopyObjectOperation withObjectLockRetainUntilDate(Date objectLockRetainUntilDate) {
        this.setObjectLockRetainUntilDate(objectLockRetainUntilDate);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTargetResource() != null) {
            sb.append("TargetResource: ").append(this.getTargetResource()).append(",");
        }
        if (this.getCannedAccessControlList() != null) {
            sb.append("CannedAccessControlList: ").append(this.getCannedAccessControlList()).append(",");
        }
        if (this.getAccessControlGrants() != null) {
            sb.append("AccessControlGrants: ").append(this.getAccessControlGrants()).append(",");
        }
        if (this.getMetadataDirective() != null) {
            sb.append("MetadataDirective: ").append(this.getMetadataDirective()).append(",");
        }
        if (this.getModifiedSinceConstraint() != null) {
            sb.append("ModifiedSinceConstraint: ").append(this.getModifiedSinceConstraint()).append(",");
        }
        if (this.getNewObjectMetadata() != null) {
            sb.append("NewObjectMetadata: ").append(this.getNewObjectMetadata()).append(",");
        }
        if (this.getNewObjectTagging() != null) {
            sb.append("NewObjectTagging: ").append(this.getNewObjectTagging()).append(",");
        }
        if (this.getRedirectLocation() != null) {
            sb.append("RedirectLocation: ").append(this.getRedirectLocation()).append(",");
        }
        if (this.getRequesterPays() != null) {
            sb.append("RequesterPays: ").append(this.getRequesterPays()).append(",");
        }
        if (this.getStorageClass() != null) {
            sb.append("StorageClass: ").append(this.getStorageClass()).append(",");
        }
        if (this.getUnModifiedSinceConstraint() != null) {
            sb.append("UnModifiedSinceConstraint: ").append(this.getUnModifiedSinceConstraint()).append(",");
        }
        if (this.getSSEAwsKmsKeyId() != null) {
            sb.append("SSEAwsKmsKeyId: ").append(this.getSSEAwsKmsKeyId()).append(",");
        }
        if (this.getTargetKeyPrefix() != null) {
            sb.append("TargetKeyPrefix: ").append(this.getTargetKeyPrefix()).append(",");
        }
        if (this.getObjectLockLegalHoldStatus() != null) {
            sb.append("ObjectLockLegalHoldStatus: ").append(this.getObjectLockLegalHoldStatus()).append(",");
        }
        if (this.getObjectLockMode() != null) {
            sb.append("ObjectLockMode: ").append(this.getObjectLockMode()).append(",");
        }
        if (this.getObjectLockRetainUntilDate() != null) {
            sb.append("ObjectLockRetainUntilDate: ").append(this.getObjectLockRetainUntilDate());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3CopyObjectOperation)) {
            return false;
        }
        S3CopyObjectOperation other = (S3CopyObjectOperation)obj;
        if (other.getTargetResource() == null ^ this.getTargetResource() == null) {
            return false;
        }
        if (other.getTargetResource() != null && !other.getTargetResource().equals(this.getTargetResource())) {
            return false;
        }
        if (other.getCannedAccessControlList() == null ^ this.getCannedAccessControlList() == null) {
            return false;
        }
        if (other.getCannedAccessControlList() != null && !other.getCannedAccessControlList().equals(this.getCannedAccessControlList())) {
            return false;
        }
        if (other.getAccessControlGrants() == null ^ this.getAccessControlGrants() == null) {
            return false;
        }
        if (other.getAccessControlGrants() != null && !other.getAccessControlGrants().equals(this.getAccessControlGrants())) {
            return false;
        }
        if (other.getMetadataDirective() == null ^ this.getMetadataDirective() == null) {
            return false;
        }
        if (other.getMetadataDirective() != null && !other.getMetadataDirective().equals(this.getMetadataDirective())) {
            return false;
        }
        if (other.getModifiedSinceConstraint() == null ^ this.getModifiedSinceConstraint() == null) {
            return false;
        }
        if (other.getModifiedSinceConstraint() != null && !other.getModifiedSinceConstraint().equals(this.getModifiedSinceConstraint())) {
            return false;
        }
        if (other.getNewObjectMetadata() == null ^ this.getNewObjectMetadata() == null) {
            return false;
        }
        if (other.getNewObjectMetadata() != null && !other.getNewObjectMetadata().equals(this.getNewObjectMetadata())) {
            return false;
        }
        if (other.getNewObjectTagging() == null ^ this.getNewObjectTagging() == null) {
            return false;
        }
        if (other.getNewObjectTagging() != null && !other.getNewObjectTagging().equals(this.getNewObjectTagging())) {
            return false;
        }
        if (other.getRedirectLocation() == null ^ this.getRedirectLocation() == null) {
            return false;
        }
        if (other.getRedirectLocation() != null && !other.getRedirectLocation().equals(this.getRedirectLocation())) {
            return false;
        }
        if (other.getRequesterPays() == null ^ this.getRequesterPays() == null) {
            return false;
        }
        if (other.getRequesterPays() != null && !other.getRequesterPays().equals(this.getRequesterPays())) {
            return false;
        }
        if (other.getStorageClass() == null ^ this.getStorageClass() == null) {
            return false;
        }
        if (other.getStorageClass() != null && !other.getStorageClass().equals(this.getStorageClass())) {
            return false;
        }
        if (other.getUnModifiedSinceConstraint() == null ^ this.getUnModifiedSinceConstraint() == null) {
            return false;
        }
        if (other.getUnModifiedSinceConstraint() != null && !other.getUnModifiedSinceConstraint().equals(this.getUnModifiedSinceConstraint())) {
            return false;
        }
        if (other.getSSEAwsKmsKeyId() == null ^ this.getSSEAwsKmsKeyId() == null) {
            return false;
        }
        if (other.getSSEAwsKmsKeyId() != null && !other.getSSEAwsKmsKeyId().equals(this.getSSEAwsKmsKeyId())) {
            return false;
        }
        if (other.getTargetKeyPrefix() == null ^ this.getTargetKeyPrefix() == null) {
            return false;
        }
        if (other.getTargetKeyPrefix() != null && !other.getTargetKeyPrefix().equals(this.getTargetKeyPrefix())) {
            return false;
        }
        if (other.getObjectLockLegalHoldStatus() == null ^ this.getObjectLockLegalHoldStatus() == null) {
            return false;
        }
        if (other.getObjectLockLegalHoldStatus() != null && !other.getObjectLockLegalHoldStatus().equals(this.getObjectLockLegalHoldStatus())) {
            return false;
        }
        if (other.getObjectLockMode() == null ^ this.getObjectLockMode() == null) {
            return false;
        }
        if (other.getObjectLockMode() != null && !other.getObjectLockMode().equals(this.getObjectLockMode())) {
            return false;
        }
        if (other.getObjectLockRetainUntilDate() == null ^ this.getObjectLockRetainUntilDate() == null) {
            return false;
        }
        return other.getObjectLockRetainUntilDate() == null || other.getObjectLockRetainUntilDate().equals(this.getObjectLockRetainUntilDate());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTargetResource() == null ? 0 : this.getTargetResource().hashCode());
        hashCode = 31 * hashCode + (this.getCannedAccessControlList() == null ? 0 : this.getCannedAccessControlList().hashCode());
        hashCode = 31 * hashCode + (this.getAccessControlGrants() == null ? 0 : this.getAccessControlGrants().hashCode());
        hashCode = 31 * hashCode + (this.getMetadataDirective() == null ? 0 : this.getMetadataDirective().hashCode());
        hashCode = 31 * hashCode + (this.getModifiedSinceConstraint() == null ? 0 : this.getModifiedSinceConstraint().hashCode());
        hashCode = 31 * hashCode + (this.getNewObjectMetadata() == null ? 0 : this.getNewObjectMetadata().hashCode());
        hashCode = 31 * hashCode + (this.getNewObjectTagging() == null ? 0 : this.getNewObjectTagging().hashCode());
        hashCode = 31 * hashCode + (this.getRedirectLocation() == null ? 0 : this.getRedirectLocation().hashCode());
        hashCode = 31 * hashCode + (this.getRequesterPays() == null ? 0 : this.getRequesterPays().hashCode());
        hashCode = 31 * hashCode + (this.getStorageClass() == null ? 0 : this.getStorageClass().hashCode());
        hashCode = 31 * hashCode + (this.getUnModifiedSinceConstraint() == null ? 0 : this.getUnModifiedSinceConstraint().hashCode());
        hashCode = 31 * hashCode + (this.getSSEAwsKmsKeyId() == null ? 0 : this.getSSEAwsKmsKeyId().hashCode());
        hashCode = 31 * hashCode + (this.getTargetKeyPrefix() == null ? 0 : this.getTargetKeyPrefix().hashCode());
        hashCode = 31 * hashCode + (this.getObjectLockLegalHoldStatus() == null ? 0 : this.getObjectLockLegalHoldStatus().hashCode());
        hashCode = 31 * hashCode + (this.getObjectLockMode() == null ? 0 : this.getObjectLockMode().hashCode());
        hashCode = 31 * hashCode + (this.getObjectLockRetainUntilDate() == null ? 0 : this.getObjectLockRetainUntilDate().hashCode());
        return hashCode;
    }

    public S3CopyObjectOperation clone() {
        try {
            return (S3CopyObjectOperation)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

