/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.DefaultErrorResponseHandler;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.services.s3control.AWSS3Control;
import com.amazonaws.services.s3control.AWSS3ControlClientBuilder;
import com.amazonaws.services.s3control.S3ControlResponseMetadata;
import com.amazonaws.services.s3control.internal.S3ControlStaxResponseHandler;
import com.amazonaws.services.s3control.model.AWSS3ControlException;
import com.amazonaws.services.s3control.model.CreateAccessPointRequest;
import com.amazonaws.services.s3control.model.CreateAccessPointResult;
import com.amazonaws.services.s3control.model.CreateJobRequest;
import com.amazonaws.services.s3control.model.CreateJobResult;
import com.amazonaws.services.s3control.model.DeleteAccessPointPolicyRequest;
import com.amazonaws.services.s3control.model.DeleteAccessPointPolicyResult;
import com.amazonaws.services.s3control.model.DeleteAccessPointRequest;
import com.amazonaws.services.s3control.model.DeleteAccessPointResult;
import com.amazonaws.services.s3control.model.DeletePublicAccessBlockRequest;
import com.amazonaws.services.s3control.model.DeletePublicAccessBlockResult;
import com.amazonaws.services.s3control.model.DescribeJobRequest;
import com.amazonaws.services.s3control.model.DescribeJobResult;
import com.amazonaws.services.s3control.model.GetAccessPointPolicyRequest;
import com.amazonaws.services.s3control.model.GetAccessPointPolicyResult;
import com.amazonaws.services.s3control.model.GetAccessPointPolicyStatusRequest;
import com.amazonaws.services.s3control.model.GetAccessPointPolicyStatusResult;
import com.amazonaws.services.s3control.model.GetAccessPointRequest;
import com.amazonaws.services.s3control.model.GetAccessPointResult;
import com.amazonaws.services.s3control.model.GetPublicAccessBlockRequest;
import com.amazonaws.services.s3control.model.GetPublicAccessBlockResult;
import com.amazonaws.services.s3control.model.ListAccessPointsRequest;
import com.amazonaws.services.s3control.model.ListAccessPointsResult;
import com.amazonaws.services.s3control.model.ListJobsRequest;
import com.amazonaws.services.s3control.model.ListJobsResult;
import com.amazonaws.services.s3control.model.PutAccessPointPolicyRequest;
import com.amazonaws.services.s3control.model.PutAccessPointPolicyResult;
import com.amazonaws.services.s3control.model.PutPublicAccessBlockRequest;
import com.amazonaws.services.s3control.model.PutPublicAccessBlockResult;
import com.amazonaws.services.s3control.model.UpdateJobPriorityRequest;
import com.amazonaws.services.s3control.model.UpdateJobPriorityResult;
import com.amazonaws.services.s3control.model.UpdateJobStatusRequest;
import com.amazonaws.services.s3control.model.UpdateJobStatusResult;
import com.amazonaws.services.s3control.model.transform.BadRequestExceptionUnmarshaller;
import com.amazonaws.services.s3control.model.transform.CreateAccessPointRequestMarshaller;
import com.amazonaws.services.s3control.model.transform.CreateAccessPointResultStaxUnmarshaller;
import com.amazonaws.services.s3control.model.transform.CreateJobRequestMarshaller;
import com.amazonaws.services.s3control.model.transform.CreateJobResultStaxUnmarshaller;
import com.amazonaws.services.s3control.model.transform.DeleteAccessPointPolicyRequestMarshaller;
import com.amazonaws.services.s3control.model.transform.DeleteAccessPointPolicyResultStaxUnmarshaller;
import com.amazonaws.services.s3control.model.transform.DeleteAccessPointRequestMarshaller;
import com.amazonaws.services.s3control.model.transform.DeleteAccessPointResultStaxUnmarshaller;
import com.amazonaws.services.s3control.model.transform.DeletePublicAccessBlockRequestMarshaller;
import com.amazonaws.services.s3control.model.transform.DeletePublicAccessBlockResultStaxUnmarshaller;
import com.amazonaws.services.s3control.model.transform.DescribeJobRequestMarshaller;
import com.amazonaws.services.s3control.model.transform.DescribeJobResultStaxUnmarshaller;
import com.amazonaws.services.s3control.model.transform.GetAccessPointPolicyRequestMarshaller;
import com.amazonaws.services.s3control.model.transform.GetAccessPointPolicyResultStaxUnmarshaller;
import com.amazonaws.services.s3control.model.transform.GetAccessPointPolicyStatusRequestMarshaller;
import com.amazonaws.services.s3control.model.transform.GetAccessPointPolicyStatusResultStaxUnmarshaller;
import com.amazonaws.services.s3control.model.transform.GetAccessPointRequestMarshaller;
import com.amazonaws.services.s3control.model.transform.GetAccessPointResultStaxUnmarshaller;
import com.amazonaws.services.s3control.model.transform.GetPublicAccessBlockRequestMarshaller;
import com.amazonaws.services.s3control.model.transform.GetPublicAccessBlockResultStaxUnmarshaller;
import com.amazonaws.services.s3control.model.transform.IdempotencyExceptionUnmarshaller;
import com.amazonaws.services.s3control.model.transform.InternalServiceExceptionUnmarshaller;
import com.amazonaws.services.s3control.model.transform.InvalidNextTokenExceptionUnmarshaller;
import com.amazonaws.services.s3control.model.transform.InvalidRequestExceptionUnmarshaller;
import com.amazonaws.services.s3control.model.transform.JobStatusExceptionUnmarshaller;
import com.amazonaws.services.s3control.model.transform.ListAccessPointsRequestMarshaller;
import com.amazonaws.services.s3control.model.transform.ListAccessPointsResultStaxUnmarshaller;
import com.amazonaws.services.s3control.model.transform.ListJobsRequestMarshaller;
import com.amazonaws.services.s3control.model.transform.ListJobsResultStaxUnmarshaller;
import com.amazonaws.services.s3control.model.transform.NoSuchPublicAccessBlockConfigurationExceptionUnmarshaller;
import com.amazonaws.services.s3control.model.transform.NotFoundExceptionUnmarshaller;
import com.amazonaws.services.s3control.model.transform.PutAccessPointPolicyRequestMarshaller;
import com.amazonaws.services.s3control.model.transform.PutAccessPointPolicyResultStaxUnmarshaller;
import com.amazonaws.services.s3control.model.transform.PutPublicAccessBlockRequestMarshaller;
import com.amazonaws.services.s3control.model.transform.PutPublicAccessBlockResultStaxUnmarshaller;
import com.amazonaws.services.s3control.model.transform.TooManyRequestsExceptionUnmarshaller;
import com.amazonaws.services.s3control.model.transform.UpdateJobPriorityRequestMarshaller;
import com.amazonaws.services.s3control.model.transform.UpdateJobPriorityResultStaxUnmarshaller;
import com.amazonaws.services.s3control.model.transform.UpdateJobStatusRequestMarshaller;
import com.amazonaws.services.s3control.model.transform.UpdateJobStatusResultStaxUnmarshaller;
import com.amazonaws.transform.StandardErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Node;

@ThreadSafe
public class AWSS3ControlClient
extends AmazonWebServiceClient
implements AWSS3Control {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSS3Control.class);
    private static final String DEFAULT_SIGNING_NAME = "s3";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    protected final List<Unmarshaller<AmazonServiceException, Node>> exceptionUnmarshallers = new ArrayList<Unmarshaller<AmazonServiceException, Node>>();

    public static AWSS3ControlClientBuilder builder() {
        return AWSS3ControlClientBuilder.standard();
    }

    AWSS3ControlClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AWSS3ControlClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new JobStatusExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new InvalidRequestExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new NotFoundExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new IdempotencyExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new NoSuchPublicAccessBlockConfigurationExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new InternalServiceExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new TooManyRequestsExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new InvalidNextTokenExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new BadRequestExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new StandardErrorUnmarshaller(AWSS3ControlException.class));
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix("s3-control");
        this.setEndpoint("s3-control.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/s3control/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/s3control/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public CreateAccessPointResult createAccessPoint(CreateAccessPointRequest request) {
        request = (CreateAccessPointRequest)this.beforeClientExecution(request);
        return this.executeCreateAccessPoint(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateAccessPointResult executeCreateAccessPoint(CreateAccessPointRequest createAccessPointRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createAccessPointRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateAccessPointRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateAccessPointRequestMarshaller().marshall((CreateAccessPointRequest)super.beforeMarshalling((AmazonWebServiceRequest)createAccessPointRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"S3 Control");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateAccessPoint");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            S3ControlStaxResponseHandler<CreateAccessPointResult> responseHandler = new S3ControlStaxResponseHandler<CreateAccessPointResult>(new CreateAccessPointResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            CreateAccessPointResult createAccessPointResult = (CreateAccessPointResult)response.getAwsResponse();
            return createAccessPointResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateJobResult createJob(CreateJobRequest request) {
        request = (CreateJobRequest)this.beforeClientExecution(request);
        return this.executeCreateJob(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateJobResult executeCreateJob(CreateJobRequest createJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateJobRequestMarshaller().marshall((CreateJobRequest)super.beforeMarshalling((AmazonWebServiceRequest)createJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"S3 Control");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateJob");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            S3ControlStaxResponseHandler<CreateJobResult> responseHandler = new S3ControlStaxResponseHandler<CreateJobResult>(new CreateJobResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            CreateJobResult createJobResult = (CreateJobResult)response.getAwsResponse();
            return createJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteAccessPointResult deleteAccessPoint(DeleteAccessPointRequest request) {
        request = (DeleteAccessPointRequest)this.beforeClientExecution(request);
        return this.executeDeleteAccessPoint(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteAccessPointResult executeDeleteAccessPoint(DeleteAccessPointRequest deleteAccessPointRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteAccessPointRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteAccessPointRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteAccessPointRequestMarshaller().marshall((DeleteAccessPointRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteAccessPointRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"S3 Control");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteAccessPoint");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            S3ControlStaxResponseHandler<DeleteAccessPointResult> responseHandler = new S3ControlStaxResponseHandler<DeleteAccessPointResult>(new DeleteAccessPointResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DeleteAccessPointResult deleteAccessPointResult = (DeleteAccessPointResult)response.getAwsResponse();
            return deleteAccessPointResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteAccessPointPolicyResult deleteAccessPointPolicy(DeleteAccessPointPolicyRequest request) {
        request = (DeleteAccessPointPolicyRequest)this.beforeClientExecution(request);
        return this.executeDeleteAccessPointPolicy(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteAccessPointPolicyResult executeDeleteAccessPointPolicy(DeleteAccessPointPolicyRequest deleteAccessPointPolicyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteAccessPointPolicyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteAccessPointPolicyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteAccessPointPolicyRequestMarshaller().marshall((DeleteAccessPointPolicyRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteAccessPointPolicyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"S3 Control");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteAccessPointPolicy");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            S3ControlStaxResponseHandler<DeleteAccessPointPolicyResult> responseHandler = new S3ControlStaxResponseHandler<DeleteAccessPointPolicyResult>(new DeleteAccessPointPolicyResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DeleteAccessPointPolicyResult deleteAccessPointPolicyResult = (DeleteAccessPointPolicyResult)response.getAwsResponse();
            return deleteAccessPointPolicyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeletePublicAccessBlockResult deletePublicAccessBlock(DeletePublicAccessBlockRequest request) {
        request = (DeletePublicAccessBlockRequest)this.beforeClientExecution(request);
        return this.executeDeletePublicAccessBlock(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeletePublicAccessBlockResult executeDeletePublicAccessBlock(DeletePublicAccessBlockRequest deletePublicAccessBlockRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deletePublicAccessBlockRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeletePublicAccessBlockRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeletePublicAccessBlockRequestMarshaller().marshall((DeletePublicAccessBlockRequest)super.beforeMarshalling((AmazonWebServiceRequest)deletePublicAccessBlockRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"S3 Control");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeletePublicAccessBlock");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            S3ControlStaxResponseHandler<DeletePublicAccessBlockResult> responseHandler = new S3ControlStaxResponseHandler<DeletePublicAccessBlockResult>(new DeletePublicAccessBlockResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DeletePublicAccessBlockResult deletePublicAccessBlockResult = (DeletePublicAccessBlockResult)response.getAwsResponse();
            return deletePublicAccessBlockResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeJobResult describeJob(DescribeJobRequest request) {
        request = (DescribeJobRequest)this.beforeClientExecution(request);
        return this.executeDescribeJob(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeJobResult executeDescribeJob(DescribeJobRequest describeJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeJobRequestMarshaller().marshall((DescribeJobRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"S3 Control");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeJob");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            S3ControlStaxResponseHandler<DescribeJobResult> responseHandler = new S3ControlStaxResponseHandler<DescribeJobResult>(new DescribeJobResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DescribeJobResult describeJobResult = (DescribeJobResult)response.getAwsResponse();
            return describeJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetAccessPointResult getAccessPoint(GetAccessPointRequest request) {
        request = (GetAccessPointRequest)this.beforeClientExecution(request);
        return this.executeGetAccessPoint(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetAccessPointResult executeGetAccessPoint(GetAccessPointRequest getAccessPointRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getAccessPointRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetAccessPointRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetAccessPointRequestMarshaller().marshall((GetAccessPointRequest)super.beforeMarshalling((AmazonWebServiceRequest)getAccessPointRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"S3 Control");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetAccessPoint");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            S3ControlStaxResponseHandler<GetAccessPointResult> responseHandler = new S3ControlStaxResponseHandler<GetAccessPointResult>(new GetAccessPointResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            GetAccessPointResult getAccessPointResult = (GetAccessPointResult)response.getAwsResponse();
            return getAccessPointResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetAccessPointPolicyResult getAccessPointPolicy(GetAccessPointPolicyRequest request) {
        request = (GetAccessPointPolicyRequest)this.beforeClientExecution(request);
        return this.executeGetAccessPointPolicy(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetAccessPointPolicyResult executeGetAccessPointPolicy(GetAccessPointPolicyRequest getAccessPointPolicyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getAccessPointPolicyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetAccessPointPolicyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetAccessPointPolicyRequestMarshaller().marshall((GetAccessPointPolicyRequest)super.beforeMarshalling((AmazonWebServiceRequest)getAccessPointPolicyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"S3 Control");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetAccessPointPolicy");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            S3ControlStaxResponseHandler<GetAccessPointPolicyResult> responseHandler = new S3ControlStaxResponseHandler<GetAccessPointPolicyResult>(new GetAccessPointPolicyResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            GetAccessPointPolicyResult getAccessPointPolicyResult = (GetAccessPointPolicyResult)response.getAwsResponse();
            return getAccessPointPolicyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetAccessPointPolicyStatusResult getAccessPointPolicyStatus(GetAccessPointPolicyStatusRequest request) {
        request = (GetAccessPointPolicyStatusRequest)this.beforeClientExecution(request);
        return this.executeGetAccessPointPolicyStatus(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetAccessPointPolicyStatusResult executeGetAccessPointPolicyStatus(GetAccessPointPolicyStatusRequest getAccessPointPolicyStatusRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getAccessPointPolicyStatusRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetAccessPointPolicyStatusRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetAccessPointPolicyStatusRequestMarshaller().marshall((GetAccessPointPolicyStatusRequest)super.beforeMarshalling((AmazonWebServiceRequest)getAccessPointPolicyStatusRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"S3 Control");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetAccessPointPolicyStatus");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            S3ControlStaxResponseHandler<GetAccessPointPolicyStatusResult> responseHandler = new S3ControlStaxResponseHandler<GetAccessPointPolicyStatusResult>(new GetAccessPointPolicyStatusResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            GetAccessPointPolicyStatusResult getAccessPointPolicyStatusResult = (GetAccessPointPolicyStatusResult)response.getAwsResponse();
            return getAccessPointPolicyStatusResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetPublicAccessBlockResult getPublicAccessBlock(GetPublicAccessBlockRequest request) {
        request = (GetPublicAccessBlockRequest)this.beforeClientExecution(request);
        return this.executeGetPublicAccessBlock(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetPublicAccessBlockResult executeGetPublicAccessBlock(GetPublicAccessBlockRequest getPublicAccessBlockRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getPublicAccessBlockRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetPublicAccessBlockRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetPublicAccessBlockRequestMarshaller().marshall((GetPublicAccessBlockRequest)super.beforeMarshalling((AmazonWebServiceRequest)getPublicAccessBlockRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"S3 Control");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetPublicAccessBlock");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            S3ControlStaxResponseHandler<GetPublicAccessBlockResult> responseHandler = new S3ControlStaxResponseHandler<GetPublicAccessBlockResult>(new GetPublicAccessBlockResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            GetPublicAccessBlockResult getPublicAccessBlockResult = (GetPublicAccessBlockResult)response.getAwsResponse();
            return getPublicAccessBlockResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListAccessPointsResult listAccessPoints(ListAccessPointsRequest request) {
        request = (ListAccessPointsRequest)this.beforeClientExecution(request);
        return this.executeListAccessPoints(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListAccessPointsResult executeListAccessPoints(ListAccessPointsRequest listAccessPointsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listAccessPointsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListAccessPointsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListAccessPointsRequestMarshaller().marshall((ListAccessPointsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listAccessPointsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"S3 Control");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListAccessPoints");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            S3ControlStaxResponseHandler<ListAccessPointsResult> responseHandler = new S3ControlStaxResponseHandler<ListAccessPointsResult>(new ListAccessPointsResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            ListAccessPointsResult listAccessPointsResult = (ListAccessPointsResult)response.getAwsResponse();
            return listAccessPointsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListJobsResult listJobs(ListJobsRequest request) {
        request = (ListJobsRequest)this.beforeClientExecution(request);
        return this.executeListJobs(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListJobsResult executeListJobs(ListJobsRequest listJobsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listJobsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListJobsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListJobsRequestMarshaller().marshall((ListJobsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listJobsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"S3 Control");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListJobs");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            S3ControlStaxResponseHandler<ListJobsResult> responseHandler = new S3ControlStaxResponseHandler<ListJobsResult>(new ListJobsResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            ListJobsResult listJobsResult = (ListJobsResult)response.getAwsResponse();
            return listJobsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutAccessPointPolicyResult putAccessPointPolicy(PutAccessPointPolicyRequest request) {
        request = (PutAccessPointPolicyRequest)this.beforeClientExecution(request);
        return this.executePutAccessPointPolicy(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutAccessPointPolicyResult executePutAccessPointPolicy(PutAccessPointPolicyRequest putAccessPointPolicyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putAccessPointPolicyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutAccessPointPolicyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutAccessPointPolicyRequestMarshaller().marshall((PutAccessPointPolicyRequest)super.beforeMarshalling((AmazonWebServiceRequest)putAccessPointPolicyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"S3 Control");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"PutAccessPointPolicy");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            S3ControlStaxResponseHandler<PutAccessPointPolicyResult> responseHandler = new S3ControlStaxResponseHandler<PutAccessPointPolicyResult>(new PutAccessPointPolicyResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            PutAccessPointPolicyResult putAccessPointPolicyResult = (PutAccessPointPolicyResult)response.getAwsResponse();
            return putAccessPointPolicyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutPublicAccessBlockResult putPublicAccessBlock(PutPublicAccessBlockRequest request) {
        request = (PutPublicAccessBlockRequest)this.beforeClientExecution(request);
        return this.executePutPublicAccessBlock(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutPublicAccessBlockResult executePutPublicAccessBlock(PutPublicAccessBlockRequest putPublicAccessBlockRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putPublicAccessBlockRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutPublicAccessBlockRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutPublicAccessBlockRequestMarshaller().marshall((PutPublicAccessBlockRequest)super.beforeMarshalling((AmazonWebServiceRequest)putPublicAccessBlockRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"S3 Control");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"PutPublicAccessBlock");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            S3ControlStaxResponseHandler<PutPublicAccessBlockResult> responseHandler = new S3ControlStaxResponseHandler<PutPublicAccessBlockResult>(new PutPublicAccessBlockResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            PutPublicAccessBlockResult putPublicAccessBlockResult = (PutPublicAccessBlockResult)response.getAwsResponse();
            return putPublicAccessBlockResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateJobPriorityResult updateJobPriority(UpdateJobPriorityRequest request) {
        request = (UpdateJobPriorityRequest)this.beforeClientExecution(request);
        return this.executeUpdateJobPriority(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateJobPriorityResult executeUpdateJobPriority(UpdateJobPriorityRequest updateJobPriorityRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateJobPriorityRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateJobPriorityRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateJobPriorityRequestMarshaller().marshall((UpdateJobPriorityRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateJobPriorityRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"S3 Control");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateJobPriority");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            S3ControlStaxResponseHandler<UpdateJobPriorityResult> responseHandler = new S3ControlStaxResponseHandler<UpdateJobPriorityResult>(new UpdateJobPriorityResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            UpdateJobPriorityResult updateJobPriorityResult = (UpdateJobPriorityResult)response.getAwsResponse();
            return updateJobPriorityResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateJobStatusResult updateJobStatus(UpdateJobStatusRequest request) {
        request = (UpdateJobStatusRequest)this.beforeClientExecution(request);
        return this.executeUpdateJobStatus(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateJobStatusResult executeUpdateJobStatus(UpdateJobStatusRequest updateJobStatusRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateJobStatusRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateJobStatusRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateJobStatusRequestMarshaller().marshall((UpdateJobStatusRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateJobStatusRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"S3 Control");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateJobStatus");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            S3ControlStaxResponseHandler<UpdateJobStatusResult> responseHandler = new S3ControlStaxResponseHandler<UpdateJobStatusResult>(new UpdateJobStatusResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            UpdateJobStatusResult updateJobStatusResult = (UpdateJobStatusResult)response.getAwsResponse();
            return updateJobStatusResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public S3ControlResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        ResponseMetadata metadata = this.client.getResponseMetadataForRequest(request);
        if (metadata != null) {
            return new S3ControlResponseMetadata(metadata);
        }
        return null;
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.client.execute(request, responseHandler, (HttpResponseHandler)errorResponseHandler, executionContext);
    }
}

