/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.internal.handlers;

import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.handlers.RequestHandler2;
import com.amazonaws.services.s3control.S3ControlClientOptions;
import java.net.URI;
import java.net.URISyntaxException;

@SdkInternalApi
public final class EndpointHandler
extends RequestHandler2 {
    private static final String X_AMZ_ACCOUNT_ID = "x-amz-account-id";

    public void beforeRequest(Request<?> request) {
        if (!request.getHeaders().containsKey(X_AMZ_ACCOUNT_ID)) {
            throw new SdkClientException("Account ID must be specified for all requests");
        }
        String accountId = (String)request.getHeaders().remove(X_AMZ_ACCOUNT_ID);
        URI endpoint = request.getEndpoint();
        String host = this.resolveHost(request, accountId);
        try {
            request.setEndpoint(new URI(endpoint.getScheme(), endpoint.getUserInfo(), host, endpoint.getPort(), endpoint.getPath(), endpoint.getQuery(), endpoint.getFragment()));
        }
        catch (URISyntaxException e) {
            throw new SdkClientException(String.format("Endpoint was invalid, account id (%s) is likely incorrect", accountId), (Throwable)e);
        }
    }

    private String resolveHost(Request<?> request, String accountId) {
        if (this.isDualstackEnabled(request) && this.isFipsEnabled(request)) {
            throw new SdkClientException("Cannot use both Dual-Stack endpoints and FIPS endpoints");
        }
        String host = request.getEndpoint().getHost();
        if (this.isDualstackEnabled(request)) {
            if (!host.contains("s3-control")) {
                throw new SdkClientException(String.format("The Dual-Stack option cannot be used with custom endpoints (%s)", request.getEndpoint()));
            }
            host = host.replace("s3-control", String.format("%s.%s", "s3-control", "dualstack"));
        } else if (this.isFipsEnabled(request)) {
            if (!host.contains("s3-control")) {
                throw new SdkClientException(String.format("The FIPS option cannot be used with custom endpoints (%s)", request.getEndpoint()));
            }
            host = host.replace("s3-control", String.format("%s-%s", "s3-control", "fips"));
        }
        return String.format("%s.%s", accountId, host);
    }

    private boolean isDualstackEnabled(Request<?> request) {
        return this.isAdvancedConfigFlagTrue(request, S3ControlClientOptions.DUALSTACK_ENABLED);
    }

    private boolean isFipsEnabled(Request<?> request) {
        return this.isAdvancedConfigFlagTrue(request, S3ControlClientOptions.FIPS_ENABLED);
    }

    private boolean isAdvancedConfigFlagTrue(Request<?> request, AdvancedConfig.Key<Boolean> key) {
        AdvancedConfig advancedConfig = (AdvancedConfig)request.getHandlerContext(HandlerContextKey.ADVANCED_CONFIG);
        if (advancedConfig == null) {
            return false;
        }
        Boolean flag = (Boolean)advancedConfig.get(key);
        return Boolean.TRUE.equals(flag);
    }
}

