/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.s3control.model.UpdateJobPriorityRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import com.amazonaws.util.StringUtils;

public class UpdateJobPriorityRequestMarshaller
implements Marshaller<Request<UpdateJobPriorityRequest>, UpdateJobPriorityRequest> {
    public Request<UpdateJobPriorityRequest> marshall(UpdateJobPriorityRequest updateJobPriorityRequest) {
        if (updateJobPriorityRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateJobPriorityRequest, "AWSS3Control");
        request.setHttpMethod(HttpMethodName.POST);
        if (updateJobPriorityRequest.getAccountId() != null) {
            request.addHeader("x-amz-account-id", StringUtils.fromString((String)updateJobPriorityRequest.getAccountId()));
        }
        String uriResourcePath = "/v20180820/jobs/{id}/priority";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "id", updateJobPriorityRequest.getJobId());
        request.setResourcePath(uriResourcePath);
        if (updateJobPriorityRequest.getPriority() != null) {
            request.addParameter("priority", StringUtils.fromInteger((Integer)updateJobPriorityRequest.getPriority()));
        }
        return request;
    }
}

