/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.s3control.model.DeleteBucketTaggingRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import com.amazonaws.util.StringUtils;

public class DeleteBucketTaggingRequestMarshaller
implements Marshaller<Request<DeleteBucketTaggingRequest>, DeleteBucketTaggingRequest> {
    public Request<DeleteBucketTaggingRequest> marshall(DeleteBucketTaggingRequest deleteBucketTaggingRequest) {
        if (deleteBucketTaggingRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deleteBucketTaggingRequest, "AWSS3Control");
        request.setHttpMethod(HttpMethodName.DELETE);
        if (deleteBucketTaggingRequest.getAccountId() != null) {
            request.addHeader("x-amz-account-id", StringUtils.fromString((String)deleteBucketTaggingRequest.getAccountId()));
        }
        String uriResourcePath = "/v20180820/bucket/{name}/tagging";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "name", deleteBucketTaggingRequest.getBucket());
        request.setResourcePath(uriResourcePath);
        return request;
    }
}

