/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53domains.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.route53domains.model.ListDomainsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class ListDomainsRequestMarshaller
implements Marshaller<Request<ListDomainsRequest>, ListDomainsRequest> {
    public Request<ListDomainsRequest> marshall(ListDomainsRequest listDomainsRequest) {
        if (listDomainsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listDomainsRequest, "AmazonRoute53Domains");
        request.addHeader("X-Amz-Target", "Route53Domains_v20140515.ListDomains");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkJsonGenerator jsonGenerator = new SdkJsonGenerator();
            jsonGenerator.writeStartObject();
            if (listDomainsRequest.getMarker() != null) {
                jsonGenerator.writeFieldName("Marker").writeValue(listDomainsRequest.getMarker());
            }
            if (listDomainsRequest.getMaxItems() != null) {
                jsonGenerator.writeFieldName("MaxItems").writeValue((long)listDomainsRequest.getMaxItems().intValue());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

