/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53domains.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.route53domains.model.Nameserver;
import com.amazonaws.services.route53domains.model.TransferDomainRequest;
import com.amazonaws.services.route53domains.model.transform.ContactDetailJsonMarshaller;
import com.amazonaws.services.route53domains.model.transform.NameserverJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class TransferDomainRequestMarshaller
implements Marshaller<Request<TransferDomainRequest>, TransferDomainRequest> {
    public Request<TransferDomainRequest> marshall(TransferDomainRequest transferDomainRequest) {
        if (transferDomainRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)transferDomainRequest, "AmazonRoute53Domains");
        request.addHeader("X-Amz-Target", "Route53Domains_v20140515.TransferDomain");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList nameserversList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (transferDomainRequest.getDomainName() != null) {
                jsonWriter.key("DomainName").value((Object)transferDomainRequest.getDomainName());
            }
            if (transferDomainRequest.getIdnLangCode() != null) {
                jsonWriter.key("IdnLangCode").value((Object)transferDomainRequest.getIdnLangCode());
            }
            if (transferDomainRequest.getDurationInYears() != null) {
                jsonWriter.key("DurationInYears").value((Object)transferDomainRequest.getDurationInYears());
            }
            if (!(nameserversList = (SdkInternalList)transferDomainRequest.getNameservers()).isEmpty() || !nameserversList.isAutoConstruct()) {
                jsonWriter.key("Nameservers");
                jsonWriter.array();
                for (Nameserver nameserversListValue : nameserversList) {
                    if (nameserversListValue == null) continue;
                    NameserverJsonMarshaller.getInstance().marshall(nameserversListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (transferDomainRequest.getAuthCode() != null) {
                jsonWriter.key("AuthCode").value((Object)transferDomainRequest.getAuthCode());
            }
            if (transferDomainRequest.getAutoRenew() != null) {
                jsonWriter.key("AutoRenew").value((Object)transferDomainRequest.getAutoRenew());
            }
            if (transferDomainRequest.getAdminContact() != null) {
                jsonWriter.key("AdminContact");
                ContactDetailJsonMarshaller.getInstance().marshall(transferDomainRequest.getAdminContact(), jsonWriter);
            }
            if (transferDomainRequest.getRegistrantContact() != null) {
                jsonWriter.key("RegistrantContact");
                ContactDetailJsonMarshaller.getInstance().marshall(transferDomainRequest.getRegistrantContact(), jsonWriter);
            }
            if (transferDomainRequest.getTechContact() != null) {
                jsonWriter.key("TechContact");
                ContactDetailJsonMarshaller.getInstance().marshall(transferDomainRequest.getTechContact(), jsonWriter);
            }
            if (transferDomainRequest.getPrivacyProtectAdminContact() != null) {
                jsonWriter.key("PrivacyProtectAdminContact").value((Object)transferDomainRequest.getPrivacyProtectAdminContact());
            }
            if (transferDomainRequest.getPrivacyProtectRegistrantContact() != null) {
                jsonWriter.key("PrivacyProtectRegistrantContact").value((Object)transferDomainRequest.getPrivacyProtectRegistrantContact());
            }
            if (transferDomainRequest.getPrivacyProtectTechContact() != null) {
                jsonWriter.key("PrivacyProtectTechContact").value((Object)transferDomainRequest.getPrivacyProtectTechContact());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

