/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.robomaker.model;

import com.amazonaws.AmazonWebServiceRequest;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateRobotApplicationVersionRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String application;
    private String currentRevisionId;
    private List<String> s3Etags;
    private String imageDigest;

    public void setApplication(String application) {
        this.application = application;
    }

    public String getApplication() {
        return this.application;
    }

    public CreateRobotApplicationVersionRequest withApplication(String application) {
        this.setApplication(application);
        return this;
    }

    public void setCurrentRevisionId(String currentRevisionId) {
        this.currentRevisionId = currentRevisionId;
    }

    public String getCurrentRevisionId() {
        return this.currentRevisionId;
    }

    public CreateRobotApplicationVersionRequest withCurrentRevisionId(String currentRevisionId) {
        this.setCurrentRevisionId(currentRevisionId);
        return this;
    }

    public List<String> getS3Etags() {
        return this.s3Etags;
    }

    public void setS3Etags(Collection<String> s3Etags) {
        if (s3Etags == null) {
            this.s3Etags = null;
            return;
        }
        this.s3Etags = new ArrayList<String>(s3Etags);
    }

    public CreateRobotApplicationVersionRequest withS3Etags(String ... s3Etags) {
        if (this.s3Etags == null) {
            this.setS3Etags(new ArrayList<String>(s3Etags.length));
        }
        for (String ele : s3Etags) {
            this.s3Etags.add(ele);
        }
        return this;
    }

    public CreateRobotApplicationVersionRequest withS3Etags(Collection<String> s3Etags) {
        this.setS3Etags(s3Etags);
        return this;
    }

    public void setImageDigest(String imageDigest) {
        this.imageDigest = imageDigest;
    }

    public String getImageDigest() {
        return this.imageDigest;
    }

    public CreateRobotApplicationVersionRequest withImageDigest(String imageDigest) {
        this.setImageDigest(imageDigest);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getApplication() != null) {
            sb.append("Application: ").append(this.getApplication()).append(",");
        }
        if (this.getCurrentRevisionId() != null) {
            sb.append("CurrentRevisionId: ").append(this.getCurrentRevisionId()).append(",");
        }
        if (this.getS3Etags() != null) {
            sb.append("S3Etags: ").append(this.getS3Etags()).append(",");
        }
        if (this.getImageDigest() != null) {
            sb.append("ImageDigest: ").append(this.getImageDigest());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRobotApplicationVersionRequest)) {
            return false;
        }
        CreateRobotApplicationVersionRequest other = (CreateRobotApplicationVersionRequest)obj;
        if (other.getApplication() == null ^ this.getApplication() == null) {
            return false;
        }
        if (other.getApplication() != null && !other.getApplication().equals(this.getApplication())) {
            return false;
        }
        if (other.getCurrentRevisionId() == null ^ this.getCurrentRevisionId() == null) {
            return false;
        }
        if (other.getCurrentRevisionId() != null && !other.getCurrentRevisionId().equals(this.getCurrentRevisionId())) {
            return false;
        }
        if (other.getS3Etags() == null ^ this.getS3Etags() == null) {
            return false;
        }
        if (other.getS3Etags() != null && !other.getS3Etags().equals(this.getS3Etags())) {
            return false;
        }
        if (other.getImageDigest() == null ^ this.getImageDigest() == null) {
            return false;
        }
        return other.getImageDigest() == null || other.getImageDigest().equals(this.getImageDigest());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getApplication() == null ? 0 : this.getApplication().hashCode());
        hashCode = 31 * hashCode + (this.getCurrentRevisionId() == null ? 0 : this.getCurrentRevisionId().hashCode());
        hashCode = 31 * hashCode + (this.getS3Etags() == null ? 0 : this.getS3Etags().hashCode());
        hashCode = 31 * hashCode + (this.getImageDigest() == null ? 0 : this.getImageDigest().hashCode());
        return hashCode;
    }

    public CreateRobotApplicationVersionRequest clone() {
        return (CreateRobotApplicationVersionRequest)super.clone();
    }
}

