/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.robomaker.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.robomaker.model.LaunchConfig;
import com.amazonaws.services.robomaker.model.Tool;
import com.amazonaws.services.robomaker.model.UploadConfiguration;
import com.amazonaws.services.robomaker.model.WorldConfig;
import com.amazonaws.services.robomaker.model.transform.SimulationApplicationConfigMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SimulationApplicationConfig
implements Serializable,
Cloneable,
StructuredPojo {
    private String application;
    private String applicationVersion;
    private LaunchConfig launchConfig;
    private List<UploadConfiguration> uploadConfigurations;
    private List<WorldConfig> worldConfigs;
    private Boolean useDefaultUploadConfigurations;
    private List<Tool> tools;
    private Boolean useDefaultTools;

    public void setApplication(String application) {
        this.application = application;
    }

    public String getApplication() {
        return this.application;
    }

    public SimulationApplicationConfig withApplication(String application) {
        this.setApplication(application);
        return this;
    }

    public void setApplicationVersion(String applicationVersion) {
        this.applicationVersion = applicationVersion;
    }

    public String getApplicationVersion() {
        return this.applicationVersion;
    }

    public SimulationApplicationConfig withApplicationVersion(String applicationVersion) {
        this.setApplicationVersion(applicationVersion);
        return this;
    }

    public void setLaunchConfig(LaunchConfig launchConfig) {
        this.launchConfig = launchConfig;
    }

    public LaunchConfig getLaunchConfig() {
        return this.launchConfig;
    }

    public SimulationApplicationConfig withLaunchConfig(LaunchConfig launchConfig) {
        this.setLaunchConfig(launchConfig);
        return this;
    }

    public List<UploadConfiguration> getUploadConfigurations() {
        return this.uploadConfigurations;
    }

    public void setUploadConfigurations(Collection<UploadConfiguration> uploadConfigurations) {
        if (uploadConfigurations == null) {
            this.uploadConfigurations = null;
            return;
        }
        this.uploadConfigurations = new ArrayList<UploadConfiguration>(uploadConfigurations);
    }

    public SimulationApplicationConfig withUploadConfigurations(UploadConfiguration ... uploadConfigurations) {
        if (this.uploadConfigurations == null) {
            this.setUploadConfigurations(new ArrayList<UploadConfiguration>(uploadConfigurations.length));
        }
        for (UploadConfiguration ele : uploadConfigurations) {
            this.uploadConfigurations.add(ele);
        }
        return this;
    }

    public SimulationApplicationConfig withUploadConfigurations(Collection<UploadConfiguration> uploadConfigurations) {
        this.setUploadConfigurations(uploadConfigurations);
        return this;
    }

    public List<WorldConfig> getWorldConfigs() {
        return this.worldConfigs;
    }

    public void setWorldConfigs(Collection<WorldConfig> worldConfigs) {
        if (worldConfigs == null) {
            this.worldConfigs = null;
            return;
        }
        this.worldConfigs = new ArrayList<WorldConfig>(worldConfigs);
    }

    public SimulationApplicationConfig withWorldConfigs(WorldConfig ... worldConfigs) {
        if (this.worldConfigs == null) {
            this.setWorldConfigs(new ArrayList<WorldConfig>(worldConfigs.length));
        }
        for (WorldConfig ele : worldConfigs) {
            this.worldConfigs.add(ele);
        }
        return this;
    }

    public SimulationApplicationConfig withWorldConfigs(Collection<WorldConfig> worldConfigs) {
        this.setWorldConfigs(worldConfigs);
        return this;
    }

    public void setUseDefaultUploadConfigurations(Boolean useDefaultUploadConfigurations) {
        this.useDefaultUploadConfigurations = useDefaultUploadConfigurations;
    }

    public Boolean getUseDefaultUploadConfigurations() {
        return this.useDefaultUploadConfigurations;
    }

    public SimulationApplicationConfig withUseDefaultUploadConfigurations(Boolean useDefaultUploadConfigurations) {
        this.setUseDefaultUploadConfigurations(useDefaultUploadConfigurations);
        return this;
    }

    public Boolean isUseDefaultUploadConfigurations() {
        return this.useDefaultUploadConfigurations;
    }

    public List<Tool> getTools() {
        return this.tools;
    }

    public void setTools(Collection<Tool> tools) {
        if (tools == null) {
            this.tools = null;
            return;
        }
        this.tools = new ArrayList<Tool>(tools);
    }

    public SimulationApplicationConfig withTools(Tool ... tools) {
        if (this.tools == null) {
            this.setTools(new ArrayList<Tool>(tools.length));
        }
        for (Tool ele : tools) {
            this.tools.add(ele);
        }
        return this;
    }

    public SimulationApplicationConfig withTools(Collection<Tool> tools) {
        this.setTools(tools);
        return this;
    }

    public void setUseDefaultTools(Boolean useDefaultTools) {
        this.useDefaultTools = useDefaultTools;
    }

    public Boolean getUseDefaultTools() {
        return this.useDefaultTools;
    }

    public SimulationApplicationConfig withUseDefaultTools(Boolean useDefaultTools) {
        this.setUseDefaultTools(useDefaultTools);
        return this;
    }

    public Boolean isUseDefaultTools() {
        return this.useDefaultTools;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getApplication() != null) {
            sb.append("Application: ").append(this.getApplication()).append(",");
        }
        if (this.getApplicationVersion() != null) {
            sb.append("ApplicationVersion: ").append(this.getApplicationVersion()).append(",");
        }
        if (this.getLaunchConfig() != null) {
            sb.append("LaunchConfig: ").append(this.getLaunchConfig()).append(",");
        }
        if (this.getUploadConfigurations() != null) {
            sb.append("UploadConfigurations: ").append(this.getUploadConfigurations()).append(",");
        }
        if (this.getWorldConfigs() != null) {
            sb.append("WorldConfigs: ").append(this.getWorldConfigs()).append(",");
        }
        if (this.getUseDefaultUploadConfigurations() != null) {
            sb.append("UseDefaultUploadConfigurations: ").append(this.getUseDefaultUploadConfigurations()).append(",");
        }
        if (this.getTools() != null) {
            sb.append("Tools: ").append(this.getTools()).append(",");
        }
        if (this.getUseDefaultTools() != null) {
            sb.append("UseDefaultTools: ").append(this.getUseDefaultTools());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SimulationApplicationConfig)) {
            return false;
        }
        SimulationApplicationConfig other = (SimulationApplicationConfig)obj;
        if (other.getApplication() == null ^ this.getApplication() == null) {
            return false;
        }
        if (other.getApplication() != null && !other.getApplication().equals(this.getApplication())) {
            return false;
        }
        if (other.getApplicationVersion() == null ^ this.getApplicationVersion() == null) {
            return false;
        }
        if (other.getApplicationVersion() != null && !other.getApplicationVersion().equals(this.getApplicationVersion())) {
            return false;
        }
        if (other.getLaunchConfig() == null ^ this.getLaunchConfig() == null) {
            return false;
        }
        if (other.getLaunchConfig() != null && !other.getLaunchConfig().equals(this.getLaunchConfig())) {
            return false;
        }
        if (other.getUploadConfigurations() == null ^ this.getUploadConfigurations() == null) {
            return false;
        }
        if (other.getUploadConfigurations() != null && !other.getUploadConfigurations().equals(this.getUploadConfigurations())) {
            return false;
        }
        if (other.getWorldConfigs() == null ^ this.getWorldConfigs() == null) {
            return false;
        }
        if (other.getWorldConfigs() != null && !other.getWorldConfigs().equals(this.getWorldConfigs())) {
            return false;
        }
        if (other.getUseDefaultUploadConfigurations() == null ^ this.getUseDefaultUploadConfigurations() == null) {
            return false;
        }
        if (other.getUseDefaultUploadConfigurations() != null && !other.getUseDefaultUploadConfigurations().equals(this.getUseDefaultUploadConfigurations())) {
            return false;
        }
        if (other.getTools() == null ^ this.getTools() == null) {
            return false;
        }
        if (other.getTools() != null && !other.getTools().equals(this.getTools())) {
            return false;
        }
        if (other.getUseDefaultTools() == null ^ this.getUseDefaultTools() == null) {
            return false;
        }
        return other.getUseDefaultTools() == null || other.getUseDefaultTools().equals(this.getUseDefaultTools());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getApplication() == null ? 0 : this.getApplication().hashCode());
        hashCode = 31 * hashCode + (this.getApplicationVersion() == null ? 0 : this.getApplicationVersion().hashCode());
        hashCode = 31 * hashCode + (this.getLaunchConfig() == null ? 0 : this.getLaunchConfig().hashCode());
        hashCode = 31 * hashCode + (this.getUploadConfigurations() == null ? 0 : this.getUploadConfigurations().hashCode());
        hashCode = 31 * hashCode + (this.getWorldConfigs() == null ? 0 : this.getWorldConfigs().hashCode());
        hashCode = 31 * hashCode + (this.getUseDefaultUploadConfigurations() == null ? 0 : this.getUseDefaultUploadConfigurations().hashCode());
        hashCode = 31 * hashCode + (this.getTools() == null ? 0 : this.getTools().hashCode());
        hashCode = 31 * hashCode + (this.getUseDefaultTools() == null ? 0 : this.getUseDefaultTools().hashCode());
        return hashCode;
    }

    public SimulationApplicationConfig clone() {
        try {
            return (SimulationApplicationConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SimulationApplicationConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

