/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.robomaker.model.transform;

import com.amazonaws.services.robomaker.model.DataSourceConfig;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.ListUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.fasterxml.jackson.core.JsonToken;

public class DataSourceConfigJsonUnmarshaller
implements Unmarshaller<DataSourceConfig, JsonUnmarshallerContext> {
    private static DataSourceConfigJsonUnmarshaller instance;

    public DataSourceConfig unmarshall(JsonUnmarshallerContext context) throws Exception {
        DataSourceConfig dataSourceConfig = new DataSourceConfig();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("name", targetDepth)) {
                    context.nextToken();
                    dataSourceConfig.setName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("s3Bucket", targetDepth)) {
                    context.nextToken();
                    dataSourceConfig.setS3Bucket((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("s3Keys", targetDepth)) {
                    context.nextToken();
                    dataSourceConfig.setS3Keys(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("type", targetDepth)) {
                    context.nextToken();
                    dataSourceConfig.setType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("destination", targetDepth)) {
                    context.nextToken();
                    dataSourceConfig.setDestination((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return dataSourceConfig;
    }

    public static DataSourceConfigJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new DataSourceConfigJsonUnmarshaller();
        }
        return instance;
    }
}

