/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.robomaker.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.robomaker.model.LaunchConfig;
import java.util.Map;

@SdkInternalApi
public class LaunchConfigMarshaller {
    private static final MarshallingInfo<String> PACKAGENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("packageName").build();
    private static final MarshallingInfo<String> LAUNCHFILE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("launchFile").build();
    private static final MarshallingInfo<Map> ENVIRONMENTVARIABLES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("environmentVariables").build();
    private static final LaunchConfigMarshaller instance = new LaunchConfigMarshaller();

    public static LaunchConfigMarshaller getInstance() {
        return instance;
    }

    public void marshall(LaunchConfig launchConfig, ProtocolMarshaller protocolMarshaller) {
        if (launchConfig == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)launchConfig.getPackageName(), PACKAGENAME_BINDING);
            protocolMarshaller.marshall((Object)launchConfig.getLaunchFile(), LAUNCHFILE_BINDING);
            protocolMarshaller.marshall(launchConfig.getEnvironmentVariables(), ENVIRONMENTVARIABLES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

