/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.robomaker.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.robomaker.model.DeploymentApplicationConfig;
import com.amazonaws.services.robomaker.model.DeploymentConfig;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateDeploymentJobRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private DeploymentConfig deploymentConfig;
    private String clientRequestToken;
    private String fleet;
    private List<DeploymentApplicationConfig> deploymentApplicationConfigs;

    public void setDeploymentConfig(DeploymentConfig deploymentConfig) {
        this.deploymentConfig = deploymentConfig;
    }

    public DeploymentConfig getDeploymentConfig() {
        return this.deploymentConfig;
    }

    public CreateDeploymentJobRequest withDeploymentConfig(DeploymentConfig deploymentConfig) {
        this.setDeploymentConfig(deploymentConfig);
        return this;
    }

    public void setClientRequestToken(String clientRequestToken) {
        this.clientRequestToken = clientRequestToken;
    }

    public String getClientRequestToken() {
        return this.clientRequestToken;
    }

    public CreateDeploymentJobRequest withClientRequestToken(String clientRequestToken) {
        this.setClientRequestToken(clientRequestToken);
        return this;
    }

    public void setFleet(String fleet) {
        this.fleet = fleet;
    }

    public String getFleet() {
        return this.fleet;
    }

    public CreateDeploymentJobRequest withFleet(String fleet) {
        this.setFleet(fleet);
        return this;
    }

    public List<DeploymentApplicationConfig> getDeploymentApplicationConfigs() {
        return this.deploymentApplicationConfigs;
    }

    public void setDeploymentApplicationConfigs(Collection<DeploymentApplicationConfig> deploymentApplicationConfigs) {
        if (deploymentApplicationConfigs == null) {
            this.deploymentApplicationConfigs = null;
            return;
        }
        this.deploymentApplicationConfigs = new ArrayList<DeploymentApplicationConfig>(deploymentApplicationConfigs);
    }

    public CreateDeploymentJobRequest withDeploymentApplicationConfigs(DeploymentApplicationConfig ... deploymentApplicationConfigs) {
        if (this.deploymentApplicationConfigs == null) {
            this.setDeploymentApplicationConfigs(new ArrayList<DeploymentApplicationConfig>(deploymentApplicationConfigs.length));
        }
        for (DeploymentApplicationConfig ele : deploymentApplicationConfigs) {
            this.deploymentApplicationConfigs.add(ele);
        }
        return this;
    }

    public CreateDeploymentJobRequest withDeploymentApplicationConfigs(Collection<DeploymentApplicationConfig> deploymentApplicationConfigs) {
        this.setDeploymentApplicationConfigs(deploymentApplicationConfigs);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDeploymentConfig() != null) {
            sb.append("DeploymentConfig: ").append(this.getDeploymentConfig()).append(",");
        }
        if (this.getClientRequestToken() != null) {
            sb.append("ClientRequestToken: ").append(this.getClientRequestToken()).append(",");
        }
        if (this.getFleet() != null) {
            sb.append("Fleet: ").append(this.getFleet()).append(",");
        }
        if (this.getDeploymentApplicationConfigs() != null) {
            sb.append("DeploymentApplicationConfigs: ").append(this.getDeploymentApplicationConfigs());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDeploymentJobRequest)) {
            return false;
        }
        CreateDeploymentJobRequest other = (CreateDeploymentJobRequest)obj;
        if (other.getDeploymentConfig() == null ^ this.getDeploymentConfig() == null) {
            return false;
        }
        if (other.getDeploymentConfig() != null && !other.getDeploymentConfig().equals(this.getDeploymentConfig())) {
            return false;
        }
        if (other.getClientRequestToken() == null ^ this.getClientRequestToken() == null) {
            return false;
        }
        if (other.getClientRequestToken() != null && !other.getClientRequestToken().equals(this.getClientRequestToken())) {
            return false;
        }
        if (other.getFleet() == null ^ this.getFleet() == null) {
            return false;
        }
        if (other.getFleet() != null && !other.getFleet().equals(this.getFleet())) {
            return false;
        }
        if (other.getDeploymentApplicationConfigs() == null ^ this.getDeploymentApplicationConfigs() == null) {
            return false;
        }
        return other.getDeploymentApplicationConfigs() == null || other.getDeploymentApplicationConfigs().equals(this.getDeploymentApplicationConfigs());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDeploymentConfig() == null ? 0 : this.getDeploymentConfig().hashCode());
        hashCode = 31 * hashCode + (this.getClientRequestToken() == null ? 0 : this.getClientRequestToken().hashCode());
        hashCode = 31 * hashCode + (this.getFleet() == null ? 0 : this.getFleet().hashCode());
        hashCode = 31 * hashCode + (this.getDeploymentApplicationConfigs() == null ? 0 : this.getDeploymentApplicationConfigs().hashCode());
        return hashCode;
    }

    public CreateDeploymentJobRequest clone() {
        return (CreateDeploymentJobRequest)super.clone();
    }
}

