/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.resourcegroups.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.resourcegroups.model.GroupConfigurationItem;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PutGroupConfigurationRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String group;
    private List<GroupConfigurationItem> configuration;

    public void setGroup(String group) {
        this.group = group;
    }

    public String getGroup() {
        return this.group;
    }

    public PutGroupConfigurationRequest withGroup(String group) {
        this.setGroup(group);
        return this;
    }

    public List<GroupConfigurationItem> getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Collection<GroupConfigurationItem> configuration) {
        if (configuration == null) {
            this.configuration = null;
            return;
        }
        this.configuration = new ArrayList<GroupConfigurationItem>(configuration);
    }

    public PutGroupConfigurationRequest withConfiguration(GroupConfigurationItem ... configuration) {
        if (this.configuration == null) {
            this.setConfiguration(new ArrayList<GroupConfigurationItem>(configuration.length));
        }
        for (GroupConfigurationItem ele : configuration) {
            this.configuration.add(ele);
        }
        return this;
    }

    public PutGroupConfigurationRequest withConfiguration(Collection<GroupConfigurationItem> configuration) {
        this.setConfiguration(configuration);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getGroup() != null) {
            sb.append("Group: ").append(this.getGroup()).append(",");
        }
        if (this.getConfiguration() != null) {
            sb.append("Configuration: ").append(this.getConfiguration());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutGroupConfigurationRequest)) {
            return false;
        }
        PutGroupConfigurationRequest other = (PutGroupConfigurationRequest)obj;
        if (other.getGroup() == null ^ this.getGroup() == null) {
            return false;
        }
        if (other.getGroup() != null && !other.getGroup().equals(this.getGroup())) {
            return false;
        }
        if (other.getConfiguration() == null ^ this.getConfiguration() == null) {
            return false;
        }
        return other.getConfiguration() == null || other.getConfiguration().equals(this.getConfiguration());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getGroup() == null ? 0 : this.getGroup().hashCode());
        hashCode = 31 * hashCode + (this.getConfiguration() == null ? 0 : this.getConfiguration().hashCode());
        return hashCode;
    }

    public PutGroupConfigurationRequest clone() {
        return (PutGroupConfigurationRequest)super.clone();
    }
}

