/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.resourcegroups;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.resourcegroups.AWSResourceGroups;
import com.amazonaws.services.resourcegroups.AWSResourceGroupsClientBuilder;
import com.amazonaws.services.resourcegroups.model.AWSResourceGroupsException;
import com.amazonaws.services.resourcegroups.model.BadRequestException;
import com.amazonaws.services.resourcegroups.model.CreateGroupRequest;
import com.amazonaws.services.resourcegroups.model.CreateGroupResult;
import com.amazonaws.services.resourcegroups.model.DeleteGroupRequest;
import com.amazonaws.services.resourcegroups.model.DeleteGroupResult;
import com.amazonaws.services.resourcegroups.model.ForbiddenException;
import com.amazonaws.services.resourcegroups.model.GetGroupQueryRequest;
import com.amazonaws.services.resourcegroups.model.GetGroupQueryResult;
import com.amazonaws.services.resourcegroups.model.GetGroupRequest;
import com.amazonaws.services.resourcegroups.model.GetGroupResult;
import com.amazonaws.services.resourcegroups.model.GetTagsRequest;
import com.amazonaws.services.resourcegroups.model.GetTagsResult;
import com.amazonaws.services.resourcegroups.model.InternalServerErrorException;
import com.amazonaws.services.resourcegroups.model.ListGroupResourcesRequest;
import com.amazonaws.services.resourcegroups.model.ListGroupResourcesResult;
import com.amazonaws.services.resourcegroups.model.ListGroupsRequest;
import com.amazonaws.services.resourcegroups.model.ListGroupsResult;
import com.amazonaws.services.resourcegroups.model.MethodNotAllowedException;
import com.amazonaws.services.resourcegroups.model.NotFoundException;
import com.amazonaws.services.resourcegroups.model.SearchResourcesRequest;
import com.amazonaws.services.resourcegroups.model.SearchResourcesResult;
import com.amazonaws.services.resourcegroups.model.TagRequest;
import com.amazonaws.services.resourcegroups.model.TagResult;
import com.amazonaws.services.resourcegroups.model.TooManyRequestsException;
import com.amazonaws.services.resourcegroups.model.UnauthorizedException;
import com.amazonaws.services.resourcegroups.model.UntagRequest;
import com.amazonaws.services.resourcegroups.model.UntagResult;
import com.amazonaws.services.resourcegroups.model.UpdateGroupQueryRequest;
import com.amazonaws.services.resourcegroups.model.UpdateGroupQueryResult;
import com.amazonaws.services.resourcegroups.model.UpdateGroupRequest;
import com.amazonaws.services.resourcegroups.model.UpdateGroupResult;
import com.amazonaws.services.resourcegroups.model.transform.CreateGroupRequestProtocolMarshaller;
import com.amazonaws.services.resourcegroups.model.transform.CreateGroupResultJsonUnmarshaller;
import com.amazonaws.services.resourcegroups.model.transform.DeleteGroupRequestProtocolMarshaller;
import com.amazonaws.services.resourcegroups.model.transform.DeleteGroupResultJsonUnmarshaller;
import com.amazonaws.services.resourcegroups.model.transform.GetGroupQueryRequestProtocolMarshaller;
import com.amazonaws.services.resourcegroups.model.transform.GetGroupQueryResultJsonUnmarshaller;
import com.amazonaws.services.resourcegroups.model.transform.GetGroupRequestProtocolMarshaller;
import com.amazonaws.services.resourcegroups.model.transform.GetGroupResultJsonUnmarshaller;
import com.amazonaws.services.resourcegroups.model.transform.GetTagsRequestProtocolMarshaller;
import com.amazonaws.services.resourcegroups.model.transform.GetTagsResultJsonUnmarshaller;
import com.amazonaws.services.resourcegroups.model.transform.ListGroupResourcesRequestProtocolMarshaller;
import com.amazonaws.services.resourcegroups.model.transform.ListGroupResourcesResultJsonUnmarshaller;
import com.amazonaws.services.resourcegroups.model.transform.ListGroupsRequestProtocolMarshaller;
import com.amazonaws.services.resourcegroups.model.transform.ListGroupsResultJsonUnmarshaller;
import com.amazonaws.services.resourcegroups.model.transform.SearchResourcesRequestProtocolMarshaller;
import com.amazonaws.services.resourcegroups.model.transform.SearchResourcesResultJsonUnmarshaller;
import com.amazonaws.services.resourcegroups.model.transform.TagRequestProtocolMarshaller;
import com.amazonaws.services.resourcegroups.model.transform.TagResultJsonUnmarshaller;
import com.amazonaws.services.resourcegroups.model.transform.UntagRequestProtocolMarshaller;
import com.amazonaws.services.resourcegroups.model.transform.UntagResultJsonUnmarshaller;
import com.amazonaws.services.resourcegroups.model.transform.UpdateGroupQueryRequestProtocolMarshaller;
import com.amazonaws.services.resourcegroups.model.transform.UpdateGroupQueryResultJsonUnmarshaller;
import com.amazonaws.services.resourcegroups.model.transform.UpdateGroupRequestProtocolMarshaller;
import com.amazonaws.services.resourcegroups.model.transform.UpdateGroupResultJsonUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSResourceGroupsClient
extends AmazonWebServiceClient
implements AWSResourceGroups {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSResourceGroups.class);
    private static final String DEFAULT_SIGNING_NAME = "resource-groups";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("NotFoundException").withModeledClass(NotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("UnauthorizedException").withModeledClass(UnauthorizedException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ForbiddenException").withModeledClass(ForbiddenException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("MethodNotAllowedException").withModeledClass(MethodNotAllowedException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("TooManyRequestsException").withModeledClass(TooManyRequestsException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("BadRequestException").withModeledClass(BadRequestException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerErrorException").withModeledClass(InternalServerErrorException.class)).withBaseServiceExceptionClass(AWSResourceGroupsException.class));

    public static AWSResourceGroupsClientBuilder builder() {
        return AWSResourceGroupsClientBuilder.standard();
    }

    AWSResourceGroupsClient(AwsSyncClientParams clientParams) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.init();
    }

    AWSResourceGroupsClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("resource-groups.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/resourcegroups/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/resourcegroups/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public CreateGroupResult createGroup(CreateGroupRequest request) {
        request = (CreateGroupRequest)this.beforeClientExecution(request);
        return this.executeCreateGroup(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateGroupResult executeCreateGroup(CreateGroupRequest createGroupRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createGroupRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateGroupRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateGroupRequestProtocolMarshaller(protocolFactory).marshall((CreateGroupRequest)super.beforeMarshalling((AmazonWebServiceRequest)createGroupRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Resource Groups");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateGroup");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateGroupResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateGroupResult createGroupResult = (CreateGroupResult)response.getAwsResponse();
            return createGroupResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteGroupResult deleteGroup(DeleteGroupRequest request) {
        request = (DeleteGroupRequest)this.beforeClientExecution(request);
        return this.executeDeleteGroup(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteGroupResult executeDeleteGroup(DeleteGroupRequest deleteGroupRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteGroupRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteGroupRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteGroupRequestProtocolMarshaller(protocolFactory).marshall((DeleteGroupRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteGroupRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Resource Groups");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteGroup");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteGroupResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteGroupResult deleteGroupResult = (DeleteGroupResult)response.getAwsResponse();
            return deleteGroupResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetGroupResult getGroup(GetGroupRequest request) {
        request = (GetGroupRequest)this.beforeClientExecution(request);
        return this.executeGetGroup(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetGroupResult executeGetGroup(GetGroupRequest getGroupRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getGroupRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetGroupRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetGroupRequestProtocolMarshaller(protocolFactory).marshall((GetGroupRequest)super.beforeMarshalling((AmazonWebServiceRequest)getGroupRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Resource Groups");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetGroup");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetGroupResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetGroupResult getGroupResult = (GetGroupResult)response.getAwsResponse();
            return getGroupResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetGroupQueryResult getGroupQuery(GetGroupQueryRequest request) {
        request = (GetGroupQueryRequest)this.beforeClientExecution(request);
        return this.executeGetGroupQuery(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetGroupQueryResult executeGetGroupQuery(GetGroupQueryRequest getGroupQueryRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getGroupQueryRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetGroupQueryRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetGroupQueryRequestProtocolMarshaller(protocolFactory).marshall((GetGroupQueryRequest)super.beforeMarshalling((AmazonWebServiceRequest)getGroupQueryRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Resource Groups");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetGroupQuery");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetGroupQueryResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetGroupQueryResult getGroupQueryResult = (GetGroupQueryResult)response.getAwsResponse();
            return getGroupQueryResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetTagsResult getTags(GetTagsRequest request) {
        request = (GetTagsRequest)this.beforeClientExecution(request);
        return this.executeGetTags(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetTagsResult executeGetTags(GetTagsRequest getTagsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getTagsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetTagsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetTagsRequestProtocolMarshaller(protocolFactory).marshall((GetTagsRequest)super.beforeMarshalling((AmazonWebServiceRequest)getTagsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Resource Groups");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetTags");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetTagsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetTagsResult getTagsResult = (GetTagsResult)response.getAwsResponse();
            return getTagsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListGroupResourcesResult listGroupResources(ListGroupResourcesRequest request) {
        request = (ListGroupResourcesRequest)this.beforeClientExecution(request);
        return this.executeListGroupResources(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListGroupResourcesResult executeListGroupResources(ListGroupResourcesRequest listGroupResourcesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listGroupResourcesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListGroupResourcesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListGroupResourcesRequestProtocolMarshaller(protocolFactory).marshall((ListGroupResourcesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listGroupResourcesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Resource Groups");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListGroupResources");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListGroupResourcesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListGroupResourcesResult listGroupResourcesResult = (ListGroupResourcesResult)response.getAwsResponse();
            return listGroupResourcesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListGroupsResult listGroups(ListGroupsRequest request) {
        request = (ListGroupsRequest)this.beforeClientExecution(request);
        return this.executeListGroups(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListGroupsResult executeListGroups(ListGroupsRequest listGroupsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listGroupsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListGroupsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListGroupsRequestProtocolMarshaller(protocolFactory).marshall((ListGroupsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listGroupsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Resource Groups");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListGroups");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListGroupsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListGroupsResult listGroupsResult = (ListGroupsResult)response.getAwsResponse();
            return listGroupsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public SearchResourcesResult searchResources(SearchResourcesRequest request) {
        request = (SearchResourcesRequest)this.beforeClientExecution(request);
        return this.executeSearchResources(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final SearchResourcesResult executeSearchResources(SearchResourcesRequest searchResourcesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(searchResourcesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<SearchResourcesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new SearchResourcesRequestProtocolMarshaller(protocolFactory).marshall((SearchResourcesRequest)super.beforeMarshalling((AmazonWebServiceRequest)searchResourcesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Resource Groups");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"SearchResources");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new SearchResourcesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            SearchResourcesResult searchResourcesResult = (SearchResourcesResult)response.getAwsResponse();
            return searchResourcesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public TagResult tag(TagRequest request) {
        request = (TagRequest)this.beforeClientExecution(request);
        return this.executeTag(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final TagResult executeTag(TagRequest tagRequest) {
        ExecutionContext executionContext = this.createExecutionContext(tagRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TagRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TagRequestProtocolMarshaller(protocolFactory).marshall((TagRequest)super.beforeMarshalling((AmazonWebServiceRequest)tagRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Resource Groups");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"Tag");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new TagResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            TagResult tagResult = (TagResult)response.getAwsResponse();
            return tagResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UntagResult untag(UntagRequest request) {
        request = (UntagRequest)this.beforeClientExecution(request);
        return this.executeUntag(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UntagResult executeUntag(UntagRequest untagRequest) {
        ExecutionContext executionContext = this.createExecutionContext(untagRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UntagRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UntagRequestProtocolMarshaller(protocolFactory).marshall((UntagRequest)super.beforeMarshalling((AmazonWebServiceRequest)untagRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Resource Groups");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"Untag");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UntagResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UntagResult untagResult = (UntagResult)response.getAwsResponse();
            return untagResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateGroupResult updateGroup(UpdateGroupRequest request) {
        request = (UpdateGroupRequest)this.beforeClientExecution(request);
        return this.executeUpdateGroup(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateGroupResult executeUpdateGroup(UpdateGroupRequest updateGroupRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateGroupRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateGroupRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateGroupRequestProtocolMarshaller(protocolFactory).marshall((UpdateGroupRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateGroupRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Resource Groups");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateGroup");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateGroupResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateGroupResult updateGroupResult = (UpdateGroupResult)response.getAwsResponse();
            return updateGroupResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateGroupQueryResult updateGroupQuery(UpdateGroupQueryRequest request) {
        request = (UpdateGroupQueryRequest)this.beforeClientExecution(request);
        return this.executeUpdateGroupQuery(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateGroupQueryResult executeUpdateGroupQuery(UpdateGroupQueryRequest updateGroupQueryRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateGroupQueryRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateGroupQueryRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateGroupQueryRequestProtocolMarshaller(protocolFactory).marshall((UpdateGroupQueryRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateGroupQueryRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Resource Groups");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateGroupQuery");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateGroupQueryResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateGroupQueryResult updateGroupQueryResult = (UpdateGroupQueryResult)response.getAwsResponse();
            return updateGroupQueryResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }
}

