/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.resourceexplorer2;

import javax.annotation.Generated;

import com.amazonaws.services.resourceexplorer2.model.*;

/**
 * Abstract implementation of {@code AWSResourceExplorer2Async}. Convenient method forms pass through to the
 * corresponding overload that takes a request object and an {@code AsyncHandler}, which throws an
 * {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSResourceExplorer2Async extends AbstractAWSResourceExplorer2 implements AWSResourceExplorer2Async {

    protected AbstractAWSResourceExplorer2Async() {
    }

    @Override
    public java.util.concurrent.Future<AssociateDefaultViewResult> associateDefaultViewAsync(AssociateDefaultViewRequest request) {

        return associateDefaultViewAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<AssociateDefaultViewResult> associateDefaultViewAsync(AssociateDefaultViewRequest request,
            com.amazonaws.handlers.AsyncHandler<AssociateDefaultViewRequest, AssociateDefaultViewResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<BatchGetViewResult> batchGetViewAsync(BatchGetViewRequest request) {

        return batchGetViewAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<BatchGetViewResult> batchGetViewAsync(BatchGetViewRequest request,
            com.amazonaws.handlers.AsyncHandler<BatchGetViewRequest, BatchGetViewResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateIndexResult> createIndexAsync(CreateIndexRequest request) {

        return createIndexAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateIndexResult> createIndexAsync(CreateIndexRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateIndexRequest, CreateIndexResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateViewResult> createViewAsync(CreateViewRequest request) {

        return createViewAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateViewResult> createViewAsync(CreateViewRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateViewRequest, CreateViewResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteIndexResult> deleteIndexAsync(DeleteIndexRequest request) {

        return deleteIndexAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteIndexResult> deleteIndexAsync(DeleteIndexRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteIndexRequest, DeleteIndexResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteViewResult> deleteViewAsync(DeleteViewRequest request) {

        return deleteViewAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteViewResult> deleteViewAsync(DeleteViewRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteViewRequest, DeleteViewResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DisassociateDefaultViewResult> disassociateDefaultViewAsync(DisassociateDefaultViewRequest request) {

        return disassociateDefaultViewAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DisassociateDefaultViewResult> disassociateDefaultViewAsync(DisassociateDefaultViewRequest request,
            com.amazonaws.handlers.AsyncHandler<DisassociateDefaultViewRequest, DisassociateDefaultViewResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetAccountLevelServiceConfigurationResult> getAccountLevelServiceConfigurationAsync(
            GetAccountLevelServiceConfigurationRequest request) {

        return getAccountLevelServiceConfigurationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetAccountLevelServiceConfigurationResult> getAccountLevelServiceConfigurationAsync(
            GetAccountLevelServiceConfigurationRequest request,
            com.amazonaws.handlers.AsyncHandler<GetAccountLevelServiceConfigurationRequest, GetAccountLevelServiceConfigurationResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetDefaultViewResult> getDefaultViewAsync(GetDefaultViewRequest request) {

        return getDefaultViewAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetDefaultViewResult> getDefaultViewAsync(GetDefaultViewRequest request,
            com.amazonaws.handlers.AsyncHandler<GetDefaultViewRequest, GetDefaultViewResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetIndexResult> getIndexAsync(GetIndexRequest request) {

        return getIndexAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetIndexResult> getIndexAsync(GetIndexRequest request,
            com.amazonaws.handlers.AsyncHandler<GetIndexRequest, GetIndexResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetViewResult> getViewAsync(GetViewRequest request) {

        return getViewAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetViewResult> getViewAsync(GetViewRequest request,
            com.amazonaws.handlers.AsyncHandler<GetViewRequest, GetViewResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListIndexesResult> listIndexesAsync(ListIndexesRequest request) {

        return listIndexesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListIndexesResult> listIndexesAsync(ListIndexesRequest request,
            com.amazonaws.handlers.AsyncHandler<ListIndexesRequest, ListIndexesResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListIndexesForMembersResult> listIndexesForMembersAsync(ListIndexesForMembersRequest request) {

        return listIndexesForMembersAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListIndexesForMembersResult> listIndexesForMembersAsync(ListIndexesForMembersRequest request,
            com.amazonaws.handlers.AsyncHandler<ListIndexesForMembersRequest, ListIndexesForMembersResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListSupportedResourceTypesResult> listSupportedResourceTypesAsync(ListSupportedResourceTypesRequest request) {

        return listSupportedResourceTypesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListSupportedResourceTypesResult> listSupportedResourceTypesAsync(ListSupportedResourceTypesRequest request,
            com.amazonaws.handlers.AsyncHandler<ListSupportedResourceTypesRequest, ListSupportedResourceTypesResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {

        return listTagsForResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListViewsResult> listViewsAsync(ListViewsRequest request) {

        return listViewsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListViewsResult> listViewsAsync(ListViewsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListViewsRequest, ListViewsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<SearchResult> searchAsync(SearchRequest request) {

        return searchAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<SearchResult> searchAsync(SearchRequest request,
            com.amazonaws.handlers.AsyncHandler<SearchRequest, SearchResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {

        return tagResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<TagResourceResult> tagResourceAsync(TagResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {

        return untagResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateIndexTypeResult> updateIndexTypeAsync(UpdateIndexTypeRequest request) {

        return updateIndexTypeAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateIndexTypeResult> updateIndexTypeAsync(UpdateIndexTypeRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateIndexTypeRequest, UpdateIndexTypeResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateViewResult> updateViewAsync(UpdateViewRequest request) {

        return updateViewAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateViewResult> updateViewAsync(UpdateViewRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateViewRequest, UpdateViewResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

}
