/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.resiliencehub.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.resiliencehub.model.ConfigRecommendation;
import com.amazonaws.services.resiliencehub.model.RecommendationComplianceStatus;
import com.amazonaws.services.resiliencehub.model.transform.ComponentRecommendationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ComponentRecommendation
implements Serializable,
Cloneable,
StructuredPojo {
    private String appComponentName;
    private List<ConfigRecommendation> configRecommendations;
    private String recommendationStatus;

    public void setAppComponentName(String appComponentName) {
        this.appComponentName = appComponentName;
    }

    public String getAppComponentName() {
        return this.appComponentName;
    }

    public ComponentRecommendation withAppComponentName(String appComponentName) {
        this.setAppComponentName(appComponentName);
        return this;
    }

    public List<ConfigRecommendation> getConfigRecommendations() {
        return this.configRecommendations;
    }

    public void setConfigRecommendations(Collection<ConfigRecommendation> configRecommendations) {
        if (configRecommendations == null) {
            this.configRecommendations = null;
            return;
        }
        this.configRecommendations = new ArrayList<ConfigRecommendation>(configRecommendations);
    }

    public ComponentRecommendation withConfigRecommendations(ConfigRecommendation ... configRecommendations) {
        if (this.configRecommendations == null) {
            this.setConfigRecommendations(new ArrayList<ConfigRecommendation>(configRecommendations.length));
        }
        for (ConfigRecommendation ele : configRecommendations) {
            this.configRecommendations.add(ele);
        }
        return this;
    }

    public ComponentRecommendation withConfigRecommendations(Collection<ConfigRecommendation> configRecommendations) {
        this.setConfigRecommendations(configRecommendations);
        return this;
    }

    public void setRecommendationStatus(String recommendationStatus) {
        this.recommendationStatus = recommendationStatus;
    }

    public String getRecommendationStatus() {
        return this.recommendationStatus;
    }

    public ComponentRecommendation withRecommendationStatus(String recommendationStatus) {
        this.setRecommendationStatus(recommendationStatus);
        return this;
    }

    public ComponentRecommendation withRecommendationStatus(RecommendationComplianceStatus recommendationStatus) {
        this.recommendationStatus = recommendationStatus.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAppComponentName() != null) {
            sb.append("AppComponentName: ").append(this.getAppComponentName()).append(",");
        }
        if (this.getConfigRecommendations() != null) {
            sb.append("ConfigRecommendations: ").append(this.getConfigRecommendations()).append(",");
        }
        if (this.getRecommendationStatus() != null) {
            sb.append("RecommendationStatus: ").append(this.getRecommendationStatus());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComponentRecommendation)) {
            return false;
        }
        ComponentRecommendation other = (ComponentRecommendation)obj;
        if (other.getAppComponentName() == null ^ this.getAppComponentName() == null) {
            return false;
        }
        if (other.getAppComponentName() != null && !other.getAppComponentName().equals(this.getAppComponentName())) {
            return false;
        }
        if (other.getConfigRecommendations() == null ^ this.getConfigRecommendations() == null) {
            return false;
        }
        if (other.getConfigRecommendations() != null && !other.getConfigRecommendations().equals(this.getConfigRecommendations())) {
            return false;
        }
        if (other.getRecommendationStatus() == null ^ this.getRecommendationStatus() == null) {
            return false;
        }
        return other.getRecommendationStatus() == null || other.getRecommendationStatus().equals(this.getRecommendationStatus());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAppComponentName() == null ? 0 : this.getAppComponentName().hashCode());
        hashCode = 31 * hashCode + (this.getConfigRecommendations() == null ? 0 : this.getConfigRecommendations().hashCode());
        hashCode = 31 * hashCode + (this.getRecommendationStatus() == null ? 0 : this.getRecommendationStatus().hashCode());
        return hashCode;
    }

    public ComponentRecommendation clone() {
        try {
            return (ComponentRecommendation)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ComponentRecommendationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

