/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rekognition.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.rekognition.model.TrainingData;
import java.util.List;

@SdkInternalApi
public class TrainingDataMarshaller {
    private static final MarshallingInfo<List> ASSETS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Assets").build();
    private static final TrainingDataMarshaller instance = new TrainingDataMarshaller();

    public static TrainingDataMarshaller getInstance() {
        return instance;
    }

    public void marshall(TrainingData trainingData, ProtocolMarshaller protocolMarshaller) {
        if (trainingData == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(trainingData.getAssets(), ASSETS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

