/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.rekognition.model.transform;

import java.math.*;

import javax.annotation.Generated;

import com.amazonaws.services.rekognition.model.*;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers.*;
import com.amazonaws.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * Celebrity JSON Unmarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class CelebrityJsonUnmarshaller implements Unmarshaller<Celebrity, JsonUnmarshallerContext> {

    public Celebrity unmarshall(JsonUnmarshallerContext context) throws Exception {
        Celebrity celebrity = new Celebrity();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("Urls", targetDepth)) {
                    context.nextToken();
                    celebrity.setUrls(new ListUnmarshaller<String>(context.getUnmarshaller(String.class))

                    .unmarshall(context));
                }
                if (context.testExpression("Name", targetDepth)) {
                    context.nextToken();
                    celebrity.setName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Id", targetDepth)) {
                    context.nextToken();
                    celebrity.setId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Face", targetDepth)) {
                    context.nextToken();
                    celebrity.setFace(ComparedFaceJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("MatchConfidence", targetDepth)) {
                    context.nextToken();
                    celebrity.setMatchConfidence(context.getUnmarshaller(Float.class).unmarshall(context));
                }
                if (context.testExpression("KnownGender", targetDepth)) {
                    context.nextToken();
                    celebrity.setKnownGender(KnownGenderJsonUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return celebrity;
    }

    private static CelebrityJsonUnmarshaller instance;

    public static CelebrityJsonUnmarshaller getInstance() {
        if (instance == null)
            instance = new CelebrityJsonUnmarshaller();
        return instance;
    }
}
