/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.rekognition.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * A session settings object. It contains settings for the operation to be performed. It accepts arguments for
 * OutputConfig and AuditImagesLimit.
 * </p>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class CreateFaceLivenessSessionRequestSettings implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * Can specify the location of an Amazon S3 bucket, where reference and audit images will be stored. Note that the
     * Amazon S3 bucket must be located in the caller's AWS account and in the same region as the Face Liveness
     * end-point. Additionally, the Amazon S3 object keys are auto-generated by the Face Liveness system. Requires that
     * the caller has the <code>s3:PutObject</code> permission on the Amazon S3 bucket.
     * </p>
     */
    private LivenessOutputConfig outputConfig;
    /**
     * <p>
     * Number of audit images to be returned back. Takes an integer between 0-4. Any integer less than 0 will return 0,
     * any integer above 4 will return 4 images in the response. By default, it is set to 0. The limit is best effort
     * and is based on the actual duration of the selfie-video.
     * </p>
     */
    private Integer auditImagesLimit;

    /**
     * <p>
     * Can specify the location of an Amazon S3 bucket, where reference and audit images will be stored. Note that the
     * Amazon S3 bucket must be located in the caller's AWS account and in the same region as the Face Liveness
     * end-point. Additionally, the Amazon S3 object keys are auto-generated by the Face Liveness system. Requires that
     * the caller has the <code>s3:PutObject</code> permission on the Amazon S3 bucket.
     * </p>
     * 
     * @param outputConfig
     *        Can specify the location of an Amazon S3 bucket, where reference and audit images will be stored. Note
     *        that the Amazon S3 bucket must be located in the caller's AWS account and in the same region as the Face
     *        Liveness end-point. Additionally, the Amazon S3 object keys are auto-generated by the Face Liveness
     *        system. Requires that the caller has the <code>s3:PutObject</code> permission on the Amazon S3 bucket.
     */

    public void setOutputConfig(LivenessOutputConfig outputConfig) {
        this.outputConfig = outputConfig;
    }

    /**
     * <p>
     * Can specify the location of an Amazon S3 bucket, where reference and audit images will be stored. Note that the
     * Amazon S3 bucket must be located in the caller's AWS account and in the same region as the Face Liveness
     * end-point. Additionally, the Amazon S3 object keys are auto-generated by the Face Liveness system. Requires that
     * the caller has the <code>s3:PutObject</code> permission on the Amazon S3 bucket.
     * </p>
     * 
     * @return Can specify the location of an Amazon S3 bucket, where reference and audit images will be stored. Note
     *         that the Amazon S3 bucket must be located in the caller's AWS account and in the same region as the Face
     *         Liveness end-point. Additionally, the Amazon S3 object keys are auto-generated by the Face Liveness
     *         system. Requires that the caller has the <code>s3:PutObject</code> permission on the Amazon S3 bucket.
     */

    public LivenessOutputConfig getOutputConfig() {
        return this.outputConfig;
    }

    /**
     * <p>
     * Can specify the location of an Amazon S3 bucket, where reference and audit images will be stored. Note that the
     * Amazon S3 bucket must be located in the caller's AWS account and in the same region as the Face Liveness
     * end-point. Additionally, the Amazon S3 object keys are auto-generated by the Face Liveness system. Requires that
     * the caller has the <code>s3:PutObject</code> permission on the Amazon S3 bucket.
     * </p>
     * 
     * @param outputConfig
     *        Can specify the location of an Amazon S3 bucket, where reference and audit images will be stored. Note
     *        that the Amazon S3 bucket must be located in the caller's AWS account and in the same region as the Face
     *        Liveness end-point. Additionally, the Amazon S3 object keys are auto-generated by the Face Liveness
     *        system. Requires that the caller has the <code>s3:PutObject</code> permission on the Amazon S3 bucket.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateFaceLivenessSessionRequestSettings withOutputConfig(LivenessOutputConfig outputConfig) {
        setOutputConfig(outputConfig);
        return this;
    }

    /**
     * <p>
     * Number of audit images to be returned back. Takes an integer between 0-4. Any integer less than 0 will return 0,
     * any integer above 4 will return 4 images in the response. By default, it is set to 0. The limit is best effort
     * and is based on the actual duration of the selfie-video.
     * </p>
     * 
     * @param auditImagesLimit
     *        Number of audit images to be returned back. Takes an integer between 0-4. Any integer less than 0 will
     *        return 0, any integer above 4 will return 4 images in the response. By default, it is set to 0. The limit
     *        is best effort and is based on the actual duration of the selfie-video.
     */

    public void setAuditImagesLimit(Integer auditImagesLimit) {
        this.auditImagesLimit = auditImagesLimit;
    }

    /**
     * <p>
     * Number of audit images to be returned back. Takes an integer between 0-4. Any integer less than 0 will return 0,
     * any integer above 4 will return 4 images in the response. By default, it is set to 0. The limit is best effort
     * and is based on the actual duration of the selfie-video.
     * </p>
     * 
     * @return Number of audit images to be returned back. Takes an integer between 0-4. Any integer less than 0 will
     *         return 0, any integer above 4 will return 4 images in the response. By default, it is set to 0. The limit
     *         is best effort and is based on the actual duration of the selfie-video.
     */

    public Integer getAuditImagesLimit() {
        return this.auditImagesLimit;
    }

    /**
     * <p>
     * Number of audit images to be returned back. Takes an integer between 0-4. Any integer less than 0 will return 0,
     * any integer above 4 will return 4 images in the response. By default, it is set to 0. The limit is best effort
     * and is based on the actual duration of the selfie-video.
     * </p>
     * 
     * @param auditImagesLimit
     *        Number of audit images to be returned back. Takes an integer between 0-4. Any integer less than 0 will
     *        return 0, any integer above 4 will return 4 images in the response. By default, it is set to 0. The limit
     *        is best effort and is based on the actual duration of the selfie-video.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateFaceLivenessSessionRequestSettings withAuditImagesLimit(Integer auditImagesLimit) {
        setAuditImagesLimit(auditImagesLimit);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getOutputConfig() != null)
            sb.append("OutputConfig: ").append(getOutputConfig()).append(",");
        if (getAuditImagesLimit() != null)
            sb.append("AuditImagesLimit: ").append(getAuditImagesLimit());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof CreateFaceLivenessSessionRequestSettings == false)
            return false;
        CreateFaceLivenessSessionRequestSettings other = (CreateFaceLivenessSessionRequestSettings) obj;
        if (other.getOutputConfig() == null ^ this.getOutputConfig() == null)
            return false;
        if (other.getOutputConfig() != null && other.getOutputConfig().equals(this.getOutputConfig()) == false)
            return false;
        if (other.getAuditImagesLimit() == null ^ this.getAuditImagesLimit() == null)
            return false;
        if (other.getAuditImagesLimit() != null && other.getAuditImagesLimit().equals(this.getAuditImagesLimit()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getOutputConfig() == null) ? 0 : getOutputConfig().hashCode());
        hashCode = prime * hashCode + ((getAuditImagesLimit() == null) ? 0 : getAuditImagesLimit().hashCode());
        return hashCode;
    }

    @Override
    public CreateFaceLivenessSessionRequestSettings clone() {
        try {
            return (CreateFaceLivenessSessionRequestSettings) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.rekognition.model.transform.CreateFaceLivenessSessionRequestSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
