/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rekognition.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.rekognition.model.Smile;

public class SmileJsonMarshaller {
    private static SmileJsonMarshaller instance;

    public void marshall(Smile smile, StructuredJsonGenerator jsonGenerator) {
        if (smile == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (smile.getValue() != null) {
                jsonGenerator.writeFieldName("Value").writeValue(smile.getValue().booleanValue());
            }
            if (smile.getConfidence() != null) {
                jsonGenerator.writeFieldName("Confidence").writeValue(smile.getConfidence().floatValue());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static SmileJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new SmileJsonMarshaller();
        }
        return instance;
    }
}

