/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rekognition.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.rekognition.model.ImageQuality;

public class ImageQualityJsonMarshaller {
    private static ImageQualityJsonMarshaller instance;

    public void marshall(ImageQuality imageQuality, StructuredJsonGenerator jsonGenerator) {
        if (imageQuality == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (imageQuality.getBrightness() != null) {
                jsonGenerator.writeFieldName("Brightness").writeValue(imageQuality.getBrightness().floatValue());
            }
            if (imageQuality.getSharpness() != null) {
                jsonGenerator.writeFieldName("Sharpness").writeValue(imageQuality.getSharpness().floatValue());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ImageQualityJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ImageQualityJsonMarshaller();
        }
        return instance;
    }
}

