/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rekognition.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.rekognition.model.Mustache;

public class MustacheJsonMarshaller {
    private static MustacheJsonMarshaller instance;

    public void marshall(Mustache mustache, StructuredJsonGenerator jsonGenerator) {
        if (mustache == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (mustache.getValue() != null) {
                jsonGenerator.writeFieldName("Value").writeValue(mustache.getValue().booleanValue());
            }
            if (mustache.getConfidence() != null) {
                jsonGenerator.writeFieldName("Confidence").writeValue(mustache.getConfidence().floatValue());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static MustacheJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new MustacheJsonMarshaller();
        }
        return instance;
    }
}

