/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rekognition.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.rekognition.model.Pose;

public class PoseJsonMarshaller {
    private static PoseJsonMarshaller instance;

    public void marshall(Pose pose, StructuredJsonGenerator jsonGenerator) {
        if (pose == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (pose.getRoll() != null) {
                jsonGenerator.writeFieldName("Roll").writeValue(pose.getRoll().floatValue());
            }
            if (pose.getYaw() != null) {
                jsonGenerator.writeFieldName("Yaw").writeValue(pose.getYaw().floatValue());
            }
            if (pose.getPitch() != null) {
                jsonGenerator.writeFieldName("Pitch").writeValue(pose.getPitch().floatValue());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static PoseJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new PoseJsonMarshaller();
        }
        return instance;
    }
}

