/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rekognition.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.rekognition.model.FaceDetection;
import com.amazonaws.services.rekognition.model.VideoJobStatus;
import com.amazonaws.services.rekognition.model.VideoMetadata;
import com.amazonaws.services.rekognition.model.Warning;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GetFaceDetectionResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String jobStatus;
    private String statusMessage;
    private VideoMetadata videoMetadata;
    private String nextToken;
    private List<FaceDetection> faces;
    private Integer billableDurationSeconds;
    private String errorCode;
    private List<Warning> warnings;

    public void setJobStatus(String jobStatus) {
        this.jobStatus = jobStatus;
    }

    public String getJobStatus() {
        return this.jobStatus;
    }

    public GetFaceDetectionResult withJobStatus(String jobStatus) {
        this.setJobStatus(jobStatus);
        return this;
    }

    public GetFaceDetectionResult withJobStatus(VideoJobStatus jobStatus) {
        this.jobStatus = jobStatus.toString();
        return this;
    }

    public void setStatusMessage(String statusMessage) {
        this.statusMessage = statusMessage;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public GetFaceDetectionResult withStatusMessage(String statusMessage) {
        this.setStatusMessage(statusMessage);
        return this;
    }

    public void setVideoMetadata(VideoMetadata videoMetadata) {
        this.videoMetadata = videoMetadata;
    }

    public VideoMetadata getVideoMetadata() {
        return this.videoMetadata;
    }

    public GetFaceDetectionResult withVideoMetadata(VideoMetadata videoMetadata) {
        this.setVideoMetadata(videoMetadata);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public GetFaceDetectionResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public List<FaceDetection> getFaces() {
        return this.faces;
    }

    public void setFaces(Collection<FaceDetection> faces) {
        if (faces == null) {
            this.faces = null;
            return;
        }
        this.faces = new ArrayList<FaceDetection>(faces);
    }

    public GetFaceDetectionResult withFaces(FaceDetection ... faces) {
        if (this.faces == null) {
            this.setFaces(new ArrayList<FaceDetection>(faces.length));
        }
        for (FaceDetection ele : faces) {
            this.faces.add(ele);
        }
        return this;
    }

    public GetFaceDetectionResult withFaces(Collection<FaceDetection> faces) {
        this.setFaces(faces);
        return this;
    }

    public void setBillableDurationSeconds(Integer billableDurationSeconds) {
        this.billableDurationSeconds = billableDurationSeconds;
    }

    public Integer getBillableDurationSeconds() {
        return this.billableDurationSeconds;
    }

    public GetFaceDetectionResult withBillableDurationSeconds(Integer billableDurationSeconds) {
        this.setBillableDurationSeconds(billableDurationSeconds);
        return this;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public GetFaceDetectionResult withErrorCode(String errorCode) {
        this.setErrorCode(errorCode);
        return this;
    }

    public List<Warning> getWarnings() {
        return this.warnings;
    }

    public void setWarnings(Collection<Warning> warnings) {
        if (warnings == null) {
            this.warnings = null;
            return;
        }
        this.warnings = new ArrayList<Warning>(warnings);
    }

    public GetFaceDetectionResult withWarnings(Warning ... warnings) {
        if (this.warnings == null) {
            this.setWarnings(new ArrayList<Warning>(warnings.length));
        }
        for (Warning ele : warnings) {
            this.warnings.add(ele);
        }
        return this;
    }

    public GetFaceDetectionResult withWarnings(Collection<Warning> warnings) {
        this.setWarnings(warnings);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getJobStatus() != null) {
            sb.append("JobStatus: ").append(this.getJobStatus()).append(",");
        }
        if (this.getStatusMessage() != null) {
            sb.append("StatusMessage: ").append(this.getStatusMessage()).append(",");
        }
        if (this.getVideoMetadata() != null) {
            sb.append("VideoMetadata: ").append(this.getVideoMetadata()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getFaces() != null) {
            sb.append("Faces: ").append(this.getFaces()).append(",");
        }
        if (this.getBillableDurationSeconds() != null) {
            sb.append("BillableDurationSeconds: ").append(this.getBillableDurationSeconds()).append(",");
        }
        if (this.getErrorCode() != null) {
            sb.append("ErrorCode: ").append(this.getErrorCode()).append(",");
        }
        if (this.getWarnings() != null) {
            sb.append("Warnings: ").append(this.getWarnings());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFaceDetectionResult)) {
            return false;
        }
        GetFaceDetectionResult other = (GetFaceDetectionResult)obj;
        if (other.getJobStatus() == null ^ this.getJobStatus() == null) {
            return false;
        }
        if (other.getJobStatus() != null && !other.getJobStatus().equals(this.getJobStatus())) {
            return false;
        }
        if (other.getStatusMessage() == null ^ this.getStatusMessage() == null) {
            return false;
        }
        if (other.getStatusMessage() != null && !other.getStatusMessage().equals(this.getStatusMessage())) {
            return false;
        }
        if (other.getVideoMetadata() == null ^ this.getVideoMetadata() == null) {
            return false;
        }
        if (other.getVideoMetadata() != null && !other.getVideoMetadata().equals(this.getVideoMetadata())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getFaces() == null ^ this.getFaces() == null) {
            return false;
        }
        if (other.getFaces() != null && !other.getFaces().equals(this.getFaces())) {
            return false;
        }
        if (other.getBillableDurationSeconds() == null ^ this.getBillableDurationSeconds() == null) {
            return false;
        }
        if (other.getBillableDurationSeconds() != null && !other.getBillableDurationSeconds().equals(this.getBillableDurationSeconds())) {
            return false;
        }
        if (other.getErrorCode() == null ^ this.getErrorCode() == null) {
            return false;
        }
        if (other.getErrorCode() != null && !other.getErrorCode().equals(this.getErrorCode())) {
            return false;
        }
        if (other.getWarnings() == null ^ this.getWarnings() == null) {
            return false;
        }
        return other.getWarnings() == null || other.getWarnings().equals(this.getWarnings());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getJobStatus() == null ? 0 : this.getJobStatus().hashCode());
        hashCode = 31 * hashCode + (this.getStatusMessage() == null ? 0 : this.getStatusMessage().hashCode());
        hashCode = 31 * hashCode + (this.getVideoMetadata() == null ? 0 : this.getVideoMetadata().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getFaces() == null ? 0 : this.getFaces().hashCode());
        hashCode = 31 * hashCode + (this.getBillableDurationSeconds() == null ? 0 : this.getBillableDurationSeconds().hashCode());
        hashCode = 31 * hashCode + (this.getErrorCode() == null ? 0 : this.getErrorCode().hashCode());
        hashCode = 31 * hashCode + (this.getWarnings() == null ? 0 : this.getWarnings().hashCode());
        return hashCode;
    }

    public GetFaceDetectionResult clone() {
        try {
            return (GetFaceDetectionResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

