/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rekognition.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.rekognition.model.CompareFacesMatch;
import com.amazonaws.services.rekognition.model.ComparedFace;
import com.amazonaws.services.rekognition.model.ComparedSourceImageFace;
import com.amazonaws.services.rekognition.model.OrientationCorrection;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CompareFacesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private ComparedSourceImageFace sourceImageFace;
    private List<CompareFacesMatch> faceMatches;
    private List<ComparedFace> unmatchedFaces;
    private String sourceImageOrientationCorrection;
    private String targetImageOrientationCorrection;

    public void setSourceImageFace(ComparedSourceImageFace sourceImageFace) {
        this.sourceImageFace = sourceImageFace;
    }

    public ComparedSourceImageFace getSourceImageFace() {
        return this.sourceImageFace;
    }

    public CompareFacesResult withSourceImageFace(ComparedSourceImageFace sourceImageFace) {
        this.setSourceImageFace(sourceImageFace);
        return this;
    }

    public List<CompareFacesMatch> getFaceMatches() {
        return this.faceMatches;
    }

    public void setFaceMatches(Collection<CompareFacesMatch> faceMatches) {
        if (faceMatches == null) {
            this.faceMatches = null;
            return;
        }
        this.faceMatches = new ArrayList<CompareFacesMatch>(faceMatches);
    }

    public CompareFacesResult withFaceMatches(CompareFacesMatch ... faceMatches) {
        if (this.faceMatches == null) {
            this.setFaceMatches(new ArrayList<CompareFacesMatch>(faceMatches.length));
        }
        for (CompareFacesMatch ele : faceMatches) {
            this.faceMatches.add(ele);
        }
        return this;
    }

    public CompareFacesResult withFaceMatches(Collection<CompareFacesMatch> faceMatches) {
        this.setFaceMatches(faceMatches);
        return this;
    }

    public List<ComparedFace> getUnmatchedFaces() {
        return this.unmatchedFaces;
    }

    public void setUnmatchedFaces(Collection<ComparedFace> unmatchedFaces) {
        if (unmatchedFaces == null) {
            this.unmatchedFaces = null;
            return;
        }
        this.unmatchedFaces = new ArrayList<ComparedFace>(unmatchedFaces);
    }

    public CompareFacesResult withUnmatchedFaces(ComparedFace ... unmatchedFaces) {
        if (this.unmatchedFaces == null) {
            this.setUnmatchedFaces(new ArrayList<ComparedFace>(unmatchedFaces.length));
        }
        for (ComparedFace ele : unmatchedFaces) {
            this.unmatchedFaces.add(ele);
        }
        return this;
    }

    public CompareFacesResult withUnmatchedFaces(Collection<ComparedFace> unmatchedFaces) {
        this.setUnmatchedFaces(unmatchedFaces);
        return this;
    }

    public void setSourceImageOrientationCorrection(String sourceImageOrientationCorrection) {
        this.sourceImageOrientationCorrection = sourceImageOrientationCorrection;
    }

    @JsonProperty(value="sourceImageOrientationCorrection")
    public String getSourceImageOrientationCorrection() {
        return this.sourceImageOrientationCorrection;
    }

    public CompareFacesResult withSourceImageOrientationCorrection(String sourceImageOrientationCorrection) {
        this.setSourceImageOrientationCorrection(sourceImageOrientationCorrection);
        return this;
    }

    @JsonIgnore
    public void setSourceImageOrientationCorrection(OrientationCorrection sourceImageOrientationCorrection) {
        this.withSourceImageOrientationCorrection(sourceImageOrientationCorrection);
    }

    public CompareFacesResult withSourceImageOrientationCorrection(OrientationCorrection sourceImageOrientationCorrection) {
        this.sourceImageOrientationCorrection = sourceImageOrientationCorrection.toString();
        return this;
    }

    public void setTargetImageOrientationCorrection(String targetImageOrientationCorrection) {
        this.targetImageOrientationCorrection = targetImageOrientationCorrection;
    }

    @JsonProperty(value="targetImageOrientationCorrection")
    public String getTargetImageOrientationCorrection() {
        return this.targetImageOrientationCorrection;
    }

    public CompareFacesResult withTargetImageOrientationCorrection(String targetImageOrientationCorrection) {
        this.setTargetImageOrientationCorrection(targetImageOrientationCorrection);
        return this;
    }

    @JsonIgnore
    public void setTargetImageOrientationCorrection(OrientationCorrection targetImageOrientationCorrection) {
        this.withTargetImageOrientationCorrection(targetImageOrientationCorrection);
    }

    public CompareFacesResult withTargetImageOrientationCorrection(OrientationCorrection targetImageOrientationCorrection) {
        this.targetImageOrientationCorrection = targetImageOrientationCorrection.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSourceImageFace() != null) {
            sb.append("SourceImageFace: ").append(this.getSourceImageFace()).append(",");
        }
        if (this.getFaceMatches() != null) {
            sb.append("FaceMatches: ").append(this.getFaceMatches()).append(",");
        }
        if (this.getUnmatchedFaces() != null) {
            sb.append("UnmatchedFaces: ").append(this.getUnmatchedFaces()).append(",");
        }
        if (this.getSourceImageOrientationCorrection() != null) {
            sb.append("SourceImageOrientationCorrection: ").append(this.getSourceImageOrientationCorrection()).append(",");
        }
        if (this.getTargetImageOrientationCorrection() != null) {
            sb.append("TargetImageOrientationCorrection: ").append(this.getTargetImageOrientationCorrection());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CompareFacesResult)) {
            return false;
        }
        CompareFacesResult other = (CompareFacesResult)obj;
        if (other.getSourceImageFace() == null ^ this.getSourceImageFace() == null) {
            return false;
        }
        if (other.getSourceImageFace() != null && !other.getSourceImageFace().equals(this.getSourceImageFace())) {
            return false;
        }
        if (other.getFaceMatches() == null ^ this.getFaceMatches() == null) {
            return false;
        }
        if (other.getFaceMatches() != null && !other.getFaceMatches().equals(this.getFaceMatches())) {
            return false;
        }
        if (other.getUnmatchedFaces() == null ^ this.getUnmatchedFaces() == null) {
            return false;
        }
        if (other.getUnmatchedFaces() != null && !other.getUnmatchedFaces().equals(this.getUnmatchedFaces())) {
            return false;
        }
        if (other.getSourceImageOrientationCorrection() == null ^ this.getSourceImageOrientationCorrection() == null) {
            return false;
        }
        if (other.getSourceImageOrientationCorrection() != null && !other.getSourceImageOrientationCorrection().equals(this.getSourceImageOrientationCorrection())) {
            return false;
        }
        if (other.getTargetImageOrientationCorrection() == null ^ this.getTargetImageOrientationCorrection() == null) {
            return false;
        }
        return other.getTargetImageOrientationCorrection() == null || other.getTargetImageOrientationCorrection().equals(this.getTargetImageOrientationCorrection());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSourceImageFace() == null ? 0 : this.getSourceImageFace().hashCode());
        hashCode = 31 * hashCode + (this.getFaceMatches() == null ? 0 : this.getFaceMatches().hashCode());
        hashCode = 31 * hashCode + (this.getUnmatchedFaces() == null ? 0 : this.getUnmatchedFaces().hashCode());
        hashCode = 31 * hashCode + (this.getSourceImageOrientationCorrection() == null ? 0 : this.getSourceImageOrientationCorrection().hashCode());
        hashCode = 31 * hashCode + (this.getTargetImageOrientationCorrection() == null ? 0 : this.getTargetImageOrientationCorrection().hashCode());
        return hashCode;
    }

    public CompareFacesResult clone() {
        try {
            return (CompareFacesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

