/*
 * Copyright 2017-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.redshiftserverless;

import javax.annotation.Generated;

import com.amazonaws.services.redshiftserverless.model.*;

/**
 * Abstract implementation of {@code AWSRedshiftServerlessAsync}. Convenient method forms pass through to the
 * corresponding overload that takes a request object and an {@code AsyncHandler}, which throws an
 * {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSRedshiftServerlessAsync extends AbstractAWSRedshiftServerless implements AWSRedshiftServerlessAsync {

    protected AbstractAWSRedshiftServerlessAsync() {
    }

    @Override
    public java.util.concurrent.Future<ConvertRecoveryPointToSnapshotResult> convertRecoveryPointToSnapshotAsync(ConvertRecoveryPointToSnapshotRequest request) {

        return convertRecoveryPointToSnapshotAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ConvertRecoveryPointToSnapshotResult> convertRecoveryPointToSnapshotAsync(ConvertRecoveryPointToSnapshotRequest request,
            com.amazonaws.handlers.AsyncHandler<ConvertRecoveryPointToSnapshotRequest, ConvertRecoveryPointToSnapshotResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateEndpointAccessResult> createEndpointAccessAsync(CreateEndpointAccessRequest request) {

        return createEndpointAccessAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateEndpointAccessResult> createEndpointAccessAsync(CreateEndpointAccessRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateEndpointAccessRequest, CreateEndpointAccessResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateNamespaceResult> createNamespaceAsync(CreateNamespaceRequest request) {

        return createNamespaceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateNamespaceResult> createNamespaceAsync(CreateNamespaceRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateNamespaceRequest, CreateNamespaceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateSnapshotResult> createSnapshotAsync(CreateSnapshotRequest request) {

        return createSnapshotAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateSnapshotResult> createSnapshotAsync(CreateSnapshotRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateSnapshotRequest, CreateSnapshotResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateUsageLimitResult> createUsageLimitAsync(CreateUsageLimitRequest request) {

        return createUsageLimitAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateUsageLimitResult> createUsageLimitAsync(CreateUsageLimitRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateUsageLimitRequest, CreateUsageLimitResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateWorkgroupResult> createWorkgroupAsync(CreateWorkgroupRequest request) {

        return createWorkgroupAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateWorkgroupResult> createWorkgroupAsync(CreateWorkgroupRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateWorkgroupRequest, CreateWorkgroupResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteEndpointAccessResult> deleteEndpointAccessAsync(DeleteEndpointAccessRequest request) {

        return deleteEndpointAccessAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteEndpointAccessResult> deleteEndpointAccessAsync(DeleteEndpointAccessRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteEndpointAccessRequest, DeleteEndpointAccessResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteNamespaceResult> deleteNamespaceAsync(DeleteNamespaceRequest request) {

        return deleteNamespaceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteNamespaceResult> deleteNamespaceAsync(DeleteNamespaceRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteNamespaceRequest, DeleteNamespaceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteResourcePolicyResult> deleteResourcePolicyAsync(DeleteResourcePolicyRequest request) {

        return deleteResourcePolicyAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteResourcePolicyResult> deleteResourcePolicyAsync(DeleteResourcePolicyRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteResourcePolicyRequest, DeleteResourcePolicyResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteSnapshotResult> deleteSnapshotAsync(DeleteSnapshotRequest request) {

        return deleteSnapshotAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteSnapshotResult> deleteSnapshotAsync(DeleteSnapshotRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteSnapshotRequest, DeleteSnapshotResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteUsageLimitResult> deleteUsageLimitAsync(DeleteUsageLimitRequest request) {

        return deleteUsageLimitAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteUsageLimitResult> deleteUsageLimitAsync(DeleteUsageLimitRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteUsageLimitRequest, DeleteUsageLimitResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteWorkgroupResult> deleteWorkgroupAsync(DeleteWorkgroupRequest request) {

        return deleteWorkgroupAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteWorkgroupResult> deleteWorkgroupAsync(DeleteWorkgroupRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteWorkgroupRequest, DeleteWorkgroupResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetCredentialsResult> getCredentialsAsync(GetCredentialsRequest request) {

        return getCredentialsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetCredentialsResult> getCredentialsAsync(GetCredentialsRequest request,
            com.amazonaws.handlers.AsyncHandler<GetCredentialsRequest, GetCredentialsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetEndpointAccessResult> getEndpointAccessAsync(GetEndpointAccessRequest request) {

        return getEndpointAccessAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetEndpointAccessResult> getEndpointAccessAsync(GetEndpointAccessRequest request,
            com.amazonaws.handlers.AsyncHandler<GetEndpointAccessRequest, GetEndpointAccessResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetNamespaceResult> getNamespaceAsync(GetNamespaceRequest request) {

        return getNamespaceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetNamespaceResult> getNamespaceAsync(GetNamespaceRequest request,
            com.amazonaws.handlers.AsyncHandler<GetNamespaceRequest, GetNamespaceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetRecoveryPointResult> getRecoveryPointAsync(GetRecoveryPointRequest request) {

        return getRecoveryPointAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetRecoveryPointResult> getRecoveryPointAsync(GetRecoveryPointRequest request,
            com.amazonaws.handlers.AsyncHandler<GetRecoveryPointRequest, GetRecoveryPointResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetResourcePolicyResult> getResourcePolicyAsync(GetResourcePolicyRequest request) {

        return getResourcePolicyAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetResourcePolicyResult> getResourcePolicyAsync(GetResourcePolicyRequest request,
            com.amazonaws.handlers.AsyncHandler<GetResourcePolicyRequest, GetResourcePolicyResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetSnapshotResult> getSnapshotAsync(GetSnapshotRequest request) {

        return getSnapshotAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetSnapshotResult> getSnapshotAsync(GetSnapshotRequest request,
            com.amazonaws.handlers.AsyncHandler<GetSnapshotRequest, GetSnapshotResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetUsageLimitResult> getUsageLimitAsync(GetUsageLimitRequest request) {

        return getUsageLimitAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetUsageLimitResult> getUsageLimitAsync(GetUsageLimitRequest request,
            com.amazonaws.handlers.AsyncHandler<GetUsageLimitRequest, GetUsageLimitResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetWorkgroupResult> getWorkgroupAsync(GetWorkgroupRequest request) {

        return getWorkgroupAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetWorkgroupResult> getWorkgroupAsync(GetWorkgroupRequest request,
            com.amazonaws.handlers.AsyncHandler<GetWorkgroupRequest, GetWorkgroupResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListEndpointAccessResult> listEndpointAccessAsync(ListEndpointAccessRequest request) {

        return listEndpointAccessAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListEndpointAccessResult> listEndpointAccessAsync(ListEndpointAccessRequest request,
            com.amazonaws.handlers.AsyncHandler<ListEndpointAccessRequest, ListEndpointAccessResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListNamespacesResult> listNamespacesAsync(ListNamespacesRequest request) {

        return listNamespacesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListNamespacesResult> listNamespacesAsync(ListNamespacesRequest request,
            com.amazonaws.handlers.AsyncHandler<ListNamespacesRequest, ListNamespacesResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListRecoveryPointsResult> listRecoveryPointsAsync(ListRecoveryPointsRequest request) {

        return listRecoveryPointsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListRecoveryPointsResult> listRecoveryPointsAsync(ListRecoveryPointsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListRecoveryPointsRequest, ListRecoveryPointsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListSnapshotsResult> listSnapshotsAsync(ListSnapshotsRequest request) {

        return listSnapshotsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListSnapshotsResult> listSnapshotsAsync(ListSnapshotsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListSnapshotsRequest, ListSnapshotsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {

        return listTagsForResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListUsageLimitsResult> listUsageLimitsAsync(ListUsageLimitsRequest request) {

        return listUsageLimitsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListUsageLimitsResult> listUsageLimitsAsync(ListUsageLimitsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListUsageLimitsRequest, ListUsageLimitsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListWorkgroupsResult> listWorkgroupsAsync(ListWorkgroupsRequest request) {

        return listWorkgroupsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListWorkgroupsResult> listWorkgroupsAsync(ListWorkgroupsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListWorkgroupsRequest, ListWorkgroupsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<PutResourcePolicyResult> putResourcePolicyAsync(PutResourcePolicyRequest request) {

        return putResourcePolicyAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<PutResourcePolicyResult> putResourcePolicyAsync(PutResourcePolicyRequest request,
            com.amazonaws.handlers.AsyncHandler<PutResourcePolicyRequest, PutResourcePolicyResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<RestoreFromRecoveryPointResult> restoreFromRecoveryPointAsync(RestoreFromRecoveryPointRequest request) {

        return restoreFromRecoveryPointAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<RestoreFromRecoveryPointResult> restoreFromRecoveryPointAsync(RestoreFromRecoveryPointRequest request,
            com.amazonaws.handlers.AsyncHandler<RestoreFromRecoveryPointRequest, RestoreFromRecoveryPointResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<RestoreFromSnapshotResult> restoreFromSnapshotAsync(RestoreFromSnapshotRequest request) {

        return restoreFromSnapshotAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<RestoreFromSnapshotResult> restoreFromSnapshotAsync(RestoreFromSnapshotRequest request,
            com.amazonaws.handlers.AsyncHandler<RestoreFromSnapshotRequest, RestoreFromSnapshotResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {

        return tagResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<TagResourceResult> tagResourceAsync(TagResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {

        return untagResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateEndpointAccessResult> updateEndpointAccessAsync(UpdateEndpointAccessRequest request) {

        return updateEndpointAccessAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateEndpointAccessResult> updateEndpointAccessAsync(UpdateEndpointAccessRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateEndpointAccessRequest, UpdateEndpointAccessResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateNamespaceResult> updateNamespaceAsync(UpdateNamespaceRequest request) {

        return updateNamespaceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateNamespaceResult> updateNamespaceAsync(UpdateNamespaceRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateNamespaceRequest, UpdateNamespaceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateSnapshotResult> updateSnapshotAsync(UpdateSnapshotRequest request) {

        return updateSnapshotAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateSnapshotResult> updateSnapshotAsync(UpdateSnapshotRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateSnapshotRequest, UpdateSnapshotResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateUsageLimitResult> updateUsageLimitAsync(UpdateUsageLimitRequest request) {

        return updateUsageLimitAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateUsageLimitResult> updateUsageLimitAsync(UpdateUsageLimitRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateUsageLimitRequest, UpdateUsageLimitResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateWorkgroupResult> updateWorkgroupAsync(UpdateWorkgroupRequest request) {

        return updateWorkgroupAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateWorkgroupResult> updateWorkgroupAsync(UpdateWorkgroupRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateWorkgroupRequest, UpdateWorkgroupResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

}
