/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.redshiftdataapi.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-data-2019-12-20/DescribeStatement" target="_top">AWS
 *      API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class DescribeStatementResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * The cluster identifier.
     * </p>
     */
    private String clusterIdentifier;
    /**
     * <p>
     * The date and time (UTC) when the SQL statement was submitted to run.
     * </p>
     */
    private java.util.Date createdAt;
    /**
     * <p>
     * The name of the database.
     * </p>
     */
    private String database;
    /**
     * <p>
     * The database user name.
     * </p>
     */
    private String dbUser;
    /**
     * <p>
     * The amount of time in nanoseconds that the statement ran.
     * </p>
     */
    private Long duration;
    /**
     * <p>
     * The error message from the cluster if the SQL statement encountered an error while running.
     * </p>
     */
    private String error;
    /**
     * <p>
     * A value that indicates whether the statement has a result set. The result set can be empty. The value is true for
     * an empty result set. The value is true if any substatement returns a result set.
     * </p>
     */
    private Boolean hasResultSet;
    /**
     * <p>
     * The identifier of the SQL statement described. This value is a universally unique identifier (UUID) generated by
     * Amazon Redshift Data API.
     * </p>
     */
    private String id;
    /**
     * <p>
     * The parameters for the SQL statement.
     * </p>
     */
    private java.util.List<SqlParameter> queryParameters;
    /**
     * <p>
     * The SQL statement text.
     * </p>
     */
    private String queryString;
    /**
     * <p>
     * The process identifier from Amazon Redshift.
     * </p>
     */
    private Long redshiftPid;
    /**
     * <p>
     * The identifier of the query generated by Amazon Redshift. These identifiers are also available in the
     * <code>query</code> column of the <code>STL_QUERY</code> system view.
     * </p>
     */
    private Long redshiftQueryId;
    /**
     * <p>
     * Either the number of rows returned from the SQL statement or the number of rows affected. If result size is
     * greater than zero, the result rows can be the number of rows affected by SQL statements such as INSERT, UPDATE,
     * DELETE, COPY, and others. A <code>-1</code> indicates the value is null.
     * </p>
     */
    private Long resultRows;
    /**
     * <p>
     * The size in bytes of the returned results. A <code>-1</code> indicates the value is null.
     * </p>
     */
    private Long resultSize;
    /**
     * <p>
     * The name or Amazon Resource Name (ARN) of the secret that enables access to the database.
     * </p>
     */
    private String secretArn;
    /**
     * <p>
     * The status of the SQL statement being described. Status values are defined as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * ABORTED - The query run was stopped by the user.
     * </p>
     * </li>
     * <li>
     * <p>
     * ALL - A status value that includes all query statuses. This value can be used to filter results.
     * </p>
     * </li>
     * <li>
     * <p>
     * FAILED - The query run failed.
     * </p>
     * </li>
     * <li>
     * <p>
     * FINISHED - The query has finished running.
     * </p>
     * </li>
     * <li>
     * <p>
     * PICKED - The query has been chosen to be run.
     * </p>
     * </li>
     * <li>
     * <p>
     * STARTED - The query run has started.
     * </p>
     * </li>
     * <li>
     * <p>
     * SUBMITTED - The query was submitted, but not yet processed.
     * </p>
     * </li>
     * </ul>
     */
    private String status;
    /**
     * <p>
     * The SQL statements from a multiple statement run.
     * </p>
     */
    private java.util.List<SubStatementData> subStatements;
    /**
     * <p>
     * The date and time (UTC) that the metadata for the SQL statement was last updated. An example is the time the
     * status last changed.
     * </p>
     */
    private java.util.Date updatedAt;
    /**
     * <p>
     * The serverless workgroup name or Amazon Resource Name (ARN).
     * </p>
     */
    private String workgroupName;

    /**
     * <p>
     * The cluster identifier.
     * </p>
     * 
     * @param clusterIdentifier
     *        The cluster identifier.
     */

    public void setClusterIdentifier(String clusterIdentifier) {
        this.clusterIdentifier = clusterIdentifier;
    }

    /**
     * <p>
     * The cluster identifier.
     * </p>
     * 
     * @return The cluster identifier.
     */

    public String getClusterIdentifier() {
        return this.clusterIdentifier;
    }

    /**
     * <p>
     * The cluster identifier.
     * </p>
     * 
     * @param clusterIdentifier
     *        The cluster identifier.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeStatementResult withClusterIdentifier(String clusterIdentifier) {
        setClusterIdentifier(clusterIdentifier);
        return this;
    }

    /**
     * <p>
     * The date and time (UTC) when the SQL statement was submitted to run.
     * </p>
     * 
     * @param createdAt
     *        The date and time (UTC) when the SQL statement was submitted to run.
     */

    public void setCreatedAt(java.util.Date createdAt) {
        this.createdAt = createdAt;
    }

    /**
     * <p>
     * The date and time (UTC) when the SQL statement was submitted to run.
     * </p>
     * 
     * @return The date and time (UTC) when the SQL statement was submitted to run.
     */

    public java.util.Date getCreatedAt() {
        return this.createdAt;
    }

    /**
     * <p>
     * The date and time (UTC) when the SQL statement was submitted to run.
     * </p>
     * 
     * @param createdAt
     *        The date and time (UTC) when the SQL statement was submitted to run.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeStatementResult withCreatedAt(java.util.Date createdAt) {
        setCreatedAt(createdAt);
        return this;
    }

    /**
     * <p>
     * The name of the database.
     * </p>
     * 
     * @param database
     *        The name of the database.
     */

    public void setDatabase(String database) {
        this.database = database;
    }

    /**
     * <p>
     * The name of the database.
     * </p>
     * 
     * @return The name of the database.
     */

    public String getDatabase() {
        return this.database;
    }

    /**
     * <p>
     * The name of the database.
     * </p>
     * 
     * @param database
     *        The name of the database.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeStatementResult withDatabase(String database) {
        setDatabase(database);
        return this;
    }

    /**
     * <p>
     * The database user name.
     * </p>
     * 
     * @param dbUser
     *        The database user name.
     */

    public void setDbUser(String dbUser) {
        this.dbUser = dbUser;
    }

    /**
     * <p>
     * The database user name.
     * </p>
     * 
     * @return The database user name.
     */

    public String getDbUser() {
        return this.dbUser;
    }

    /**
     * <p>
     * The database user name.
     * </p>
     * 
     * @param dbUser
     *        The database user name.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeStatementResult withDbUser(String dbUser) {
        setDbUser(dbUser);
        return this;
    }

    /**
     * <p>
     * The amount of time in nanoseconds that the statement ran.
     * </p>
     * 
     * @param duration
     *        The amount of time in nanoseconds that the statement ran.
     */

    public void setDuration(Long duration) {
        this.duration = duration;
    }

    /**
     * <p>
     * The amount of time in nanoseconds that the statement ran.
     * </p>
     * 
     * @return The amount of time in nanoseconds that the statement ran.
     */

    public Long getDuration() {
        return this.duration;
    }

    /**
     * <p>
     * The amount of time in nanoseconds that the statement ran.
     * </p>
     * 
     * @param duration
     *        The amount of time in nanoseconds that the statement ran.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeStatementResult withDuration(Long duration) {
        setDuration(duration);
        return this;
    }

    /**
     * <p>
     * The error message from the cluster if the SQL statement encountered an error while running.
     * </p>
     * 
     * @param error
     *        The error message from the cluster if the SQL statement encountered an error while running.
     */

    public void setError(String error) {
        this.error = error;
    }

    /**
     * <p>
     * The error message from the cluster if the SQL statement encountered an error while running.
     * </p>
     * 
     * @return The error message from the cluster if the SQL statement encountered an error while running.
     */

    public String getError() {
        return this.error;
    }

    /**
     * <p>
     * The error message from the cluster if the SQL statement encountered an error while running.
     * </p>
     * 
     * @param error
     *        The error message from the cluster if the SQL statement encountered an error while running.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeStatementResult withError(String error) {
        setError(error);
        return this;
    }

    /**
     * <p>
     * A value that indicates whether the statement has a result set. The result set can be empty. The value is true for
     * an empty result set. The value is true if any substatement returns a result set.
     * </p>
     * 
     * @param hasResultSet
     *        A value that indicates whether the statement has a result set. The result set can be empty. The value is
     *        true for an empty result set. The value is true if any substatement returns a result set.
     */

    public void setHasResultSet(Boolean hasResultSet) {
        this.hasResultSet = hasResultSet;
    }

    /**
     * <p>
     * A value that indicates whether the statement has a result set. The result set can be empty. The value is true for
     * an empty result set. The value is true if any substatement returns a result set.
     * </p>
     * 
     * @return A value that indicates whether the statement has a result set. The result set can be empty. The value is
     *         true for an empty result set. The value is true if any substatement returns a result set.
     */

    public Boolean getHasResultSet() {
        return this.hasResultSet;
    }

    /**
     * <p>
     * A value that indicates whether the statement has a result set. The result set can be empty. The value is true for
     * an empty result set. The value is true if any substatement returns a result set.
     * </p>
     * 
     * @param hasResultSet
     *        A value that indicates whether the statement has a result set. The result set can be empty. The value is
     *        true for an empty result set. The value is true if any substatement returns a result set.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeStatementResult withHasResultSet(Boolean hasResultSet) {
        setHasResultSet(hasResultSet);
        return this;
    }

    /**
     * <p>
     * A value that indicates whether the statement has a result set. The result set can be empty. The value is true for
     * an empty result set. The value is true if any substatement returns a result set.
     * </p>
     * 
     * @return A value that indicates whether the statement has a result set. The result set can be empty. The value is
     *         true for an empty result set. The value is true if any substatement returns a result set.
     */

    public Boolean isHasResultSet() {
        return this.hasResultSet;
    }

    /**
     * <p>
     * The identifier of the SQL statement described. This value is a universally unique identifier (UUID) generated by
     * Amazon Redshift Data API.
     * </p>
     * 
     * @param id
     *        The identifier of the SQL statement described. This value is a universally unique identifier (UUID)
     *        generated by Amazon Redshift Data API.
     */

    public void setId(String id) {
        this.id = id;
    }

    /**
     * <p>
     * The identifier of the SQL statement described. This value is a universally unique identifier (UUID) generated by
     * Amazon Redshift Data API.
     * </p>
     * 
     * @return The identifier of the SQL statement described. This value is a universally unique identifier (UUID)
     *         generated by Amazon Redshift Data API.
     */

    public String getId() {
        return this.id;
    }

    /**
     * <p>
     * The identifier of the SQL statement described. This value is a universally unique identifier (UUID) generated by
     * Amazon Redshift Data API.
     * </p>
     * 
     * @param id
     *        The identifier of the SQL statement described. This value is a universally unique identifier (UUID)
     *        generated by Amazon Redshift Data API.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeStatementResult withId(String id) {
        setId(id);
        return this;
    }

    /**
     * <p>
     * The parameters for the SQL statement.
     * </p>
     * 
     * @return The parameters for the SQL statement.
     */

    public java.util.List<SqlParameter> getQueryParameters() {
        return queryParameters;
    }

    /**
     * <p>
     * The parameters for the SQL statement.
     * </p>
     * 
     * @param queryParameters
     *        The parameters for the SQL statement.
     */

    public void setQueryParameters(java.util.Collection<SqlParameter> queryParameters) {
        if (queryParameters == null) {
            this.queryParameters = null;
            return;
        }

        this.queryParameters = new java.util.ArrayList<SqlParameter>(queryParameters);
    }

    /**
     * <p>
     * The parameters for the SQL statement.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setQueryParameters(java.util.Collection)} or {@link #withQueryParameters(java.util.Collection)} if you
     * want to override the existing values.
     * </p>
     * 
     * @param queryParameters
     *        The parameters for the SQL statement.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeStatementResult withQueryParameters(SqlParameter... queryParameters) {
        if (this.queryParameters == null) {
            setQueryParameters(new java.util.ArrayList<SqlParameter>(queryParameters.length));
        }
        for (SqlParameter ele : queryParameters) {
            this.queryParameters.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The parameters for the SQL statement.
     * </p>
     * 
     * @param queryParameters
     *        The parameters for the SQL statement.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeStatementResult withQueryParameters(java.util.Collection<SqlParameter> queryParameters) {
        setQueryParameters(queryParameters);
        return this;
    }

    /**
     * <p>
     * The SQL statement text.
     * </p>
     * 
     * @param queryString
     *        The SQL statement text.
     */

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    /**
     * <p>
     * The SQL statement text.
     * </p>
     * 
     * @return The SQL statement text.
     */

    public String getQueryString() {
        return this.queryString;
    }

    /**
     * <p>
     * The SQL statement text.
     * </p>
     * 
     * @param queryString
     *        The SQL statement text.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeStatementResult withQueryString(String queryString) {
        setQueryString(queryString);
        return this;
    }

    /**
     * <p>
     * The process identifier from Amazon Redshift.
     * </p>
     * 
     * @param redshiftPid
     *        The process identifier from Amazon Redshift.
     */

    public void setRedshiftPid(Long redshiftPid) {
        this.redshiftPid = redshiftPid;
    }

    /**
     * <p>
     * The process identifier from Amazon Redshift.
     * </p>
     * 
     * @return The process identifier from Amazon Redshift.
     */

    public Long getRedshiftPid() {
        return this.redshiftPid;
    }

    /**
     * <p>
     * The process identifier from Amazon Redshift.
     * </p>
     * 
     * @param redshiftPid
     *        The process identifier from Amazon Redshift.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeStatementResult withRedshiftPid(Long redshiftPid) {
        setRedshiftPid(redshiftPid);
        return this;
    }

    /**
     * <p>
     * The identifier of the query generated by Amazon Redshift. These identifiers are also available in the
     * <code>query</code> column of the <code>STL_QUERY</code> system view.
     * </p>
     * 
     * @param redshiftQueryId
     *        The identifier of the query generated by Amazon Redshift. These identifiers are also available in the
     *        <code>query</code> column of the <code>STL_QUERY</code> system view.
     */

    public void setRedshiftQueryId(Long redshiftQueryId) {
        this.redshiftQueryId = redshiftQueryId;
    }

    /**
     * <p>
     * The identifier of the query generated by Amazon Redshift. These identifiers are also available in the
     * <code>query</code> column of the <code>STL_QUERY</code> system view.
     * </p>
     * 
     * @return The identifier of the query generated by Amazon Redshift. These identifiers are also available in the
     *         <code>query</code> column of the <code>STL_QUERY</code> system view.
     */

    public Long getRedshiftQueryId() {
        return this.redshiftQueryId;
    }

    /**
     * <p>
     * The identifier of the query generated by Amazon Redshift. These identifiers are also available in the
     * <code>query</code> column of the <code>STL_QUERY</code> system view.
     * </p>
     * 
     * @param redshiftQueryId
     *        The identifier of the query generated by Amazon Redshift. These identifiers are also available in the
     *        <code>query</code> column of the <code>STL_QUERY</code> system view.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeStatementResult withRedshiftQueryId(Long redshiftQueryId) {
        setRedshiftQueryId(redshiftQueryId);
        return this;
    }

    /**
     * <p>
     * Either the number of rows returned from the SQL statement or the number of rows affected. If result size is
     * greater than zero, the result rows can be the number of rows affected by SQL statements such as INSERT, UPDATE,
     * DELETE, COPY, and others. A <code>-1</code> indicates the value is null.
     * </p>
     * 
     * @param resultRows
     *        Either the number of rows returned from the SQL statement or the number of rows affected. If result size
     *        is greater than zero, the result rows can be the number of rows affected by SQL statements such as INSERT,
     *        UPDATE, DELETE, COPY, and others. A <code>-1</code> indicates the value is null.
     */

    public void setResultRows(Long resultRows) {
        this.resultRows = resultRows;
    }

    /**
     * <p>
     * Either the number of rows returned from the SQL statement or the number of rows affected. If result size is
     * greater than zero, the result rows can be the number of rows affected by SQL statements such as INSERT, UPDATE,
     * DELETE, COPY, and others. A <code>-1</code> indicates the value is null.
     * </p>
     * 
     * @return Either the number of rows returned from the SQL statement or the number of rows affected. If result size
     *         is greater than zero, the result rows can be the number of rows affected by SQL statements such as
     *         INSERT, UPDATE, DELETE, COPY, and others. A <code>-1</code> indicates the value is null.
     */

    public Long getResultRows() {
        return this.resultRows;
    }

    /**
     * <p>
     * Either the number of rows returned from the SQL statement or the number of rows affected. If result size is
     * greater than zero, the result rows can be the number of rows affected by SQL statements such as INSERT, UPDATE,
     * DELETE, COPY, and others. A <code>-1</code> indicates the value is null.
     * </p>
     * 
     * @param resultRows
     *        Either the number of rows returned from the SQL statement or the number of rows affected. If result size
     *        is greater than zero, the result rows can be the number of rows affected by SQL statements such as INSERT,
     *        UPDATE, DELETE, COPY, and others. A <code>-1</code> indicates the value is null.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeStatementResult withResultRows(Long resultRows) {
        setResultRows(resultRows);
        return this;
    }

    /**
     * <p>
     * The size in bytes of the returned results. A <code>-1</code> indicates the value is null.
     * </p>
     * 
     * @param resultSize
     *        The size in bytes of the returned results. A <code>-1</code> indicates the value is null.
     */

    public void setResultSize(Long resultSize) {
        this.resultSize = resultSize;
    }

    /**
     * <p>
     * The size in bytes of the returned results. A <code>-1</code> indicates the value is null.
     * </p>
     * 
     * @return The size in bytes of the returned results. A <code>-1</code> indicates the value is null.
     */

    public Long getResultSize() {
        return this.resultSize;
    }

    /**
     * <p>
     * The size in bytes of the returned results. A <code>-1</code> indicates the value is null.
     * </p>
     * 
     * @param resultSize
     *        The size in bytes of the returned results. A <code>-1</code> indicates the value is null.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeStatementResult withResultSize(Long resultSize) {
        setResultSize(resultSize);
        return this;
    }

    /**
     * <p>
     * The name or Amazon Resource Name (ARN) of the secret that enables access to the database.
     * </p>
     * 
     * @param secretArn
     *        The name or Amazon Resource Name (ARN) of the secret that enables access to the database.
     */

    public void setSecretArn(String secretArn) {
        this.secretArn = secretArn;
    }

    /**
     * <p>
     * The name or Amazon Resource Name (ARN) of the secret that enables access to the database.
     * </p>
     * 
     * @return The name or Amazon Resource Name (ARN) of the secret that enables access to the database.
     */

    public String getSecretArn() {
        return this.secretArn;
    }

    /**
     * <p>
     * The name or Amazon Resource Name (ARN) of the secret that enables access to the database.
     * </p>
     * 
     * @param secretArn
     *        The name or Amazon Resource Name (ARN) of the secret that enables access to the database.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeStatementResult withSecretArn(String secretArn) {
        setSecretArn(secretArn);
        return this;
    }

    /**
     * <p>
     * The status of the SQL statement being described. Status values are defined as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * ABORTED - The query run was stopped by the user.
     * </p>
     * </li>
     * <li>
     * <p>
     * ALL - A status value that includes all query statuses. This value can be used to filter results.
     * </p>
     * </li>
     * <li>
     * <p>
     * FAILED - The query run failed.
     * </p>
     * </li>
     * <li>
     * <p>
     * FINISHED - The query has finished running.
     * </p>
     * </li>
     * <li>
     * <p>
     * PICKED - The query has been chosen to be run.
     * </p>
     * </li>
     * <li>
     * <p>
     * STARTED - The query run has started.
     * </p>
     * </li>
     * <li>
     * <p>
     * SUBMITTED - The query was submitted, but not yet processed.
     * </p>
     * </li>
     * </ul>
     * 
     * @param status
     *        The status of the SQL statement being described. Status values are defined as follows: </p>
     *        <ul>
     *        <li>
     *        <p>
     *        ABORTED - The query run was stopped by the user.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        ALL - A status value that includes all query statuses. This value can be used to filter results.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        FAILED - The query run failed.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        FINISHED - The query has finished running.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        PICKED - The query has been chosen to be run.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        STARTED - The query run has started.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        SUBMITTED - The query was submitted, but not yet processed.
     *        </p>
     *        </li>
     * @see StatusString
     */

    public void setStatus(String status) {
        this.status = status;
    }

    /**
     * <p>
     * The status of the SQL statement being described. Status values are defined as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * ABORTED - The query run was stopped by the user.
     * </p>
     * </li>
     * <li>
     * <p>
     * ALL - A status value that includes all query statuses. This value can be used to filter results.
     * </p>
     * </li>
     * <li>
     * <p>
     * FAILED - The query run failed.
     * </p>
     * </li>
     * <li>
     * <p>
     * FINISHED - The query has finished running.
     * </p>
     * </li>
     * <li>
     * <p>
     * PICKED - The query has been chosen to be run.
     * </p>
     * </li>
     * <li>
     * <p>
     * STARTED - The query run has started.
     * </p>
     * </li>
     * <li>
     * <p>
     * SUBMITTED - The query was submitted, but not yet processed.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The status of the SQL statement being described. Status values are defined as follows: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         ABORTED - The query run was stopped by the user.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ALL - A status value that includes all query statuses. This value can be used to filter results.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         FAILED - The query run failed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         FINISHED - The query has finished running.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PICKED - The query has been chosen to be run.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         STARTED - The query run has started.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SUBMITTED - The query was submitted, but not yet processed.
     *         </p>
     *         </li>
     * @see StatusString
     */

    public String getStatus() {
        return this.status;
    }

    /**
     * <p>
     * The status of the SQL statement being described. Status values are defined as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * ABORTED - The query run was stopped by the user.
     * </p>
     * </li>
     * <li>
     * <p>
     * ALL - A status value that includes all query statuses. This value can be used to filter results.
     * </p>
     * </li>
     * <li>
     * <p>
     * FAILED - The query run failed.
     * </p>
     * </li>
     * <li>
     * <p>
     * FINISHED - The query has finished running.
     * </p>
     * </li>
     * <li>
     * <p>
     * PICKED - The query has been chosen to be run.
     * </p>
     * </li>
     * <li>
     * <p>
     * STARTED - The query run has started.
     * </p>
     * </li>
     * <li>
     * <p>
     * SUBMITTED - The query was submitted, but not yet processed.
     * </p>
     * </li>
     * </ul>
     * 
     * @param status
     *        The status of the SQL statement being described. Status values are defined as follows: </p>
     *        <ul>
     *        <li>
     *        <p>
     *        ABORTED - The query run was stopped by the user.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        ALL - A status value that includes all query statuses. This value can be used to filter results.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        FAILED - The query run failed.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        FINISHED - The query has finished running.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        PICKED - The query has been chosen to be run.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        STARTED - The query run has started.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        SUBMITTED - The query was submitted, but not yet processed.
     *        </p>
     *        </li>
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see StatusString
     */

    public DescribeStatementResult withStatus(String status) {
        setStatus(status);
        return this;
    }

    /**
     * <p>
     * The status of the SQL statement being described. Status values are defined as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * ABORTED - The query run was stopped by the user.
     * </p>
     * </li>
     * <li>
     * <p>
     * ALL - A status value that includes all query statuses. This value can be used to filter results.
     * </p>
     * </li>
     * <li>
     * <p>
     * FAILED - The query run failed.
     * </p>
     * </li>
     * <li>
     * <p>
     * FINISHED - The query has finished running.
     * </p>
     * </li>
     * <li>
     * <p>
     * PICKED - The query has been chosen to be run.
     * </p>
     * </li>
     * <li>
     * <p>
     * STARTED - The query run has started.
     * </p>
     * </li>
     * <li>
     * <p>
     * SUBMITTED - The query was submitted, but not yet processed.
     * </p>
     * </li>
     * </ul>
     * 
     * @param status
     *        The status of the SQL statement being described. Status values are defined as follows: </p>
     *        <ul>
     *        <li>
     *        <p>
     *        ABORTED - The query run was stopped by the user.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        ALL - A status value that includes all query statuses. This value can be used to filter results.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        FAILED - The query run failed.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        FINISHED - The query has finished running.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        PICKED - The query has been chosen to be run.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        STARTED - The query run has started.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        SUBMITTED - The query was submitted, but not yet processed.
     *        </p>
     *        </li>
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see StatusString
     */

    public DescribeStatementResult withStatus(StatusString status) {
        this.status = status.toString();
        return this;
    }

    /**
     * <p>
     * The SQL statements from a multiple statement run.
     * </p>
     * 
     * @return The SQL statements from a multiple statement run.
     */

    public java.util.List<SubStatementData> getSubStatements() {
        return subStatements;
    }

    /**
     * <p>
     * The SQL statements from a multiple statement run.
     * </p>
     * 
     * @param subStatements
     *        The SQL statements from a multiple statement run.
     */

    public void setSubStatements(java.util.Collection<SubStatementData> subStatements) {
        if (subStatements == null) {
            this.subStatements = null;
            return;
        }

        this.subStatements = new java.util.ArrayList<SubStatementData>(subStatements);
    }

    /**
     * <p>
     * The SQL statements from a multiple statement run.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setSubStatements(java.util.Collection)} or {@link #withSubStatements(java.util.Collection)} if you want
     * to override the existing values.
     * </p>
     * 
     * @param subStatements
     *        The SQL statements from a multiple statement run.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeStatementResult withSubStatements(SubStatementData... subStatements) {
        if (this.subStatements == null) {
            setSubStatements(new java.util.ArrayList<SubStatementData>(subStatements.length));
        }
        for (SubStatementData ele : subStatements) {
            this.subStatements.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The SQL statements from a multiple statement run.
     * </p>
     * 
     * @param subStatements
     *        The SQL statements from a multiple statement run.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeStatementResult withSubStatements(java.util.Collection<SubStatementData> subStatements) {
        setSubStatements(subStatements);
        return this;
    }

    /**
     * <p>
     * The date and time (UTC) that the metadata for the SQL statement was last updated. An example is the time the
     * status last changed.
     * </p>
     * 
     * @param updatedAt
     *        The date and time (UTC) that the metadata for the SQL statement was last updated. An example is the time
     *        the status last changed.
     */

    public void setUpdatedAt(java.util.Date updatedAt) {
        this.updatedAt = updatedAt;
    }

    /**
     * <p>
     * The date and time (UTC) that the metadata for the SQL statement was last updated. An example is the time the
     * status last changed.
     * </p>
     * 
     * @return The date and time (UTC) that the metadata for the SQL statement was last updated. An example is the time
     *         the status last changed.
     */

    public java.util.Date getUpdatedAt() {
        return this.updatedAt;
    }

    /**
     * <p>
     * The date and time (UTC) that the metadata for the SQL statement was last updated. An example is the time the
     * status last changed.
     * </p>
     * 
     * @param updatedAt
     *        The date and time (UTC) that the metadata for the SQL statement was last updated. An example is the time
     *        the status last changed.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeStatementResult withUpdatedAt(java.util.Date updatedAt) {
        setUpdatedAt(updatedAt);
        return this;
    }

    /**
     * <p>
     * The serverless workgroup name or Amazon Resource Name (ARN).
     * </p>
     * 
     * @param workgroupName
     *        The serverless workgroup name or Amazon Resource Name (ARN).
     */

    public void setWorkgroupName(String workgroupName) {
        this.workgroupName = workgroupName;
    }

    /**
     * <p>
     * The serverless workgroup name or Amazon Resource Name (ARN).
     * </p>
     * 
     * @return The serverless workgroup name or Amazon Resource Name (ARN).
     */

    public String getWorkgroupName() {
        return this.workgroupName;
    }

    /**
     * <p>
     * The serverless workgroup name or Amazon Resource Name (ARN).
     * </p>
     * 
     * @param workgroupName
     *        The serverless workgroup name or Amazon Resource Name (ARN).
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeStatementResult withWorkgroupName(String workgroupName) {
        setWorkgroupName(workgroupName);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getClusterIdentifier() != null)
            sb.append("ClusterIdentifier: ").append(getClusterIdentifier()).append(",");
        if (getCreatedAt() != null)
            sb.append("CreatedAt: ").append(getCreatedAt()).append(",");
        if (getDatabase() != null)
            sb.append("Database: ").append(getDatabase()).append(",");
        if (getDbUser() != null)
            sb.append("DbUser: ").append(getDbUser()).append(",");
        if (getDuration() != null)
            sb.append("Duration: ").append(getDuration()).append(",");
        if (getError() != null)
            sb.append("Error: ").append(getError()).append(",");
        if (getHasResultSet() != null)
            sb.append("HasResultSet: ").append(getHasResultSet()).append(",");
        if (getId() != null)
            sb.append("Id: ").append(getId()).append(",");
        if (getQueryParameters() != null)
            sb.append("QueryParameters: ").append(getQueryParameters()).append(",");
        if (getQueryString() != null)
            sb.append("QueryString: ").append(getQueryString()).append(",");
        if (getRedshiftPid() != null)
            sb.append("RedshiftPid: ").append(getRedshiftPid()).append(",");
        if (getRedshiftQueryId() != null)
            sb.append("RedshiftQueryId: ").append(getRedshiftQueryId()).append(",");
        if (getResultRows() != null)
            sb.append("ResultRows: ").append(getResultRows()).append(",");
        if (getResultSize() != null)
            sb.append("ResultSize: ").append(getResultSize()).append(",");
        if (getSecretArn() != null)
            sb.append("SecretArn: ").append(getSecretArn()).append(",");
        if (getStatus() != null)
            sb.append("Status: ").append(getStatus()).append(",");
        if (getSubStatements() != null)
            sb.append("SubStatements: ").append(getSubStatements()).append(",");
        if (getUpdatedAt() != null)
            sb.append("UpdatedAt: ").append(getUpdatedAt()).append(",");
        if (getWorkgroupName() != null)
            sb.append("WorkgroupName: ").append(getWorkgroupName());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof DescribeStatementResult == false)
            return false;
        DescribeStatementResult other = (DescribeStatementResult) obj;
        if (other.getClusterIdentifier() == null ^ this.getClusterIdentifier() == null)
            return false;
        if (other.getClusterIdentifier() != null && other.getClusterIdentifier().equals(this.getClusterIdentifier()) == false)
            return false;
        if (other.getCreatedAt() == null ^ this.getCreatedAt() == null)
            return false;
        if (other.getCreatedAt() != null && other.getCreatedAt().equals(this.getCreatedAt()) == false)
            return false;
        if (other.getDatabase() == null ^ this.getDatabase() == null)
            return false;
        if (other.getDatabase() != null && other.getDatabase().equals(this.getDatabase()) == false)
            return false;
        if (other.getDbUser() == null ^ this.getDbUser() == null)
            return false;
        if (other.getDbUser() != null && other.getDbUser().equals(this.getDbUser()) == false)
            return false;
        if (other.getDuration() == null ^ this.getDuration() == null)
            return false;
        if (other.getDuration() != null && other.getDuration().equals(this.getDuration()) == false)
            return false;
        if (other.getError() == null ^ this.getError() == null)
            return false;
        if (other.getError() != null && other.getError().equals(this.getError()) == false)
            return false;
        if (other.getHasResultSet() == null ^ this.getHasResultSet() == null)
            return false;
        if (other.getHasResultSet() != null && other.getHasResultSet().equals(this.getHasResultSet()) == false)
            return false;
        if (other.getId() == null ^ this.getId() == null)
            return false;
        if (other.getId() != null && other.getId().equals(this.getId()) == false)
            return false;
        if (other.getQueryParameters() == null ^ this.getQueryParameters() == null)
            return false;
        if (other.getQueryParameters() != null && other.getQueryParameters().equals(this.getQueryParameters()) == false)
            return false;
        if (other.getQueryString() == null ^ this.getQueryString() == null)
            return false;
        if (other.getQueryString() != null && other.getQueryString().equals(this.getQueryString()) == false)
            return false;
        if (other.getRedshiftPid() == null ^ this.getRedshiftPid() == null)
            return false;
        if (other.getRedshiftPid() != null && other.getRedshiftPid().equals(this.getRedshiftPid()) == false)
            return false;
        if (other.getRedshiftQueryId() == null ^ this.getRedshiftQueryId() == null)
            return false;
        if (other.getRedshiftQueryId() != null && other.getRedshiftQueryId().equals(this.getRedshiftQueryId()) == false)
            return false;
        if (other.getResultRows() == null ^ this.getResultRows() == null)
            return false;
        if (other.getResultRows() != null && other.getResultRows().equals(this.getResultRows()) == false)
            return false;
        if (other.getResultSize() == null ^ this.getResultSize() == null)
            return false;
        if (other.getResultSize() != null && other.getResultSize().equals(this.getResultSize()) == false)
            return false;
        if (other.getSecretArn() == null ^ this.getSecretArn() == null)
            return false;
        if (other.getSecretArn() != null && other.getSecretArn().equals(this.getSecretArn()) == false)
            return false;
        if (other.getStatus() == null ^ this.getStatus() == null)
            return false;
        if (other.getStatus() != null && other.getStatus().equals(this.getStatus()) == false)
            return false;
        if (other.getSubStatements() == null ^ this.getSubStatements() == null)
            return false;
        if (other.getSubStatements() != null && other.getSubStatements().equals(this.getSubStatements()) == false)
            return false;
        if (other.getUpdatedAt() == null ^ this.getUpdatedAt() == null)
            return false;
        if (other.getUpdatedAt() != null && other.getUpdatedAt().equals(this.getUpdatedAt()) == false)
            return false;
        if (other.getWorkgroupName() == null ^ this.getWorkgroupName() == null)
            return false;
        if (other.getWorkgroupName() != null && other.getWorkgroupName().equals(this.getWorkgroupName()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getClusterIdentifier() == null) ? 0 : getClusterIdentifier().hashCode());
        hashCode = prime * hashCode + ((getCreatedAt() == null) ? 0 : getCreatedAt().hashCode());
        hashCode = prime * hashCode + ((getDatabase() == null) ? 0 : getDatabase().hashCode());
        hashCode = prime * hashCode + ((getDbUser() == null) ? 0 : getDbUser().hashCode());
        hashCode = prime * hashCode + ((getDuration() == null) ? 0 : getDuration().hashCode());
        hashCode = prime * hashCode + ((getError() == null) ? 0 : getError().hashCode());
        hashCode = prime * hashCode + ((getHasResultSet() == null) ? 0 : getHasResultSet().hashCode());
        hashCode = prime * hashCode + ((getId() == null) ? 0 : getId().hashCode());
        hashCode = prime * hashCode + ((getQueryParameters() == null) ? 0 : getQueryParameters().hashCode());
        hashCode = prime * hashCode + ((getQueryString() == null) ? 0 : getQueryString().hashCode());
        hashCode = prime * hashCode + ((getRedshiftPid() == null) ? 0 : getRedshiftPid().hashCode());
        hashCode = prime * hashCode + ((getRedshiftQueryId() == null) ? 0 : getRedshiftQueryId().hashCode());
        hashCode = prime * hashCode + ((getResultRows() == null) ? 0 : getResultRows().hashCode());
        hashCode = prime * hashCode + ((getResultSize() == null) ? 0 : getResultSize().hashCode());
        hashCode = prime * hashCode + ((getSecretArn() == null) ? 0 : getSecretArn().hashCode());
        hashCode = prime * hashCode + ((getStatus() == null) ? 0 : getStatus().hashCode());
        hashCode = prime * hashCode + ((getSubStatements() == null) ? 0 : getSubStatements().hashCode());
        hashCode = prime * hashCode + ((getUpdatedAt() == null) ? 0 : getUpdatedAt().hashCode());
        hashCode = prime * hashCode + ((getWorkgroupName() == null) ? 0 : getWorkgroupName().hashCode());
        return hashCode;
    }

    @Override
    public DescribeStatementResult clone() {
        try {
            return (DescribeStatementResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
