/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift.model.transform;

import com.amazonaws.services.redshift.model.Recommendation;
import com.amazonaws.services.redshift.model.RecommendedAction;
import com.amazonaws.services.redshift.model.ReferenceLink;
import com.amazonaws.services.redshift.model.transform.RecommendedActionStaxUnmarshaller;
import com.amazonaws.services.redshift.model.transform.ReferenceLinkStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class RecommendationStaxUnmarshaller
implements Unmarshaller<Recommendation, StaxUnmarshallerContext> {
    private static RecommendationStaxUnmarshaller instance;

    public Recommendation unmarshall(StaxUnmarshallerContext context) throws Exception {
        Recommendation recommendation = new Recommendation();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return recommendation;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Id", targetDepth)) {
                    recommendation.setId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ClusterIdentifier", targetDepth)) {
                    recommendation.setClusterIdentifier(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("NamespaceArn", targetDepth)) {
                    recommendation.setNamespaceArn(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CreatedAt", targetDepth)) {
                    recommendation.setCreatedAt(SimpleTypeStaxUnmarshallers.DateStaxUnmarshallerFactory.getInstance((String)"iso8601").unmarshall(context));
                    continue;
                }
                if (context.testExpression("RecommendationType", targetDepth)) {
                    recommendation.setRecommendationType(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Title", targetDepth)) {
                    recommendation.setTitle(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Description", targetDepth)) {
                    recommendation.setDescription(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Observation", targetDepth)) {
                    recommendation.setObservation(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ImpactRanking", targetDepth)) {
                    recommendation.setImpactRanking(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("RecommendationText", targetDepth)) {
                    recommendation.setRecommendationText(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("RecommendedActions", targetDepth)) {
                    recommendation.withRecommendedActions(new ArrayList<RecommendedAction>());
                    continue;
                }
                if (context.testExpression("RecommendedActions/RecommendedAction", targetDepth)) {
                    recommendation.withRecommendedActions(RecommendedActionStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ReferenceLinks", targetDepth)) {
                    recommendation.withReferenceLinks(new ArrayList<ReferenceLink>());
                    continue;
                }
                if (!context.testExpression("ReferenceLinks/ReferenceLink", targetDepth)) continue;
                recommendation.withReferenceLinks(ReferenceLinkStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return recommendation;
    }

    public static RecommendationStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new RecommendationStaxUnmarshaller();
        }
        return instance;
    }
}

