/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift.model.transform;

import com.amazonaws.services.redshift.model.Tag;
import com.amazonaws.services.redshift.model.UsageLimit;
import com.amazonaws.services.redshift.model.transform.TagStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class UsageLimitStaxUnmarshaller
implements Unmarshaller<UsageLimit, StaxUnmarshallerContext> {
    private static UsageLimitStaxUnmarshaller instance;

    public UsageLimit unmarshall(StaxUnmarshallerContext context) throws Exception {
        UsageLimit usageLimit = new UsageLimit();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return usageLimit;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("UsageLimitId", targetDepth)) {
                    usageLimit.setUsageLimitId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ClusterIdentifier", targetDepth)) {
                    usageLimit.setClusterIdentifier(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("FeatureType", targetDepth)) {
                    usageLimit.setFeatureType(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("LimitType", targetDepth)) {
                    usageLimit.setLimitType(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Amount", targetDepth)) {
                    usageLimit.setAmount(SimpleTypeStaxUnmarshallers.LongStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Period", targetDepth)) {
                    usageLimit.setPeriod(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("BreachAction", targetDepth)) {
                    usageLimit.setBreachAction(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Tags", targetDepth)) {
                    usageLimit.withTags(new ArrayList<Tag>());
                    continue;
                }
                if (!context.testExpression("Tags/Tag", targetDepth)) continue;
                usageLimit.withTags(TagStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return usageLimit;
    }

    public static UsageLimitStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new UsageLimitStaxUnmarshaller();
        }
        return instance;
    }
}

