/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift.model.transform;

import com.amazonaws.services.redshift.model.DataTransferProgress;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class DataTransferProgressStaxUnmarshaller
implements Unmarshaller<DataTransferProgress, StaxUnmarshallerContext> {
    private static DataTransferProgressStaxUnmarshaller instance;

    public DataTransferProgress unmarshall(StaxUnmarshallerContext context) throws Exception {
        DataTransferProgress dataTransferProgress = new DataTransferProgress();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return dataTransferProgress;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Status", targetDepth)) {
                    dataTransferProgress.setStatus(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CurrentRateInMegaBytesPerSecond", targetDepth)) {
                    dataTransferProgress.setCurrentRateInMegaBytesPerSecond(SimpleTypeStaxUnmarshallers.DoubleStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("TotalDataInMegaBytes", targetDepth)) {
                    dataTransferProgress.setTotalDataInMegaBytes(SimpleTypeStaxUnmarshallers.LongStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DataTransferredInMegaBytes", targetDepth)) {
                    dataTransferProgress.setDataTransferredInMegaBytes(SimpleTypeStaxUnmarshallers.LongStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("EstimatedTimeToCompletionInSeconds", targetDepth)) {
                    dataTransferProgress.setEstimatedTimeToCompletionInSeconds(SimpleTypeStaxUnmarshallers.LongStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("ElapsedTimeInSeconds", targetDepth)) continue;
                dataTransferProgress.setElapsedTimeInSeconds(SimpleTypeStaxUnmarshallers.LongStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return dataTransferProgress;
    }

    public static DataTransferProgressStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new DataTransferProgressStaxUnmarshaller();
        }
        return instance;
    }
}

