/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift.model.transform;

import com.amazonaws.services.redshift.model.DataShare;
import com.amazonaws.services.redshift.model.DataShareAssociation;
import com.amazonaws.services.redshift.model.transform.DataShareAssociationStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class DataShareStaxUnmarshaller
implements Unmarshaller<DataShare, StaxUnmarshallerContext> {
    private static DataShareStaxUnmarshaller instance;

    public DataShare unmarshall(StaxUnmarshallerContext context) throws Exception {
        DataShare dataShare = new DataShare();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return dataShare;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("DataShareArn", targetDepth)) {
                    dataShare.setDataShareArn(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ProducerArn", targetDepth)) {
                    dataShare.setProducerArn(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("AllowPubliclyAccessibleConsumers", targetDepth)) {
                    dataShare.setAllowPubliclyAccessibleConsumers(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DataShareAssociations", targetDepth)) {
                    dataShare.withDataShareAssociations(new ArrayList<DataShareAssociation>());
                    continue;
                }
                if (!context.testExpression("DataShareAssociations/member", targetDepth)) continue;
                dataShare.withDataShareAssociations(DataShareAssociationStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return dataShare;
    }

    public static DataShareStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new DataShareStaxUnmarshaller();
        }
        return instance;
    }
}

