/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.redshift.model.DescribeScheduledActionsRequest;
import com.amazonaws.services.redshift.model.ScheduledActionFilter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.Date;

public class DescribeScheduledActionsRequestMarshaller
implements Marshaller<Request<DescribeScheduledActionsRequest>, DescribeScheduledActionsRequest> {
    public Request<DescribeScheduledActionsRequest> marshall(DescribeScheduledActionsRequest describeScheduledActionsRequest) {
        if (describeScheduledActionsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeScheduledActionsRequest, "AmazonRedshift");
        request.addParameter("Action", "DescribeScheduledActions");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeScheduledActionsRequest.getScheduledActionName() != null) {
            request.addParameter("ScheduledActionName", StringUtils.fromString((String)describeScheduledActionsRequest.getScheduledActionName()));
        }
        if (describeScheduledActionsRequest.getTargetActionType() != null) {
            request.addParameter("TargetActionType", StringUtils.fromString((String)describeScheduledActionsRequest.getTargetActionType()));
        }
        if (describeScheduledActionsRequest.getStartTime() != null) {
            request.addParameter("StartTime", StringUtils.fromDate((Date)describeScheduledActionsRequest.getStartTime()));
        }
        if (describeScheduledActionsRequest.getEndTime() != null) {
            request.addParameter("EndTime", StringUtils.fromDate((Date)describeScheduledActionsRequest.getEndTime()));
        }
        if (describeScheduledActionsRequest.getActive() != null) {
            request.addParameter("Active", StringUtils.fromBoolean((Boolean)describeScheduledActionsRequest.getActive()));
        }
        if (!describeScheduledActionsRequest.getFilters().isEmpty() || !((SdkInternalList)describeScheduledActionsRequest.getFilters()).isAutoConstruct()) {
            SdkInternalList filtersList = (SdkInternalList)describeScheduledActionsRequest.getFilters();
            int filtersListIndex = 1;
            for (ScheduledActionFilter filtersListValue : filtersList) {
                if (filtersListValue != null) {
                    if (filtersListValue.getName() != null) {
                        request.addParameter("Filters.ScheduledActionFilter." + filtersListIndex + ".Name", StringUtils.fromString((String)filtersListValue.getName()));
                    }
                    if (!filtersListValue.getValues().isEmpty() || !((SdkInternalList)filtersListValue.getValues()).isAutoConstruct()) {
                        SdkInternalList valuesList = (SdkInternalList)filtersListValue.getValues();
                        int valuesListIndex = 1;
                        for (String valuesListValue : valuesList) {
                            if (valuesListValue != null) {
                                request.addParameter("Filters.ScheduledActionFilter." + filtersListIndex + ".Values.item." + valuesListIndex, StringUtils.fromString((String)valuesListValue));
                            }
                            ++valuesListIndex;
                        }
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeScheduledActionsRequest.getMarker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)describeScheduledActionsRequest.getMarker()));
        }
        if (describeScheduledActionsRequest.getMaxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describeScheduledActionsRequest.getMaxRecords()));
        }
        return request;
    }
}

