/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift.model.transform;

import com.amazonaws.services.redshift.model.EndpointAccess;
import com.amazonaws.services.redshift.model.VpcSecurityGroupMembership;
import com.amazonaws.services.redshift.model.transform.VpcEndpointStaxUnmarshaller;
import com.amazonaws.services.redshift.model.transform.VpcSecurityGroupMembershipStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class EndpointAccessStaxUnmarshaller
implements Unmarshaller<EndpointAccess, StaxUnmarshallerContext> {
    private static EndpointAccessStaxUnmarshaller instance;

    public EndpointAccess unmarshall(StaxUnmarshallerContext context) throws Exception {
        EndpointAccess endpointAccess = new EndpointAccess();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return endpointAccess;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("ClusterIdentifier", targetDepth)) {
                    endpointAccess.setClusterIdentifier(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ResourceOwner", targetDepth)) {
                    endpointAccess.setResourceOwner(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SubnetGroupName", targetDepth)) {
                    endpointAccess.setSubnetGroupName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("EndpointStatus", targetDepth)) {
                    endpointAccess.setEndpointStatus(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("EndpointName", targetDepth)) {
                    endpointAccess.setEndpointName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("EndpointCreateTime", targetDepth)) {
                    endpointAccess.setEndpointCreateTime(SimpleTypeStaxUnmarshallers.DateStaxUnmarshallerFactory.getInstance((String)"iso8601").unmarshall(context));
                    continue;
                }
                if (context.testExpression("Port", targetDepth)) {
                    endpointAccess.setPort(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Address", targetDepth)) {
                    endpointAccess.setAddress(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("VpcSecurityGroups", targetDepth)) {
                    endpointAccess.withVpcSecurityGroups(new ArrayList<VpcSecurityGroupMembership>());
                    continue;
                }
                if (context.testExpression("VpcSecurityGroups/VpcSecurityGroup", targetDepth)) {
                    endpointAccess.withVpcSecurityGroups(VpcSecurityGroupMembershipStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("VpcEndpoint", targetDepth)) continue;
                endpointAccess.setVpcEndpoint(VpcEndpointStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return endpointAccess;
    }

    public static EndpointAccessStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new EndpointAccessStaxUnmarshaller();
        }
        return instance;
    }
}

