/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift.model;

import com.amazonaws.internal.SdkInternalList;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class EventInfoMap
implements Serializable,
Cloneable {
    private String eventId;
    private SdkInternalList<String> eventCategories;
    private String eventDescription;
    private String severity;

    public void setEventId(String eventId) {
        this.eventId = eventId;
    }

    public String getEventId() {
        return this.eventId;
    }

    public EventInfoMap withEventId(String eventId) {
        this.setEventId(eventId);
        return this;
    }

    public List<String> getEventCategories() {
        if (this.eventCategories == null) {
            this.eventCategories = new SdkInternalList();
        }
        return this.eventCategories;
    }

    public void setEventCategories(Collection<String> eventCategories) {
        if (eventCategories == null) {
            this.eventCategories = null;
            return;
        }
        this.eventCategories = new SdkInternalList(eventCategories);
    }

    public EventInfoMap withEventCategories(String ... eventCategories) {
        if (this.eventCategories == null) {
            this.setEventCategories((Collection<String>)new SdkInternalList(eventCategories.length));
        }
        for (String ele : eventCategories) {
            this.eventCategories.add((Object)ele);
        }
        return this;
    }

    public EventInfoMap withEventCategories(Collection<String> eventCategories) {
        this.setEventCategories(eventCategories);
        return this;
    }

    public void setEventDescription(String eventDescription) {
        this.eventDescription = eventDescription;
    }

    public String getEventDescription() {
        return this.eventDescription;
    }

    public EventInfoMap withEventDescription(String eventDescription) {
        this.setEventDescription(eventDescription);
        return this;
    }

    public void setSeverity(String severity) {
        this.severity = severity;
    }

    public String getSeverity() {
        return this.severity;
    }

    public EventInfoMap withSeverity(String severity) {
        this.setSeverity(severity);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEventId() != null) {
            sb.append("EventId: ").append(this.getEventId()).append(",");
        }
        if (this.getEventCategories() != null) {
            sb.append("EventCategories: ").append(this.getEventCategories()).append(",");
        }
        if (this.getEventDescription() != null) {
            sb.append("EventDescription: ").append(this.getEventDescription()).append(",");
        }
        if (this.getSeverity() != null) {
            sb.append("Severity: ").append(this.getSeverity());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventInfoMap)) {
            return false;
        }
        EventInfoMap other = (EventInfoMap)obj;
        if (other.getEventId() == null ^ this.getEventId() == null) {
            return false;
        }
        if (other.getEventId() != null && !other.getEventId().equals(this.getEventId())) {
            return false;
        }
        if (other.getEventCategories() == null ^ this.getEventCategories() == null) {
            return false;
        }
        if (other.getEventCategories() != null && !other.getEventCategories().equals(this.getEventCategories())) {
            return false;
        }
        if (other.getEventDescription() == null ^ this.getEventDescription() == null) {
            return false;
        }
        if (other.getEventDescription() != null && !other.getEventDescription().equals(this.getEventDescription())) {
            return false;
        }
        if (other.getSeverity() == null ^ this.getSeverity() == null) {
            return false;
        }
        return other.getSeverity() == null || other.getSeverity().equals(this.getSeverity());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEventId() == null ? 0 : this.getEventId().hashCode());
        hashCode = 31 * hashCode + (this.getEventCategories() == null ? 0 : this.getEventCategories().hashCode());
        hashCode = 31 * hashCode + (this.getEventDescription() == null ? 0 : this.getEventDescription().hashCode());
        hashCode = 31 * hashCode + (this.getSeverity() == null ? 0 : this.getSeverity().hashCode());
        return hashCode;
    }

    public EventInfoMap clone() {
        try {
            return (EventInfoMap)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

