/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.redshift.model.GetClusterCredentialsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class GetClusterCredentialsRequestMarshaller
implements Marshaller<Request<GetClusterCredentialsRequest>, GetClusterCredentialsRequest> {
    public Request<GetClusterCredentialsRequest> marshall(GetClusterCredentialsRequest getClusterCredentialsRequest) {
        SdkInternalList dbGroupsList;
        if (getClusterCredentialsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getClusterCredentialsRequest, "AmazonRedshift");
        request.addParameter("Action", "GetClusterCredentials");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (getClusterCredentialsRequest.getDbUser() != null) {
            request.addParameter("DbUser", StringUtils.fromString((String)getClusterCredentialsRequest.getDbUser()));
        }
        if (getClusterCredentialsRequest.getDbName() != null) {
            request.addParameter("DbName", StringUtils.fromString((String)getClusterCredentialsRequest.getDbName()));
        }
        if (getClusterCredentialsRequest.getClusterIdentifier() != null) {
            request.addParameter("ClusterIdentifier", StringUtils.fromString((String)getClusterCredentialsRequest.getClusterIdentifier()));
        }
        if (getClusterCredentialsRequest.getDurationSeconds() != null) {
            request.addParameter("DurationSeconds", StringUtils.fromInteger((Integer)getClusterCredentialsRequest.getDurationSeconds()));
        }
        if (getClusterCredentialsRequest.getAutoCreate() != null) {
            request.addParameter("AutoCreate", StringUtils.fromBoolean((Boolean)getClusterCredentialsRequest.getAutoCreate()));
        }
        if (!(dbGroupsList = (SdkInternalList)getClusterCredentialsRequest.getDbGroups()).isEmpty() || !dbGroupsList.isAutoConstruct()) {
            int dbGroupsListIndex = 1;
            for (String dbGroupsListValue : dbGroupsList) {
                if (dbGroupsListValue != null) {
                    request.addParameter("DbGroups.DbGroup." + dbGroupsListIndex, StringUtils.fromString((String)dbGroupsListValue));
                }
                ++dbGroupsListIndex;
            }
        }
        return request;
    }
}

