/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift.waiters;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.redshift.AmazonRedshift;
import com.amazonaws.services.redshift.waiters.ClusterAvailable;
import com.amazonaws.services.redshift.waiters.ClusterDeleted;
import com.amazonaws.services.redshift.waiters.ClusterRestored;
import com.amazonaws.services.redshift.waiters.DescribeClusterSnapshotsFunction;
import com.amazonaws.services.redshift.waiters.DescribeClustersFunction;
import com.amazonaws.services.redshift.waiters.SnapshotAvailable;
import com.amazonaws.waiters.FixedDelayStrategy;
import com.amazonaws.waiters.MaxAttemptsRetryStrategy;
import com.amazonaws.waiters.PollingStrategy;
import com.amazonaws.waiters.SdkFunction;
import com.amazonaws.waiters.Waiter;
import com.amazonaws.waiters.WaiterAcceptor;
import com.amazonaws.waiters.WaiterBuilder;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class AmazonRedshiftWaiters {
    private final AmazonRedshift client;
    private final ExecutorService executorService = Executors.newFixedThreadPool(50);

    @SdkInternalApi
    public AmazonRedshiftWaiters(AmazonRedshift client) {
        this.client = client;
    }

    public Waiter clusterDeleted() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeClustersFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new ClusterDeleted.IsClusterNotFoundMatcher(), new ClusterDeleted.IsCreatingMatcher(), new ClusterDeleted.IsModifyingMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(30), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(60))).withExecutorService(this.executorService).build();
    }

    public Waiter snapshotAvailable() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeClusterSnapshotsFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new SnapshotAvailable.IsAvailableMatcher(), new SnapshotAvailable.IsFailedMatcher(), new SnapshotAvailable.IsDeletedMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(20), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }

    public Waiter clusterRestored() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeClustersFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new ClusterRestored.IsCompletedMatcher(), new ClusterRestored.IsDeletingMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(30), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(60))).withExecutorService(this.executorService).build();
    }

    public Waiter clusterAvailable() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeClustersFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new ClusterAvailable.IsAvailableMatcher(), new ClusterAvailable.IsDeletingMatcher(), new ClusterAvailable.IsClusterNotFoundMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(30), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(60))).withExecutorService(this.executorService).build();
    }
}

