/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.redshift.AmazonRedshiftAsync;
import com.amazonaws.services.redshift.AmazonRedshiftClient;
import com.amazonaws.services.redshift.model.AuthorizeClusterSecurityGroupIngressRequest;
import com.amazonaws.services.redshift.model.AuthorizeSnapshotAccessRequest;
import com.amazonaws.services.redshift.model.Cluster;
import com.amazonaws.services.redshift.model.ClusterParameterGroup;
import com.amazonaws.services.redshift.model.ClusterSecurityGroup;
import com.amazonaws.services.redshift.model.ClusterSubnetGroup;
import com.amazonaws.services.redshift.model.CopyClusterSnapshotRequest;
import com.amazonaws.services.redshift.model.CreateClusterParameterGroupRequest;
import com.amazonaws.services.redshift.model.CreateClusterRequest;
import com.amazonaws.services.redshift.model.CreateClusterSecurityGroupRequest;
import com.amazonaws.services.redshift.model.CreateClusterSnapshotRequest;
import com.amazonaws.services.redshift.model.CreateClusterSubnetGroupRequest;
import com.amazonaws.services.redshift.model.CreateEventSubscriptionRequest;
import com.amazonaws.services.redshift.model.CreateHsmClientCertificateRequest;
import com.amazonaws.services.redshift.model.CreateHsmConfigurationRequest;
import com.amazonaws.services.redshift.model.CreateSnapshotCopyGrantRequest;
import com.amazonaws.services.redshift.model.CreateTagsRequest;
import com.amazonaws.services.redshift.model.DefaultClusterParameters;
import com.amazonaws.services.redshift.model.DeleteClusterParameterGroupRequest;
import com.amazonaws.services.redshift.model.DeleteClusterRequest;
import com.amazonaws.services.redshift.model.DeleteClusterSecurityGroupRequest;
import com.amazonaws.services.redshift.model.DeleteClusterSnapshotRequest;
import com.amazonaws.services.redshift.model.DeleteClusterSubnetGroupRequest;
import com.amazonaws.services.redshift.model.DeleteEventSubscriptionRequest;
import com.amazonaws.services.redshift.model.DeleteHsmClientCertificateRequest;
import com.amazonaws.services.redshift.model.DeleteHsmConfigurationRequest;
import com.amazonaws.services.redshift.model.DeleteSnapshotCopyGrantRequest;
import com.amazonaws.services.redshift.model.DeleteTagsRequest;
import com.amazonaws.services.redshift.model.DescribeClusterParameterGroupsRequest;
import com.amazonaws.services.redshift.model.DescribeClusterParameterGroupsResult;
import com.amazonaws.services.redshift.model.DescribeClusterParametersRequest;
import com.amazonaws.services.redshift.model.DescribeClusterParametersResult;
import com.amazonaws.services.redshift.model.DescribeClusterSecurityGroupsRequest;
import com.amazonaws.services.redshift.model.DescribeClusterSecurityGroupsResult;
import com.amazonaws.services.redshift.model.DescribeClusterSnapshotsRequest;
import com.amazonaws.services.redshift.model.DescribeClusterSnapshotsResult;
import com.amazonaws.services.redshift.model.DescribeClusterSubnetGroupsRequest;
import com.amazonaws.services.redshift.model.DescribeClusterSubnetGroupsResult;
import com.amazonaws.services.redshift.model.DescribeClusterVersionsRequest;
import com.amazonaws.services.redshift.model.DescribeClusterVersionsResult;
import com.amazonaws.services.redshift.model.DescribeClustersRequest;
import com.amazonaws.services.redshift.model.DescribeClustersResult;
import com.amazonaws.services.redshift.model.DescribeDefaultClusterParametersRequest;
import com.amazonaws.services.redshift.model.DescribeEventCategoriesRequest;
import com.amazonaws.services.redshift.model.DescribeEventCategoriesResult;
import com.amazonaws.services.redshift.model.DescribeEventSubscriptionsRequest;
import com.amazonaws.services.redshift.model.DescribeEventSubscriptionsResult;
import com.amazonaws.services.redshift.model.DescribeEventsRequest;
import com.amazonaws.services.redshift.model.DescribeEventsResult;
import com.amazonaws.services.redshift.model.DescribeHsmClientCertificatesRequest;
import com.amazonaws.services.redshift.model.DescribeHsmClientCertificatesResult;
import com.amazonaws.services.redshift.model.DescribeHsmConfigurationsRequest;
import com.amazonaws.services.redshift.model.DescribeHsmConfigurationsResult;
import com.amazonaws.services.redshift.model.DescribeLoggingStatusRequest;
import com.amazonaws.services.redshift.model.DescribeLoggingStatusResult;
import com.amazonaws.services.redshift.model.DescribeOrderableClusterOptionsRequest;
import com.amazonaws.services.redshift.model.DescribeOrderableClusterOptionsResult;
import com.amazonaws.services.redshift.model.DescribeReservedNodeOfferingsRequest;
import com.amazonaws.services.redshift.model.DescribeReservedNodeOfferingsResult;
import com.amazonaws.services.redshift.model.DescribeReservedNodesRequest;
import com.amazonaws.services.redshift.model.DescribeReservedNodesResult;
import com.amazonaws.services.redshift.model.DescribeResizeRequest;
import com.amazonaws.services.redshift.model.DescribeResizeResult;
import com.amazonaws.services.redshift.model.DescribeSnapshotCopyGrantsRequest;
import com.amazonaws.services.redshift.model.DescribeSnapshotCopyGrantsResult;
import com.amazonaws.services.redshift.model.DescribeTableRestoreStatusRequest;
import com.amazonaws.services.redshift.model.DescribeTableRestoreStatusResult;
import com.amazonaws.services.redshift.model.DescribeTagsRequest;
import com.amazonaws.services.redshift.model.DescribeTagsResult;
import com.amazonaws.services.redshift.model.DisableLoggingRequest;
import com.amazonaws.services.redshift.model.DisableLoggingResult;
import com.amazonaws.services.redshift.model.DisableSnapshotCopyRequest;
import com.amazonaws.services.redshift.model.EnableLoggingRequest;
import com.amazonaws.services.redshift.model.EnableLoggingResult;
import com.amazonaws.services.redshift.model.EnableSnapshotCopyRequest;
import com.amazonaws.services.redshift.model.EventSubscription;
import com.amazonaws.services.redshift.model.HsmClientCertificate;
import com.amazonaws.services.redshift.model.HsmConfiguration;
import com.amazonaws.services.redshift.model.ModifyClusterParameterGroupRequest;
import com.amazonaws.services.redshift.model.ModifyClusterParameterGroupResult;
import com.amazonaws.services.redshift.model.ModifyClusterRequest;
import com.amazonaws.services.redshift.model.ModifyClusterSubnetGroupRequest;
import com.amazonaws.services.redshift.model.ModifyEventSubscriptionRequest;
import com.amazonaws.services.redshift.model.ModifySnapshotCopyRetentionPeriodRequest;
import com.amazonaws.services.redshift.model.PurchaseReservedNodeOfferingRequest;
import com.amazonaws.services.redshift.model.RebootClusterRequest;
import com.amazonaws.services.redshift.model.ReservedNode;
import com.amazonaws.services.redshift.model.ResetClusterParameterGroupRequest;
import com.amazonaws.services.redshift.model.ResetClusterParameterGroupResult;
import com.amazonaws.services.redshift.model.RestoreFromClusterSnapshotRequest;
import com.amazonaws.services.redshift.model.RestoreTableFromClusterSnapshotRequest;
import com.amazonaws.services.redshift.model.RevokeClusterSecurityGroupIngressRequest;
import com.amazonaws.services.redshift.model.RevokeSnapshotAccessRequest;
import com.amazonaws.services.redshift.model.RotateEncryptionKeyRequest;
import com.amazonaws.services.redshift.model.Snapshot;
import com.amazonaws.services.redshift.model.SnapshotCopyGrant;
import com.amazonaws.services.redshift.model.TableRestoreStatus;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class AmazonRedshiftAsyncClient
extends AmazonRedshiftClient
implements AmazonRedshiftAsync {
    private final ExecutorService executorService;
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;

    public AmazonRedshiftAsyncClient() {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain());
    }

    public AmazonRedshiftAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonRedshiftAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    public AmazonRedshiftAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        super(awsCredentials);
        this.executorService = executorService;
    }

    public AmazonRedshiftAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AmazonRedshiftAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    public AmazonRedshiftAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, new ClientConfiguration(), executorService);
    }

    public AmazonRedshiftAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonRedshiftAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }

    @Override
    public Future<Snapshot> revokeSnapshotAccessAsync(final RevokeSnapshotAccessRequest revokeSnapshotAccessRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Snapshot>(){

            @Override
            public Snapshot call() throws Exception {
                return AmazonRedshiftAsyncClient.this.revokeSnapshotAccess(revokeSnapshotAccessRequest);
            }
        });
    }

    @Override
    public Future<Snapshot> revokeSnapshotAccessAsync(final RevokeSnapshotAccessRequest revokeSnapshotAccessRequest, final AsyncHandler<RevokeSnapshotAccessRequest, Snapshot> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Snapshot>(){

            @Override
            public Snapshot call() throws Exception {
                Snapshot result;
                try {
                    result = AmazonRedshiftAsyncClient.this.revokeSnapshotAccess(revokeSnapshotAccessRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)revokeSnapshotAccessRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<Cluster> modifySnapshotCopyRetentionPeriodAsync(final ModifySnapshotCopyRetentionPeriodRequest modifySnapshotCopyRetentionPeriodRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Cluster>(){

            @Override
            public Cluster call() throws Exception {
                return AmazonRedshiftAsyncClient.this.modifySnapshotCopyRetentionPeriod(modifySnapshotCopyRetentionPeriodRequest);
            }
        });
    }

    @Override
    public Future<Cluster> modifySnapshotCopyRetentionPeriodAsync(final ModifySnapshotCopyRetentionPeriodRequest modifySnapshotCopyRetentionPeriodRequest, final AsyncHandler<ModifySnapshotCopyRetentionPeriodRequest, Cluster> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Cluster>(){

            @Override
            public Cluster call() throws Exception {
                Cluster result;
                try {
                    result = AmazonRedshiftAsyncClient.this.modifySnapshotCopyRetentionPeriod(modifySnapshotCopyRetentionPeriodRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)modifySnapshotCopyRetentionPeriodRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<ClusterSubnetGroup> modifyClusterSubnetGroupAsync(final ModifyClusterSubnetGroupRequest modifyClusterSubnetGroupRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ClusterSubnetGroup>(){

            @Override
            public ClusterSubnetGroup call() throws Exception {
                return AmazonRedshiftAsyncClient.this.modifyClusterSubnetGroup(modifyClusterSubnetGroupRequest);
            }
        });
    }

    @Override
    public Future<ClusterSubnetGroup> modifyClusterSubnetGroupAsync(final ModifyClusterSubnetGroupRequest modifyClusterSubnetGroupRequest, final AsyncHandler<ModifyClusterSubnetGroupRequest, ClusterSubnetGroup> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ClusterSubnetGroup>(){

            @Override
            public ClusterSubnetGroup call() throws Exception {
                ClusterSubnetGroup result;
                try {
                    result = AmazonRedshiftAsyncClient.this.modifyClusterSubnetGroup(modifyClusterSubnetGroupRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)modifyClusterSubnetGroupRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<ReservedNode> purchaseReservedNodeOfferingAsync(final PurchaseReservedNodeOfferingRequest purchaseReservedNodeOfferingRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ReservedNode>(){

            @Override
            public ReservedNode call() throws Exception {
                return AmazonRedshiftAsyncClient.this.purchaseReservedNodeOffering(purchaseReservedNodeOfferingRequest);
            }
        });
    }

    @Override
    public Future<ReservedNode> purchaseReservedNodeOfferingAsync(final PurchaseReservedNodeOfferingRequest purchaseReservedNodeOfferingRequest, final AsyncHandler<PurchaseReservedNodeOfferingRequest, ReservedNode> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ReservedNode>(){

            @Override
            public ReservedNode call() throws Exception {
                ReservedNode result;
                try {
                    result = AmazonRedshiftAsyncClient.this.purchaseReservedNodeOffering(purchaseReservedNodeOfferingRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)purchaseReservedNodeOfferingRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> deleteHsmConfigurationAsync(final DeleteHsmConfigurationRequest deleteHsmConfigurationRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonRedshiftAsyncClient.this.deleteHsmConfiguration(deleteHsmConfigurationRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteHsmConfigurationAsync(final DeleteHsmConfigurationRequest deleteHsmConfigurationRequest, final AsyncHandler<DeleteHsmConfigurationRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonRedshiftAsyncClient.this.deleteHsmConfiguration(deleteHsmConfigurationRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)deleteHsmConfigurationRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<DisableLoggingResult> disableLoggingAsync(final DisableLoggingRequest disableLoggingRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DisableLoggingResult>(){

            @Override
            public DisableLoggingResult call() throws Exception {
                return AmazonRedshiftAsyncClient.this.disableLogging(disableLoggingRequest);
            }
        });
    }

    @Override
    public Future<DisableLoggingResult> disableLoggingAsync(final DisableLoggingRequest disableLoggingRequest, final AsyncHandler<DisableLoggingRequest, DisableLoggingResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DisableLoggingResult>(){

            @Override
            public DisableLoggingResult call() throws Exception {
                DisableLoggingResult result;
                try {
                    result = AmazonRedshiftAsyncClient.this.disableLogging(disableLoggingRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)disableLoggingRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> deleteSnapshotCopyGrantAsync(final DeleteSnapshotCopyGrantRequest deleteSnapshotCopyGrantRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonRedshiftAsyncClient.this.deleteSnapshotCopyGrant(deleteSnapshotCopyGrantRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteSnapshotCopyGrantAsync(final DeleteSnapshotCopyGrantRequest deleteSnapshotCopyGrantRequest, final AsyncHandler<DeleteSnapshotCopyGrantRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonRedshiftAsyncClient.this.deleteSnapshotCopyGrant(deleteSnapshotCopyGrantRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)deleteSnapshotCopyGrantRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<Cluster> modifyClusterAsync(final ModifyClusterRequest modifyClusterRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Cluster>(){

            @Override
            public Cluster call() throws Exception {
                return AmazonRedshiftAsyncClient.this.modifyCluster(modifyClusterRequest);
            }
        });
    }

    @Override
    public Future<Cluster> modifyClusterAsync(final ModifyClusterRequest modifyClusterRequest, final AsyncHandler<ModifyClusterRequest, Cluster> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Cluster>(){

            @Override
            public Cluster call() throws Exception {
                Cluster result;
                try {
                    result = AmazonRedshiftAsyncClient.this.modifyCluster(modifyClusterRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)modifyClusterRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> deleteTagsAsync(final DeleteTagsRequest deleteTagsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonRedshiftAsyncClient.this.deleteTags(deleteTagsRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteTagsAsync(final DeleteTagsRequest deleteTagsRequest, final AsyncHandler<DeleteTagsRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonRedshiftAsyncClient.this.deleteTags(deleteTagsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)deleteTagsRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<Snapshot> copyClusterSnapshotAsync(final CopyClusterSnapshotRequest copyClusterSnapshotRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Snapshot>(){

            @Override
            public Snapshot call() throws Exception {
                return AmazonRedshiftAsyncClient.this.copyClusterSnapshot(copyClusterSnapshotRequest);
            }
        });
    }

    @Override
    public Future<Snapshot> copyClusterSnapshotAsync(final CopyClusterSnapshotRequest copyClusterSnapshotRequest, final AsyncHandler<CopyClusterSnapshotRequest, Snapshot> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Snapshot>(){

            @Override
            public Snapshot call() throws Exception {
                Snapshot result;
                try {
                    result = AmazonRedshiftAsyncClient.this.copyClusterSnapshot(copyClusterSnapshotRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)copyClusterSnapshotRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeOrderableClusterOptionsResult> describeOrderableClusterOptionsAsync(final DescribeOrderableClusterOptionsRequest describeOrderableClusterOptionsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeOrderableClusterOptionsResult>(){

            @Override
            public DescribeOrderableClusterOptionsResult call() throws Exception {
                return AmazonRedshiftAsyncClient.this.describeOrderableClusterOptions(describeOrderableClusterOptionsRequest);
            }
        });
    }

    @Override
    public Future<DescribeOrderableClusterOptionsResult> describeOrderableClusterOptionsAsync(final DescribeOrderableClusterOptionsRequest describeOrderableClusterOptionsRequest, final AsyncHandler<DescribeOrderableClusterOptionsRequest, DescribeOrderableClusterOptionsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeOrderableClusterOptionsResult>(){

            @Override
            public DescribeOrderableClusterOptionsResult call() throws Exception {
                DescribeOrderableClusterOptionsResult result;
                try {
                    result = AmazonRedshiftAsyncClient.this.describeOrderableClusterOptions(describeOrderableClusterOptionsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeOrderableClusterOptionsRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<EnableLoggingResult> enableLoggingAsync(final EnableLoggingRequest enableLoggingRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<EnableLoggingResult>(){

            @Override
            public EnableLoggingResult call() throws Exception {
                return AmazonRedshiftAsyncClient.this.enableLogging(enableLoggingRequest);
            }
        });
    }

    @Override
    public Future<EnableLoggingResult> enableLoggingAsync(final EnableLoggingRequest enableLoggingRequest, final AsyncHandler<EnableLoggingRequest, EnableLoggingResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<EnableLoggingResult>(){

            @Override
            public EnableLoggingResult call() throws Exception {
                EnableLoggingResult result;
                try {
                    result = AmazonRedshiftAsyncClient.this.enableLogging(enableLoggingRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)enableLoggingRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<ClusterSubnetGroup> createClusterSubnetGroupAsync(final CreateClusterSubnetGroupRequest createClusterSubnetGroupRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ClusterSubnetGroup>(){

            @Override
            public ClusterSubnetGroup call() throws Exception {
                return AmazonRedshiftAsyncClient.this.createClusterSubnetGroup(createClusterSubnetGroupRequest);
            }
        });
    }

    @Override
    public Future<ClusterSubnetGroup> createClusterSubnetGroupAsync(final CreateClusterSubnetGroupRequest createClusterSubnetGroupRequest, final AsyncHandler<CreateClusterSubnetGroupRequest, ClusterSubnetGroup> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ClusterSubnetGroup>(){

            @Override
            public ClusterSubnetGroup call() throws Exception {
                ClusterSubnetGroup result;
                try {
                    result = AmazonRedshiftAsyncClient.this.createClusterSubnetGroup(createClusterSubnetGroupRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)createClusterSubnetGroupRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeTableRestoreStatusResult> describeTableRestoreStatusAsync(final DescribeTableRestoreStatusRequest describeTableRestoreStatusRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeTableRestoreStatusResult>(){

            @Override
            public DescribeTableRestoreStatusResult call() throws Exception {
                return AmazonRedshiftAsyncClient.this.describeTableRestoreStatus(describeTableRestoreStatusRequest);
            }
        });
    }

    @Override
    public Future<DescribeTableRestoreStatusResult> describeTableRestoreStatusAsync(final DescribeTableRestoreStatusRequest describeTableRestoreStatusRequest, final AsyncHandler<DescribeTableRestoreStatusRequest, DescribeTableRestoreStatusResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeTableRestoreStatusResult>(){

            @Override
            public DescribeTableRestoreStatusResult call() throws Exception {
                DescribeTableRestoreStatusResult result;
                try {
                    result = AmazonRedshiftAsyncClient.this.describeTableRestoreStatus(describeTableRestoreStatusRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeTableRestoreStatusRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> deleteHsmClientCertificateAsync(final DeleteHsmClientCertificateRequest deleteHsmClientCertificateRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonRedshiftAsyncClient.this.deleteHsmClientCertificate(deleteHsmClientCertificateRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteHsmClientCertificateAsync(final DeleteHsmClientCertificateRequest deleteHsmClientCertificateRequest, final AsyncHandler<DeleteHsmClientCertificateRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonRedshiftAsyncClient.this.deleteHsmClientCertificate(deleteHsmClientCertificateRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)deleteHsmClientCertificateRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<Cluster> rebootClusterAsync(final RebootClusterRequest rebootClusterRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Cluster>(){

            @Override
            public Cluster call() throws Exception {
                return AmazonRedshiftAsyncClient.this.rebootCluster(rebootClusterRequest);
            }
        });
    }

    @Override
    public Future<Cluster> rebootClusterAsync(final RebootClusterRequest rebootClusterRequest, final AsyncHandler<RebootClusterRequest, Cluster> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Cluster>(){

            @Override
            public Cluster call() throws Exception {
                Cluster result;
                try {
                    result = AmazonRedshiftAsyncClient.this.rebootCluster(rebootClusterRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)rebootClusterRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> deleteClusterSubnetGroupAsync(final DeleteClusterSubnetGroupRequest deleteClusterSubnetGroupRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonRedshiftAsyncClient.this.deleteClusterSubnetGroup(deleteClusterSubnetGroupRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteClusterSubnetGroupAsync(final DeleteClusterSubnetGroupRequest deleteClusterSubnetGroupRequest, final AsyncHandler<DeleteClusterSubnetGroupRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonRedshiftAsyncClient.this.deleteClusterSubnetGroup(deleteClusterSubnetGroupRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)deleteClusterSubnetGroupRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<Snapshot> createClusterSnapshotAsync(final CreateClusterSnapshotRequest createClusterSnapshotRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Snapshot>(){

            @Override
            public Snapshot call() throws Exception {
                return AmazonRedshiftAsyncClient.this.createClusterSnapshot(createClusterSnapshotRequest);
            }
        });
    }

    @Override
    public Future<Snapshot> createClusterSnapshotAsync(final CreateClusterSnapshotRequest createClusterSnapshotRequest, final AsyncHandler<CreateClusterSnapshotRequest, Snapshot> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Snapshot>(){

            @Override
            public Snapshot call() throws Exception {
                Snapshot result;
                try {
                    result = AmazonRedshiftAsyncClient.this.createClusterSnapshot(createClusterSnapshotRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)createClusterSnapshotRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<Cluster> deleteClusterAsync(final DeleteClusterRequest deleteClusterRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Cluster>(){

            @Override
            public Cluster call() throws Exception {
                return AmazonRedshiftAsyncClient.this.deleteCluster(deleteClusterRequest);
            }
        });
    }

    @Override
    public Future<Cluster> deleteClusterAsync(final DeleteClusterRequest deleteClusterRequest, final AsyncHandler<DeleteClusterRequest, Cluster> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Cluster>(){

            @Override
            public Cluster call() throws Exception {
                Cluster result;
                try {
                    result = AmazonRedshiftAsyncClient.this.deleteCluster(deleteClusterRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)deleteClusterRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<Cluster> createClusterAsync(final CreateClusterRequest createClusterRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Cluster>(){

            @Override
            public Cluster call() throws Exception {
                return AmazonRedshiftAsyncClient.this.createCluster(createClusterRequest);
            }
        });
    }

    @Override
    public Future<Cluster> createClusterAsync(final CreateClusterRequest createClusterRequest, final AsyncHandler<CreateClusterRequest, Cluster> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Cluster>(){

            @Override
            public Cluster call() throws Exception {
                Cluster result;
                try {
                    result = AmazonRedshiftAsyncClient.this.createCluster(createClusterRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)createClusterRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeEventsResult> describeEventsAsync(final DescribeEventsRequest describeEventsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeEventsResult>(){

            @Override
            public DescribeEventsResult call() throws Exception {
                return AmazonRedshiftAsyncClient.this.describeEvents(describeEventsRequest);
            }
        });
    }

    @Override
    public Future<DescribeEventsResult> describeEventsAsync(final DescribeEventsRequest describeEventsRequest, final AsyncHandler<DescribeEventsRequest, DescribeEventsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeEventsResult>(){

            @Override
            public DescribeEventsResult call() throws Exception {
                DescribeEventsResult result;
                try {
                    result = AmazonRedshiftAsyncClient.this.describeEvents(describeEventsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeEventsRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<ClusterSecurityGroup> authorizeClusterSecurityGroupIngressAsync(final AuthorizeClusterSecurityGroupIngressRequest authorizeClusterSecurityGroupIngressRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ClusterSecurityGroup>(){

            @Override
            public ClusterSecurityGroup call() throws Exception {
                return AmazonRedshiftAsyncClient.this.authorizeClusterSecurityGroupIngress(authorizeClusterSecurityGroupIngressRequest);
            }
        });
    }

    @Override
    public Future<ClusterSecurityGroup> authorizeClusterSecurityGroupIngressAsync(final AuthorizeClusterSecurityGroupIngressRequest authorizeClusterSecurityGroupIngressRequest, final AsyncHandler<AuthorizeClusterSecurityGroupIngressRequest, ClusterSecurityGroup> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ClusterSecurityGroup>(){

            @Override
            public ClusterSecurityGroup call() throws Exception {
                ClusterSecurityGroup result;
                try {
                    result = AmazonRedshiftAsyncClient.this.authorizeClusterSecurityGroupIngress(authorizeClusterSecurityGroupIngressRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)authorizeClusterSecurityGroupIngressRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<Cluster> rotateEncryptionKeyAsync(final RotateEncryptionKeyRequest rotateEncryptionKeyRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Cluster>(){

            @Override
            public Cluster call() throws Exception {
                return AmazonRedshiftAsyncClient.this.rotateEncryptionKey(rotateEncryptionKeyRequest);
            }
        });
    }

    @Override
    public Future<Cluster> rotateEncryptionKeyAsync(final RotateEncryptionKeyRequest rotateEncryptionKeyRequest, final AsyncHandler<RotateEncryptionKeyRequest, Cluster> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Cluster>(){

            @Override
            public Cluster call() throws Exception {
                Cluster result;
                try {
                    result = AmazonRedshiftAsyncClient.this.rotateEncryptionKey(rotateEncryptionKeyRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)rotateEncryptionKeyRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> deleteClusterSecurityGroupAsync(final DeleteClusterSecurityGroupRequest deleteClusterSecurityGroupRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonRedshiftAsyncClient.this.deleteClusterSecurityGroup(deleteClusterSecurityGroupRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteClusterSecurityGroupAsync(final DeleteClusterSecurityGroupRequest deleteClusterSecurityGroupRequest, final AsyncHandler<DeleteClusterSecurityGroupRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonRedshiftAsyncClient.this.deleteClusterSecurityGroup(deleteClusterSecurityGroupRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)deleteClusterSecurityGroupRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<DescribeReservedNodesResult> describeReservedNodesAsync(final DescribeReservedNodesRequest describeReservedNodesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeReservedNodesResult>(){

            @Override
            public DescribeReservedNodesResult call() throws Exception {
                return AmazonRedshiftAsyncClient.this.describeReservedNodes(describeReservedNodesRequest);
            }
        });
    }

    @Override
    public Future<DescribeReservedNodesResult> describeReservedNodesAsync(final DescribeReservedNodesRequest describeReservedNodesRequest, final AsyncHandler<DescribeReservedNodesRequest, DescribeReservedNodesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeReservedNodesResult>(){

            @Override
            public DescribeReservedNodesResult call() throws Exception {
                DescribeReservedNodesResult result;
                try {
                    result = AmazonRedshiftAsyncClient.this.describeReservedNodes(describeReservedNodesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeReservedNodesRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DefaultClusterParameters> describeDefaultClusterParametersAsync(final DescribeDefaultClusterParametersRequest describeDefaultClusterParametersRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DefaultClusterParameters>(){

            @Override
            public DefaultClusterParameters call() throws Exception {
                return AmazonRedshiftAsyncClient.this.describeDefaultClusterParameters(describeDefaultClusterParametersRequest);
            }
        });
    }

    @Override
    public Future<DefaultClusterParameters> describeDefaultClusterParametersAsync(final DescribeDefaultClusterParametersRequest describeDefaultClusterParametersRequest, final AsyncHandler<DescribeDefaultClusterParametersRequest, DefaultClusterParameters> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DefaultClusterParameters>(){

            @Override
            public DefaultClusterParameters call() throws Exception {
                DefaultClusterParameters result;
                try {
                    result = AmazonRedshiftAsyncClient.this.describeDefaultClusterParameters(describeDefaultClusterParametersRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeDefaultClusterParametersRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<EventSubscription> modifyEventSubscriptionAsync(final ModifyEventSubscriptionRequest modifyEventSubscriptionRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<EventSubscription>(){

            @Override
            public EventSubscription call() throws Exception {
                return AmazonRedshiftAsyncClient.this.modifyEventSubscription(modifyEventSubscriptionRequest);
            }
        });
    }

    @Override
    public Future<EventSubscription> modifyEventSubscriptionAsync(final ModifyEventSubscriptionRequest modifyEventSubscriptionRequest, final AsyncHandler<ModifyEventSubscriptionRequest, EventSubscription> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<EventSubscription>(){

            @Override
            public EventSubscription call() throws Exception {
                EventSubscription result;
                try {
                    result = AmazonRedshiftAsyncClient.this.modifyEventSubscription(modifyEventSubscriptionRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)modifyEventSubscriptionRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<ClusterSecurityGroup> createClusterSecurityGroupAsync(final CreateClusterSecurityGroupRequest createClusterSecurityGroupRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ClusterSecurityGroup>(){

            @Override
            public ClusterSecurityGroup call() throws Exception {
                return AmazonRedshiftAsyncClient.this.createClusterSecurityGroup(createClusterSecurityGroupRequest);
            }
        });
    }

    @Override
    public Future<ClusterSecurityGroup> createClusterSecurityGroupAsync(final CreateClusterSecurityGroupRequest createClusterSecurityGroupRequest, final AsyncHandler<CreateClusterSecurityGroupRequest, ClusterSecurityGroup> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ClusterSecurityGroup>(){

            @Override
            public ClusterSecurityGroup call() throws Exception {
                ClusterSecurityGroup result;
                try {
                    result = AmazonRedshiftAsyncClient.this.createClusterSecurityGroup(createClusterSecurityGroupRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)createClusterSecurityGroupRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeResizeResult> describeResizeAsync(final DescribeResizeRequest describeResizeRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeResizeResult>(){

            @Override
            public DescribeResizeResult call() throws Exception {
                return AmazonRedshiftAsyncClient.this.describeResize(describeResizeRequest);
            }
        });
    }

    @Override
    public Future<DescribeResizeResult> describeResizeAsync(final DescribeResizeRequest describeResizeRequest, final AsyncHandler<DescribeResizeRequest, DescribeResizeResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeResizeResult>(){

            @Override
            public DescribeResizeResult call() throws Exception {
                DescribeResizeResult result;
                try {
                    result = AmazonRedshiftAsyncClient.this.describeResize(describeResizeRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeResizeRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeClusterVersionsResult> describeClusterVersionsAsync(final DescribeClusterVersionsRequest describeClusterVersionsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeClusterVersionsResult>(){

            @Override
            public DescribeClusterVersionsResult call() throws Exception {
                return AmazonRedshiftAsyncClient.this.describeClusterVersions(describeClusterVersionsRequest);
            }
        });
    }

    @Override
    public Future<DescribeClusterVersionsResult> describeClusterVersionsAsync(final DescribeClusterVersionsRequest describeClusterVersionsRequest, final AsyncHandler<DescribeClusterVersionsRequest, DescribeClusterVersionsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeClusterVersionsResult>(){

            @Override
            public DescribeClusterVersionsResult call() throws Exception {
                DescribeClusterVersionsResult result;
                try {
                    result = AmazonRedshiftAsyncClient.this.describeClusterVersions(describeClusterVersionsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeClusterVersionsRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<TableRestoreStatus> restoreTableFromClusterSnapshotAsync(final RestoreTableFromClusterSnapshotRequest restoreTableFromClusterSnapshotRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<TableRestoreStatus>(){

            @Override
            public TableRestoreStatus call() throws Exception {
                return AmazonRedshiftAsyncClient.this.restoreTableFromClusterSnapshot(restoreTableFromClusterSnapshotRequest);
            }
        });
    }

    @Override
    public Future<TableRestoreStatus> restoreTableFromClusterSnapshotAsync(final RestoreTableFromClusterSnapshotRequest restoreTableFromClusterSnapshotRequest, final AsyncHandler<RestoreTableFromClusterSnapshotRequest, TableRestoreStatus> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<TableRestoreStatus>(){

            @Override
            public TableRestoreStatus call() throws Exception {
                TableRestoreStatus result;
                try {
                    result = AmazonRedshiftAsyncClient.this.restoreTableFromClusterSnapshot(restoreTableFromClusterSnapshotRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)restoreTableFromClusterSnapshotRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<Cluster> restoreFromClusterSnapshotAsync(final RestoreFromClusterSnapshotRequest restoreFromClusterSnapshotRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Cluster>(){

            @Override
            public Cluster call() throws Exception {
                return AmazonRedshiftAsyncClient.this.restoreFromClusterSnapshot(restoreFromClusterSnapshotRequest);
            }
        });
    }

    @Override
    public Future<Cluster> restoreFromClusterSnapshotAsync(final RestoreFromClusterSnapshotRequest restoreFromClusterSnapshotRequest, final AsyncHandler<RestoreFromClusterSnapshotRequest, Cluster> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Cluster>(){

            @Override
            public Cluster call() throws Exception {
                Cluster result;
                try {
                    result = AmazonRedshiftAsyncClient.this.restoreFromClusterSnapshot(restoreFromClusterSnapshotRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)restoreFromClusterSnapshotRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> createTagsAsync(final CreateTagsRequest createTagsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonRedshiftAsyncClient.this.createTags(createTagsRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> createTagsAsync(final CreateTagsRequest createTagsRequest, final AsyncHandler<CreateTagsRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonRedshiftAsyncClient.this.createTags(createTagsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)createTagsRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<DescribeTagsResult> describeTagsAsync(final DescribeTagsRequest describeTagsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeTagsResult>(){

            @Override
            public DescribeTagsResult call() throws Exception {
                return AmazonRedshiftAsyncClient.this.describeTags(describeTagsRequest);
            }
        });
    }

    @Override
    public Future<DescribeTagsResult> describeTagsAsync(final DescribeTagsRequest describeTagsRequest, final AsyncHandler<DescribeTagsRequest, DescribeTagsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeTagsResult>(){

            @Override
            public DescribeTagsResult call() throws Exception {
                DescribeTagsResult result;
                try {
                    result = AmazonRedshiftAsyncClient.this.describeTags(describeTagsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeTagsRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<ModifyClusterParameterGroupResult> modifyClusterParameterGroupAsync(final ModifyClusterParameterGroupRequest modifyClusterParameterGroupRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ModifyClusterParameterGroupResult>(){

            @Override
            public ModifyClusterParameterGroupResult call() throws Exception {
                return AmazonRedshiftAsyncClient.this.modifyClusterParameterGroup(modifyClusterParameterGroupRequest);
            }
        });
    }

    @Override
    public Future<ModifyClusterParameterGroupResult> modifyClusterParameterGroupAsync(final ModifyClusterParameterGroupRequest modifyClusterParameterGroupRequest, final AsyncHandler<ModifyClusterParameterGroupRequest, ModifyClusterParameterGroupResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ModifyClusterParameterGroupResult>(){

            @Override
            public ModifyClusterParameterGroupResult call() throws Exception {
                ModifyClusterParameterGroupResult result;
                try {
                    result = AmazonRedshiftAsyncClient.this.modifyClusterParameterGroup(modifyClusterParameterGroupRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)modifyClusterParameterGroupRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeEventCategoriesResult> describeEventCategoriesAsync(final DescribeEventCategoriesRequest describeEventCategoriesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeEventCategoriesResult>(){

            @Override
            public DescribeEventCategoriesResult call() throws Exception {
                return AmazonRedshiftAsyncClient.this.describeEventCategories(describeEventCategoriesRequest);
            }
        });
    }

    @Override
    public Future<DescribeEventCategoriesResult> describeEventCategoriesAsync(final DescribeEventCategoriesRequest describeEventCategoriesRequest, final AsyncHandler<DescribeEventCategoriesRequest, DescribeEventCategoriesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeEventCategoriesResult>(){

            @Override
            public DescribeEventCategoriesResult call() throws Exception {
                DescribeEventCategoriesResult result;
                try {
                    result = AmazonRedshiftAsyncClient.this.describeEventCategories(describeEventCategoriesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeEventCategoriesRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeClusterSecurityGroupsResult> describeClusterSecurityGroupsAsync(final DescribeClusterSecurityGroupsRequest describeClusterSecurityGroupsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeClusterSecurityGroupsResult>(){

            @Override
            public DescribeClusterSecurityGroupsResult call() throws Exception {
                return AmazonRedshiftAsyncClient.this.describeClusterSecurityGroups(describeClusterSecurityGroupsRequest);
            }
        });
    }

    @Override
    public Future<DescribeClusterSecurityGroupsResult> describeClusterSecurityGroupsAsync(final DescribeClusterSecurityGroupsRequest describeClusterSecurityGroupsRequest, final AsyncHandler<DescribeClusterSecurityGroupsRequest, DescribeClusterSecurityGroupsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeClusterSecurityGroupsResult>(){

            @Override
            public DescribeClusterSecurityGroupsResult call() throws Exception {
                DescribeClusterSecurityGroupsResult result;
                try {
                    result = AmazonRedshiftAsyncClient.this.describeClusterSecurityGroups(describeClusterSecurityGroupsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeClusterSecurityGroupsRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeClusterSubnetGroupsResult> describeClusterSubnetGroupsAsync(final DescribeClusterSubnetGroupsRequest describeClusterSubnetGroupsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeClusterSubnetGroupsResult>(){

            @Override
            public DescribeClusterSubnetGroupsResult call() throws Exception {
                return AmazonRedshiftAsyncClient.this.describeClusterSubnetGroups(describeClusterSubnetGroupsRequest);
            }
        });
    }

    @Override
    public Future<DescribeClusterSubnetGroupsResult> describeClusterSubnetGroupsAsync(final DescribeClusterSubnetGroupsRequest describeClusterSubnetGroupsRequest, final AsyncHandler<DescribeClusterSubnetGroupsRequest, DescribeClusterSubnetGroupsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeClusterSubnetGroupsResult>(){

            @Override
            public DescribeClusterSubnetGroupsResult call() throws Exception {
                DescribeClusterSubnetGroupsResult result;
                try {
                    result = AmazonRedshiftAsyncClient.this.describeClusterSubnetGroups(describeClusterSubnetGroupsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeClusterSubnetGroupsRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeHsmConfigurationsResult> describeHsmConfigurationsAsync(final DescribeHsmConfigurationsRequest describeHsmConfigurationsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeHsmConfigurationsResult>(){

            @Override
            public DescribeHsmConfigurationsResult call() throws Exception {
                return AmazonRedshiftAsyncClient.this.describeHsmConfigurations(describeHsmConfigurationsRequest);
            }
        });
    }

    @Override
    public Future<DescribeHsmConfigurationsResult> describeHsmConfigurationsAsync(final DescribeHsmConfigurationsRequest describeHsmConfigurationsRequest, final AsyncHandler<DescribeHsmConfigurationsRequest, DescribeHsmConfigurationsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeHsmConfigurationsResult>(){

            @Override
            public DescribeHsmConfigurationsResult call() throws Exception {
                DescribeHsmConfigurationsResult result;
                try {
                    result = AmazonRedshiftAsyncClient.this.describeHsmConfigurations(describeHsmConfigurationsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeHsmConfigurationsRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<Snapshot> deleteClusterSnapshotAsync(final DeleteClusterSnapshotRequest deleteClusterSnapshotRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Snapshot>(){

            @Override
            public Snapshot call() throws Exception {
                return AmazonRedshiftAsyncClient.this.deleteClusterSnapshot(deleteClusterSnapshotRequest);
            }
        });
    }

    @Override
    public Future<Snapshot> deleteClusterSnapshotAsync(final DeleteClusterSnapshotRequest deleteClusterSnapshotRequest, final AsyncHandler<DeleteClusterSnapshotRequest, Snapshot> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Snapshot>(){

            @Override
            public Snapshot call() throws Exception {
                Snapshot result;
                try {
                    result = AmazonRedshiftAsyncClient.this.deleteClusterSnapshot(deleteClusterSnapshotRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)deleteClusterSnapshotRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> deleteClusterParameterGroupAsync(final DeleteClusterParameterGroupRequest deleteClusterParameterGroupRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonRedshiftAsyncClient.this.deleteClusterParameterGroup(deleteClusterParameterGroupRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteClusterParameterGroupAsync(final DeleteClusterParameterGroupRequest deleteClusterParameterGroupRequest, final AsyncHandler<DeleteClusterParameterGroupRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonRedshiftAsyncClient.this.deleteClusterParameterGroup(deleteClusterParameterGroupRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)deleteClusterParameterGroupRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<Cluster> disableSnapshotCopyAsync(final DisableSnapshotCopyRequest disableSnapshotCopyRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Cluster>(){

            @Override
            public Cluster call() throws Exception {
                return AmazonRedshiftAsyncClient.this.disableSnapshotCopy(disableSnapshotCopyRequest);
            }
        });
    }

    @Override
    public Future<Cluster> disableSnapshotCopyAsync(final DisableSnapshotCopyRequest disableSnapshotCopyRequest, final AsyncHandler<DisableSnapshotCopyRequest, Cluster> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Cluster>(){

            @Override
            public Cluster call() throws Exception {
                Cluster result;
                try {
                    result = AmazonRedshiftAsyncClient.this.disableSnapshotCopy(disableSnapshotCopyRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)disableSnapshotCopyRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<EventSubscription> createEventSubscriptionAsync(final CreateEventSubscriptionRequest createEventSubscriptionRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<EventSubscription>(){

            @Override
            public EventSubscription call() throws Exception {
                return AmazonRedshiftAsyncClient.this.createEventSubscription(createEventSubscriptionRequest);
            }
        });
    }

    @Override
    public Future<EventSubscription> createEventSubscriptionAsync(final CreateEventSubscriptionRequest createEventSubscriptionRequest, final AsyncHandler<CreateEventSubscriptionRequest, EventSubscription> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<EventSubscription>(){

            @Override
            public EventSubscription call() throws Exception {
                EventSubscription result;
                try {
                    result = AmazonRedshiftAsyncClient.this.createEventSubscription(createEventSubscriptionRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)createEventSubscriptionRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<ResetClusterParameterGroupResult> resetClusterParameterGroupAsync(final ResetClusterParameterGroupRequest resetClusterParameterGroupRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ResetClusterParameterGroupResult>(){

            @Override
            public ResetClusterParameterGroupResult call() throws Exception {
                return AmazonRedshiftAsyncClient.this.resetClusterParameterGroup(resetClusterParameterGroupRequest);
            }
        });
    }

    @Override
    public Future<ResetClusterParameterGroupResult> resetClusterParameterGroupAsync(final ResetClusterParameterGroupRequest resetClusterParameterGroupRequest, final AsyncHandler<ResetClusterParameterGroupRequest, ResetClusterParameterGroupResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ResetClusterParameterGroupResult>(){

            @Override
            public ResetClusterParameterGroupResult call() throws Exception {
                ResetClusterParameterGroupResult result;
                try {
                    result = AmazonRedshiftAsyncClient.this.resetClusterParameterGroup(resetClusterParameterGroupRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)resetClusterParameterGroupRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeSnapshotCopyGrantsResult> describeSnapshotCopyGrantsAsync(final DescribeSnapshotCopyGrantsRequest describeSnapshotCopyGrantsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeSnapshotCopyGrantsResult>(){

            @Override
            public DescribeSnapshotCopyGrantsResult call() throws Exception {
                return AmazonRedshiftAsyncClient.this.describeSnapshotCopyGrants(describeSnapshotCopyGrantsRequest);
            }
        });
    }

    @Override
    public Future<DescribeSnapshotCopyGrantsResult> describeSnapshotCopyGrantsAsync(final DescribeSnapshotCopyGrantsRequest describeSnapshotCopyGrantsRequest, final AsyncHandler<DescribeSnapshotCopyGrantsRequest, DescribeSnapshotCopyGrantsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeSnapshotCopyGrantsResult>(){

            @Override
            public DescribeSnapshotCopyGrantsResult call() throws Exception {
                DescribeSnapshotCopyGrantsResult result;
                try {
                    result = AmazonRedshiftAsyncClient.this.describeSnapshotCopyGrants(describeSnapshotCopyGrantsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeSnapshotCopyGrantsRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<Snapshot> authorizeSnapshotAccessAsync(final AuthorizeSnapshotAccessRequest authorizeSnapshotAccessRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Snapshot>(){

            @Override
            public Snapshot call() throws Exception {
                return AmazonRedshiftAsyncClient.this.authorizeSnapshotAccess(authorizeSnapshotAccessRequest);
            }
        });
    }

    @Override
    public Future<Snapshot> authorizeSnapshotAccessAsync(final AuthorizeSnapshotAccessRequest authorizeSnapshotAccessRequest, final AsyncHandler<AuthorizeSnapshotAccessRequest, Snapshot> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Snapshot>(){

            @Override
            public Snapshot call() throws Exception {
                Snapshot result;
                try {
                    result = AmazonRedshiftAsyncClient.this.authorizeSnapshotAccess(authorizeSnapshotAccessRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)authorizeSnapshotAccessRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<Cluster> enableSnapshotCopyAsync(final EnableSnapshotCopyRequest enableSnapshotCopyRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Cluster>(){

            @Override
            public Cluster call() throws Exception {
                return AmazonRedshiftAsyncClient.this.enableSnapshotCopy(enableSnapshotCopyRequest);
            }
        });
    }

    @Override
    public Future<Cluster> enableSnapshotCopyAsync(final EnableSnapshotCopyRequest enableSnapshotCopyRequest, final AsyncHandler<EnableSnapshotCopyRequest, Cluster> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Cluster>(){

            @Override
            public Cluster call() throws Exception {
                Cluster result;
                try {
                    result = AmazonRedshiftAsyncClient.this.enableSnapshotCopy(enableSnapshotCopyRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)enableSnapshotCopyRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeReservedNodeOfferingsResult> describeReservedNodeOfferingsAsync(final DescribeReservedNodeOfferingsRequest describeReservedNodeOfferingsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeReservedNodeOfferingsResult>(){

            @Override
            public DescribeReservedNodeOfferingsResult call() throws Exception {
                return AmazonRedshiftAsyncClient.this.describeReservedNodeOfferings(describeReservedNodeOfferingsRequest);
            }
        });
    }

    @Override
    public Future<DescribeReservedNodeOfferingsResult> describeReservedNodeOfferingsAsync(final DescribeReservedNodeOfferingsRequest describeReservedNodeOfferingsRequest, final AsyncHandler<DescribeReservedNodeOfferingsRequest, DescribeReservedNodeOfferingsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeReservedNodeOfferingsResult>(){

            @Override
            public DescribeReservedNodeOfferingsResult call() throws Exception {
                DescribeReservedNodeOfferingsResult result;
                try {
                    result = AmazonRedshiftAsyncClient.this.describeReservedNodeOfferings(describeReservedNodeOfferingsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeReservedNodeOfferingsRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeEventSubscriptionsResult> describeEventSubscriptionsAsync(final DescribeEventSubscriptionsRequest describeEventSubscriptionsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeEventSubscriptionsResult>(){

            @Override
            public DescribeEventSubscriptionsResult call() throws Exception {
                return AmazonRedshiftAsyncClient.this.describeEventSubscriptions(describeEventSubscriptionsRequest);
            }
        });
    }

    @Override
    public Future<DescribeEventSubscriptionsResult> describeEventSubscriptionsAsync(final DescribeEventSubscriptionsRequest describeEventSubscriptionsRequest, final AsyncHandler<DescribeEventSubscriptionsRequest, DescribeEventSubscriptionsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeEventSubscriptionsResult>(){

            @Override
            public DescribeEventSubscriptionsResult call() throws Exception {
                DescribeEventSubscriptionsResult result;
                try {
                    result = AmazonRedshiftAsyncClient.this.describeEventSubscriptions(describeEventSubscriptionsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeEventSubscriptionsRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeLoggingStatusResult> describeLoggingStatusAsync(final DescribeLoggingStatusRequest describeLoggingStatusRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeLoggingStatusResult>(){

            @Override
            public DescribeLoggingStatusResult call() throws Exception {
                return AmazonRedshiftAsyncClient.this.describeLoggingStatus(describeLoggingStatusRequest);
            }
        });
    }

    @Override
    public Future<DescribeLoggingStatusResult> describeLoggingStatusAsync(final DescribeLoggingStatusRequest describeLoggingStatusRequest, final AsyncHandler<DescribeLoggingStatusRequest, DescribeLoggingStatusResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeLoggingStatusResult>(){

            @Override
            public DescribeLoggingStatusResult call() throws Exception {
                DescribeLoggingStatusResult result;
                try {
                    result = AmazonRedshiftAsyncClient.this.describeLoggingStatus(describeLoggingStatusRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeLoggingStatusRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> deleteEventSubscriptionAsync(final DeleteEventSubscriptionRequest deleteEventSubscriptionRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonRedshiftAsyncClient.this.deleteEventSubscription(deleteEventSubscriptionRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteEventSubscriptionAsync(final DeleteEventSubscriptionRequest deleteEventSubscriptionRequest, final AsyncHandler<DeleteEventSubscriptionRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonRedshiftAsyncClient.this.deleteEventSubscription(deleteEventSubscriptionRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)deleteEventSubscriptionRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<HsmClientCertificate> createHsmClientCertificateAsync(final CreateHsmClientCertificateRequest createHsmClientCertificateRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<HsmClientCertificate>(){

            @Override
            public HsmClientCertificate call() throws Exception {
                return AmazonRedshiftAsyncClient.this.createHsmClientCertificate(createHsmClientCertificateRequest);
            }
        });
    }

    @Override
    public Future<HsmClientCertificate> createHsmClientCertificateAsync(final CreateHsmClientCertificateRequest createHsmClientCertificateRequest, final AsyncHandler<CreateHsmClientCertificateRequest, HsmClientCertificate> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<HsmClientCertificate>(){

            @Override
            public HsmClientCertificate call() throws Exception {
                HsmClientCertificate result;
                try {
                    result = AmazonRedshiftAsyncClient.this.createHsmClientCertificate(createHsmClientCertificateRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)createHsmClientCertificateRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeHsmClientCertificatesResult> describeHsmClientCertificatesAsync(final DescribeHsmClientCertificatesRequest describeHsmClientCertificatesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeHsmClientCertificatesResult>(){

            @Override
            public DescribeHsmClientCertificatesResult call() throws Exception {
                return AmazonRedshiftAsyncClient.this.describeHsmClientCertificates(describeHsmClientCertificatesRequest);
            }
        });
    }

    @Override
    public Future<DescribeHsmClientCertificatesResult> describeHsmClientCertificatesAsync(final DescribeHsmClientCertificatesRequest describeHsmClientCertificatesRequest, final AsyncHandler<DescribeHsmClientCertificatesRequest, DescribeHsmClientCertificatesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeHsmClientCertificatesResult>(){

            @Override
            public DescribeHsmClientCertificatesResult call() throws Exception {
                DescribeHsmClientCertificatesResult result;
                try {
                    result = AmazonRedshiftAsyncClient.this.describeHsmClientCertificates(describeHsmClientCertificatesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeHsmClientCertificatesRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeClusterParametersResult> describeClusterParametersAsync(final DescribeClusterParametersRequest describeClusterParametersRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeClusterParametersResult>(){

            @Override
            public DescribeClusterParametersResult call() throws Exception {
                return AmazonRedshiftAsyncClient.this.describeClusterParameters(describeClusterParametersRequest);
            }
        });
    }

    @Override
    public Future<DescribeClusterParametersResult> describeClusterParametersAsync(final DescribeClusterParametersRequest describeClusterParametersRequest, final AsyncHandler<DescribeClusterParametersRequest, DescribeClusterParametersResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeClusterParametersResult>(){

            @Override
            public DescribeClusterParametersResult call() throws Exception {
                DescribeClusterParametersResult result;
                try {
                    result = AmazonRedshiftAsyncClient.this.describeClusterParameters(describeClusterParametersRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeClusterParametersRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<ClusterSecurityGroup> revokeClusterSecurityGroupIngressAsync(final RevokeClusterSecurityGroupIngressRequest revokeClusterSecurityGroupIngressRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ClusterSecurityGroup>(){

            @Override
            public ClusterSecurityGroup call() throws Exception {
                return AmazonRedshiftAsyncClient.this.revokeClusterSecurityGroupIngress(revokeClusterSecurityGroupIngressRequest);
            }
        });
    }

    @Override
    public Future<ClusterSecurityGroup> revokeClusterSecurityGroupIngressAsync(final RevokeClusterSecurityGroupIngressRequest revokeClusterSecurityGroupIngressRequest, final AsyncHandler<RevokeClusterSecurityGroupIngressRequest, ClusterSecurityGroup> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ClusterSecurityGroup>(){

            @Override
            public ClusterSecurityGroup call() throws Exception {
                ClusterSecurityGroup result;
                try {
                    result = AmazonRedshiftAsyncClient.this.revokeClusterSecurityGroupIngress(revokeClusterSecurityGroupIngressRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)revokeClusterSecurityGroupIngressRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeClustersResult> describeClustersAsync(final DescribeClustersRequest describeClustersRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeClustersResult>(){

            @Override
            public DescribeClustersResult call() throws Exception {
                return AmazonRedshiftAsyncClient.this.describeClusters(describeClustersRequest);
            }
        });
    }

    @Override
    public Future<DescribeClustersResult> describeClustersAsync(final DescribeClustersRequest describeClustersRequest, final AsyncHandler<DescribeClustersRequest, DescribeClustersResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeClustersResult>(){

            @Override
            public DescribeClustersResult call() throws Exception {
                DescribeClustersResult result;
                try {
                    result = AmazonRedshiftAsyncClient.this.describeClusters(describeClustersRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeClustersRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<HsmConfiguration> createHsmConfigurationAsync(final CreateHsmConfigurationRequest createHsmConfigurationRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<HsmConfiguration>(){

            @Override
            public HsmConfiguration call() throws Exception {
                return AmazonRedshiftAsyncClient.this.createHsmConfiguration(createHsmConfigurationRequest);
            }
        });
    }

    @Override
    public Future<HsmConfiguration> createHsmConfigurationAsync(final CreateHsmConfigurationRequest createHsmConfigurationRequest, final AsyncHandler<CreateHsmConfigurationRequest, HsmConfiguration> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<HsmConfiguration>(){

            @Override
            public HsmConfiguration call() throws Exception {
                HsmConfiguration result;
                try {
                    result = AmazonRedshiftAsyncClient.this.createHsmConfiguration(createHsmConfigurationRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)createHsmConfigurationRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeClusterSnapshotsResult> describeClusterSnapshotsAsync(final DescribeClusterSnapshotsRequest describeClusterSnapshotsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeClusterSnapshotsResult>(){

            @Override
            public DescribeClusterSnapshotsResult call() throws Exception {
                return AmazonRedshiftAsyncClient.this.describeClusterSnapshots(describeClusterSnapshotsRequest);
            }
        });
    }

    @Override
    public Future<DescribeClusterSnapshotsResult> describeClusterSnapshotsAsync(final DescribeClusterSnapshotsRequest describeClusterSnapshotsRequest, final AsyncHandler<DescribeClusterSnapshotsRequest, DescribeClusterSnapshotsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeClusterSnapshotsResult>(){

            @Override
            public DescribeClusterSnapshotsResult call() throws Exception {
                DescribeClusterSnapshotsResult result;
                try {
                    result = AmazonRedshiftAsyncClient.this.describeClusterSnapshots(describeClusterSnapshotsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeClusterSnapshotsRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<ClusterParameterGroup> createClusterParameterGroupAsync(final CreateClusterParameterGroupRequest createClusterParameterGroupRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ClusterParameterGroup>(){

            @Override
            public ClusterParameterGroup call() throws Exception {
                return AmazonRedshiftAsyncClient.this.createClusterParameterGroup(createClusterParameterGroupRequest);
            }
        });
    }

    @Override
    public Future<ClusterParameterGroup> createClusterParameterGroupAsync(final CreateClusterParameterGroupRequest createClusterParameterGroupRequest, final AsyncHandler<CreateClusterParameterGroupRequest, ClusterParameterGroup> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ClusterParameterGroup>(){

            @Override
            public ClusterParameterGroup call() throws Exception {
                ClusterParameterGroup result;
                try {
                    result = AmazonRedshiftAsyncClient.this.createClusterParameterGroup(createClusterParameterGroupRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)createClusterParameterGroupRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeClusterParameterGroupsResult> describeClusterParameterGroupsAsync(final DescribeClusterParameterGroupsRequest describeClusterParameterGroupsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeClusterParameterGroupsResult>(){

            @Override
            public DescribeClusterParameterGroupsResult call() throws Exception {
                return AmazonRedshiftAsyncClient.this.describeClusterParameterGroups(describeClusterParameterGroupsRequest);
            }
        });
    }

    @Override
    public Future<DescribeClusterParameterGroupsResult> describeClusterParameterGroupsAsync(final DescribeClusterParameterGroupsRequest describeClusterParameterGroupsRequest, final AsyncHandler<DescribeClusterParameterGroupsRequest, DescribeClusterParameterGroupsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeClusterParameterGroupsResult>(){

            @Override
            public DescribeClusterParameterGroupsResult call() throws Exception {
                DescribeClusterParameterGroupsResult result;
                try {
                    result = AmazonRedshiftAsyncClient.this.describeClusterParameterGroups(describeClusterParameterGroupsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeClusterParameterGroupsRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<SnapshotCopyGrant> createSnapshotCopyGrantAsync(final CreateSnapshotCopyGrantRequest createSnapshotCopyGrantRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<SnapshotCopyGrant>(){

            @Override
            public SnapshotCopyGrant call() throws Exception {
                return AmazonRedshiftAsyncClient.this.createSnapshotCopyGrant(createSnapshotCopyGrantRequest);
            }
        });
    }

    @Override
    public Future<SnapshotCopyGrant> createSnapshotCopyGrantAsync(final CreateSnapshotCopyGrantRequest createSnapshotCopyGrantRequest, final AsyncHandler<CreateSnapshotCopyGrantRequest, SnapshotCopyGrant> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<SnapshotCopyGrant>(){

            @Override
            public SnapshotCopyGrant call() throws Exception {
                SnapshotCopyGrant result;
                try {
                    result = AmazonRedshiftAsyncClient.this.createSnapshotCopyGrant(createSnapshotCopyGrantRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)createSnapshotCopyGrantRequest, (Object)result);
                return result;
            }
        });
    }
}

