/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.rds.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * <p/>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateEventSubscription" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class CreateEventSubscriptionRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * The name of the subscription.
     * </p>
     * <p>
     * Constraints: The name must be less than 255 characters.
     * </p>
     */
    private String subscriptionName;
    /**
     * <p>
     * The Amazon Resource Name (ARN) of the SNS topic created for event notification. The ARN is created by Amazon SNS
     * when you create a topic and subscribe to it.
     * </p>
     */
    private String snsTopicArn;
    /**
     * <p>
     * The type of source that is generating the events. For example, if you want to be notified of events generated by
     * a DB instance, you set this parameter to <code>db-instance</code>. For RDS Proxy events, specify
     * <code>db-proxy</code>. If this value isn't specified, all events are returned.
     * </p>
     * <p>
     * Valid Values: <code>db-instance</code> | <code>db-cluster</code> | <code>db-parameter-group</code> |
     * <code>db-security-group</code> | <code>db-snapshot</code> | <code>db-cluster-snapshot</code> |
     * <code>db-proxy</code>
     * </p>
     */
    private String sourceType;
    /**
     * <p>
     * A list of event categories for a particular source type (<code>SourceType</code>) that you want to subscribe to.
     * You can see a list of the categories for a given source type in the
     * "Amazon RDS event categories and event messages" section of the <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.Messages.html"> <i>Amazon RDS User
     * Guide</i> </a> or the <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_Events.Messages.html"> <i>Amazon Aurora
     * User Guide</i> </a>. You can also see this list by using the <code>DescribeEventCategories</code> operation.
     * </p>
     */
    private com.amazonaws.internal.SdkInternalList<String> eventCategories;
    /**
     * <p>
     * The list of identifiers of the event sources for which events are returned. If not specified, then all sources
     * are included in the response. An identifier must begin with a letter and must contain only ASCII letters, digits,
     * and hyphens. It can't end with a hyphen or contain two consecutive hyphens.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If <code>SourceIds</code> are supplied, <code>SourceType</code> must also be provided.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the source type is a DB instance, a <code>DBInstanceIdentifier</code> value must be supplied.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the source type is a DB cluster, a <code>DBClusterIdentifier</code> value must be supplied.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the source type is a DB parameter group, a <code>DBParameterGroupName</code> value must be supplied.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the source type is a DB security group, a <code>DBSecurityGroupName</code> value must be supplied.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the source type is a DB snapshot, a <code>DBSnapshotIdentifier</code> value must be supplied.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the source type is a DB cluster snapshot, a <code>DBClusterSnapshotIdentifier</code> value must be supplied.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the source type is an RDS Proxy, a <code>DBProxyName</code> value must be supplied.
     * </p>
     * </li>
     * </ul>
     */
    private com.amazonaws.internal.SdkInternalList<String> sourceIds;
    /**
     * <p>
     * Specifies whether to activate the subscription. If the event notification subscription isn't activated, the
     * subscription is created but not active.
     * </p>
     */
    private Boolean enabled;

    private com.amazonaws.internal.SdkInternalList<Tag> tags;

    /**
     * <p>
     * The name of the subscription.
     * </p>
     * <p>
     * Constraints: The name must be less than 255 characters.
     * </p>
     * 
     * @param subscriptionName
     *        The name of the subscription.</p>
     *        <p>
     *        Constraints: The name must be less than 255 characters.
     */

    public void setSubscriptionName(String subscriptionName) {
        this.subscriptionName = subscriptionName;
    }

    /**
     * <p>
     * The name of the subscription.
     * </p>
     * <p>
     * Constraints: The name must be less than 255 characters.
     * </p>
     * 
     * @return The name of the subscription.</p>
     *         <p>
     *         Constraints: The name must be less than 255 characters.
     */

    public String getSubscriptionName() {
        return this.subscriptionName;
    }

    /**
     * <p>
     * The name of the subscription.
     * </p>
     * <p>
     * Constraints: The name must be less than 255 characters.
     * </p>
     * 
     * @param subscriptionName
     *        The name of the subscription.</p>
     *        <p>
     *        Constraints: The name must be less than 255 characters.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateEventSubscriptionRequest withSubscriptionName(String subscriptionName) {
        setSubscriptionName(subscriptionName);
        return this;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the SNS topic created for event notification. The ARN is created by Amazon SNS
     * when you create a topic and subscribe to it.
     * </p>
     * 
     * @param snsTopicArn
     *        The Amazon Resource Name (ARN) of the SNS topic created for event notification. The ARN is created by
     *        Amazon SNS when you create a topic and subscribe to it.
     */

    public void setSnsTopicArn(String snsTopicArn) {
        this.snsTopicArn = snsTopicArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the SNS topic created for event notification. The ARN is created by Amazon SNS
     * when you create a topic and subscribe to it.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the SNS topic created for event notification. The ARN is created by
     *         Amazon SNS when you create a topic and subscribe to it.
     */

    public String getSnsTopicArn() {
        return this.snsTopicArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the SNS topic created for event notification. The ARN is created by Amazon SNS
     * when you create a topic and subscribe to it.
     * </p>
     * 
     * @param snsTopicArn
     *        The Amazon Resource Name (ARN) of the SNS topic created for event notification. The ARN is created by
     *        Amazon SNS when you create a topic and subscribe to it.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateEventSubscriptionRequest withSnsTopicArn(String snsTopicArn) {
        setSnsTopicArn(snsTopicArn);
        return this;
    }

    /**
     * <p>
     * The type of source that is generating the events. For example, if you want to be notified of events generated by
     * a DB instance, you set this parameter to <code>db-instance</code>. For RDS Proxy events, specify
     * <code>db-proxy</code>. If this value isn't specified, all events are returned.
     * </p>
     * <p>
     * Valid Values: <code>db-instance</code> | <code>db-cluster</code> | <code>db-parameter-group</code> |
     * <code>db-security-group</code> | <code>db-snapshot</code> | <code>db-cluster-snapshot</code> |
     * <code>db-proxy</code>
     * </p>
     * 
     * @param sourceType
     *        The type of source that is generating the events. For example, if you want to be notified of events
     *        generated by a DB instance, you set this parameter to <code>db-instance</code>. For RDS Proxy events,
     *        specify <code>db-proxy</code>. If this value isn't specified, all events are returned.</p>
     *        <p>
     *        Valid Values: <code>db-instance</code> | <code>db-cluster</code> | <code>db-parameter-group</code> |
     *        <code>db-security-group</code> | <code>db-snapshot</code> | <code>db-cluster-snapshot</code> |
     *        <code>db-proxy</code>
     */

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    /**
     * <p>
     * The type of source that is generating the events. For example, if you want to be notified of events generated by
     * a DB instance, you set this parameter to <code>db-instance</code>. For RDS Proxy events, specify
     * <code>db-proxy</code>. If this value isn't specified, all events are returned.
     * </p>
     * <p>
     * Valid Values: <code>db-instance</code> | <code>db-cluster</code> | <code>db-parameter-group</code> |
     * <code>db-security-group</code> | <code>db-snapshot</code> | <code>db-cluster-snapshot</code> |
     * <code>db-proxy</code>
     * </p>
     * 
     * @return The type of source that is generating the events. For example, if you want to be notified of events
     *         generated by a DB instance, you set this parameter to <code>db-instance</code>. For RDS Proxy events,
     *         specify <code>db-proxy</code>. If this value isn't specified, all events are returned.</p>
     *         <p>
     *         Valid Values: <code>db-instance</code> | <code>db-cluster</code> | <code>db-parameter-group</code> |
     *         <code>db-security-group</code> | <code>db-snapshot</code> | <code>db-cluster-snapshot</code> |
     *         <code>db-proxy</code>
     */

    public String getSourceType() {
        return this.sourceType;
    }

    /**
     * <p>
     * The type of source that is generating the events. For example, if you want to be notified of events generated by
     * a DB instance, you set this parameter to <code>db-instance</code>. For RDS Proxy events, specify
     * <code>db-proxy</code>. If this value isn't specified, all events are returned.
     * </p>
     * <p>
     * Valid Values: <code>db-instance</code> | <code>db-cluster</code> | <code>db-parameter-group</code> |
     * <code>db-security-group</code> | <code>db-snapshot</code> | <code>db-cluster-snapshot</code> |
     * <code>db-proxy</code>
     * </p>
     * 
     * @param sourceType
     *        The type of source that is generating the events. For example, if you want to be notified of events
     *        generated by a DB instance, you set this parameter to <code>db-instance</code>. For RDS Proxy events,
     *        specify <code>db-proxy</code>. If this value isn't specified, all events are returned.</p>
     *        <p>
     *        Valid Values: <code>db-instance</code> | <code>db-cluster</code> | <code>db-parameter-group</code> |
     *        <code>db-security-group</code> | <code>db-snapshot</code> | <code>db-cluster-snapshot</code> |
     *        <code>db-proxy</code>
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateEventSubscriptionRequest withSourceType(String sourceType) {
        setSourceType(sourceType);
        return this;
    }

    /**
     * <p>
     * A list of event categories for a particular source type (<code>SourceType</code>) that you want to subscribe to.
     * You can see a list of the categories for a given source type in the
     * "Amazon RDS event categories and event messages" section of the <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.Messages.html"> <i>Amazon RDS User
     * Guide</i> </a> or the <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_Events.Messages.html"> <i>Amazon Aurora
     * User Guide</i> </a>. You can also see this list by using the <code>DescribeEventCategories</code> operation.
     * </p>
     * 
     * @return A list of event categories for a particular source type (<code>SourceType</code>) that you want to
     *         subscribe to. You can see a list of the categories for a given source type in the
     *         "Amazon RDS event categories and event messages" section of the <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.Messages.html"> <i>Amazon RDS
     *         User Guide</i> </a> or the <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_Events.Messages.html"> <i>Amazon
     *         Aurora User Guide</i> </a>. You can also see this list by using the <code>DescribeEventCategories</code>
     *         operation.
     */

    public java.util.List<String> getEventCategories() {
        if (eventCategories == null) {
            eventCategories = new com.amazonaws.internal.SdkInternalList<String>();
        }
        return eventCategories;
    }

    /**
     * <p>
     * A list of event categories for a particular source type (<code>SourceType</code>) that you want to subscribe to.
     * You can see a list of the categories for a given source type in the
     * "Amazon RDS event categories and event messages" section of the <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.Messages.html"> <i>Amazon RDS User
     * Guide</i> </a> or the <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_Events.Messages.html"> <i>Amazon Aurora
     * User Guide</i> </a>. You can also see this list by using the <code>DescribeEventCategories</code> operation.
     * </p>
     * 
     * @param eventCategories
     *        A list of event categories for a particular source type (<code>SourceType</code>) that you want to
     *        subscribe to. You can see a list of the categories for a given source type in the
     *        "Amazon RDS event categories and event messages" section of the <a
     *        href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.Messages.html"> <i>Amazon RDS
     *        User Guide</i> </a> or the <a
     *        href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_Events.Messages.html"> <i>Amazon
     *        Aurora User Guide</i> </a>. You can also see this list by using the <code>DescribeEventCategories</code>
     *        operation.
     */

    public void setEventCategories(java.util.Collection<String> eventCategories) {
        if (eventCategories == null) {
            this.eventCategories = null;
            return;
        }

        this.eventCategories = new com.amazonaws.internal.SdkInternalList<String>(eventCategories);
    }

    /**
     * <p>
     * A list of event categories for a particular source type (<code>SourceType</code>) that you want to subscribe to.
     * You can see a list of the categories for a given source type in the
     * "Amazon RDS event categories and event messages" section of the <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.Messages.html"> <i>Amazon RDS User
     * Guide</i> </a> or the <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_Events.Messages.html"> <i>Amazon Aurora
     * User Guide</i> </a>. You can also see this list by using the <code>DescribeEventCategories</code> operation.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setEventCategories(java.util.Collection)} or {@link #withEventCategories(java.util.Collection)} if you
     * want to override the existing values.
     * </p>
     * 
     * @param eventCategories
     *        A list of event categories for a particular source type (<code>SourceType</code>) that you want to
     *        subscribe to. You can see a list of the categories for a given source type in the
     *        "Amazon RDS event categories and event messages" section of the <a
     *        href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.Messages.html"> <i>Amazon RDS
     *        User Guide</i> </a> or the <a
     *        href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_Events.Messages.html"> <i>Amazon
     *        Aurora User Guide</i> </a>. You can also see this list by using the <code>DescribeEventCategories</code>
     *        operation.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateEventSubscriptionRequest withEventCategories(String... eventCategories) {
        if (this.eventCategories == null) {
            setEventCategories(new com.amazonaws.internal.SdkInternalList<String>(eventCategories.length));
        }
        for (String ele : eventCategories) {
            this.eventCategories.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * A list of event categories for a particular source type (<code>SourceType</code>) that you want to subscribe to.
     * You can see a list of the categories for a given source type in the
     * "Amazon RDS event categories and event messages" section of the <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.Messages.html"> <i>Amazon RDS User
     * Guide</i> </a> or the <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_Events.Messages.html"> <i>Amazon Aurora
     * User Guide</i> </a>. You can also see this list by using the <code>DescribeEventCategories</code> operation.
     * </p>
     * 
     * @param eventCategories
     *        A list of event categories for a particular source type (<code>SourceType</code>) that you want to
     *        subscribe to. You can see a list of the categories for a given source type in the
     *        "Amazon RDS event categories and event messages" section of the <a
     *        href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.Messages.html"> <i>Amazon RDS
     *        User Guide</i> </a> or the <a
     *        href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_Events.Messages.html"> <i>Amazon
     *        Aurora User Guide</i> </a>. You can also see this list by using the <code>DescribeEventCategories</code>
     *        operation.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateEventSubscriptionRequest withEventCategories(java.util.Collection<String> eventCategories) {
        setEventCategories(eventCategories);
        return this;
    }

    /**
     * <p>
     * The list of identifiers of the event sources for which events are returned. If not specified, then all sources
     * are included in the response. An identifier must begin with a letter and must contain only ASCII letters, digits,
     * and hyphens. It can't end with a hyphen or contain two consecutive hyphens.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If <code>SourceIds</code> are supplied, <code>SourceType</code> must also be provided.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the source type is a DB instance, a <code>DBInstanceIdentifier</code> value must be supplied.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the source type is a DB cluster, a <code>DBClusterIdentifier</code> value must be supplied.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the source type is a DB parameter group, a <code>DBParameterGroupName</code> value must be supplied.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the source type is a DB security group, a <code>DBSecurityGroupName</code> value must be supplied.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the source type is a DB snapshot, a <code>DBSnapshotIdentifier</code> value must be supplied.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the source type is a DB cluster snapshot, a <code>DBClusterSnapshotIdentifier</code> value must be supplied.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the source type is an RDS Proxy, a <code>DBProxyName</code> value must be supplied.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The list of identifiers of the event sources for which events are returned. If not specified, then all
     *         sources are included in the response. An identifier must begin with a letter and must contain only ASCII
     *         letters, digits, and hyphens. It can't end with a hyphen or contain two consecutive hyphens.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If <code>SourceIds</code> are supplied, <code>SourceType</code> must also be provided.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If the source type is a DB instance, a <code>DBInstanceIdentifier</code> value must be supplied.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If the source type is a DB cluster, a <code>DBClusterIdentifier</code> value must be supplied.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If the source type is a DB parameter group, a <code>DBParameterGroupName</code> value must be supplied.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If the source type is a DB security group, a <code>DBSecurityGroupName</code> value must be supplied.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If the source type is a DB snapshot, a <code>DBSnapshotIdentifier</code> value must be supplied.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If the source type is a DB cluster snapshot, a <code>DBClusterSnapshotIdentifier</code> value must be
     *         supplied.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If the source type is an RDS Proxy, a <code>DBProxyName</code> value must be supplied.
     *         </p>
     *         </li>
     */

    public java.util.List<String> getSourceIds() {
        if (sourceIds == null) {
            sourceIds = new com.amazonaws.internal.SdkInternalList<String>();
        }
        return sourceIds;
    }

    /**
     * <p>
     * The list of identifiers of the event sources for which events are returned. If not specified, then all sources
     * are included in the response. An identifier must begin with a letter and must contain only ASCII letters, digits,
     * and hyphens. It can't end with a hyphen or contain two consecutive hyphens.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If <code>SourceIds</code> are supplied, <code>SourceType</code> must also be provided.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the source type is a DB instance, a <code>DBInstanceIdentifier</code> value must be supplied.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the source type is a DB cluster, a <code>DBClusterIdentifier</code> value must be supplied.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the source type is a DB parameter group, a <code>DBParameterGroupName</code> value must be supplied.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the source type is a DB security group, a <code>DBSecurityGroupName</code> value must be supplied.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the source type is a DB snapshot, a <code>DBSnapshotIdentifier</code> value must be supplied.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the source type is a DB cluster snapshot, a <code>DBClusterSnapshotIdentifier</code> value must be supplied.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the source type is an RDS Proxy, a <code>DBProxyName</code> value must be supplied.
     * </p>
     * </li>
     * </ul>
     * 
     * @param sourceIds
     *        The list of identifiers of the event sources for which events are returned. If not specified, then all
     *        sources are included in the response. An identifier must begin with a letter and must contain only ASCII
     *        letters, digits, and hyphens. It can't end with a hyphen or contain two consecutive hyphens.</p>
     *        <p>
     *        Constraints:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        If <code>SourceIds</code> are supplied, <code>SourceType</code> must also be provided.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        If the source type is a DB instance, a <code>DBInstanceIdentifier</code> value must be supplied.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        If the source type is a DB cluster, a <code>DBClusterIdentifier</code> value must be supplied.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        If the source type is a DB parameter group, a <code>DBParameterGroupName</code> value must be supplied.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        If the source type is a DB security group, a <code>DBSecurityGroupName</code> value must be supplied.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        If the source type is a DB snapshot, a <code>DBSnapshotIdentifier</code> value must be supplied.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        If the source type is a DB cluster snapshot, a <code>DBClusterSnapshotIdentifier</code> value must be
     *        supplied.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        If the source type is an RDS Proxy, a <code>DBProxyName</code> value must be supplied.
     *        </p>
     *        </li>
     */

    public void setSourceIds(java.util.Collection<String> sourceIds) {
        if (sourceIds == null) {
            this.sourceIds = null;
            return;
        }

        this.sourceIds = new com.amazonaws.internal.SdkInternalList<String>(sourceIds);
    }

    /**
     * <p>
     * The list of identifiers of the event sources for which events are returned. If not specified, then all sources
     * are included in the response. An identifier must begin with a letter and must contain only ASCII letters, digits,
     * and hyphens. It can't end with a hyphen or contain two consecutive hyphens.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If <code>SourceIds</code> are supplied, <code>SourceType</code> must also be provided.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the source type is a DB instance, a <code>DBInstanceIdentifier</code> value must be supplied.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the source type is a DB cluster, a <code>DBClusterIdentifier</code> value must be supplied.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the source type is a DB parameter group, a <code>DBParameterGroupName</code> value must be supplied.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the source type is a DB security group, a <code>DBSecurityGroupName</code> value must be supplied.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the source type is a DB snapshot, a <code>DBSnapshotIdentifier</code> value must be supplied.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the source type is a DB cluster snapshot, a <code>DBClusterSnapshotIdentifier</code> value must be supplied.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the source type is an RDS Proxy, a <code>DBProxyName</code> value must be supplied.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setSourceIds(java.util.Collection)} or {@link #withSourceIds(java.util.Collection)} if you want to
     * override the existing values.
     * </p>
     * 
     * @param sourceIds
     *        The list of identifiers of the event sources for which events are returned. If not specified, then all
     *        sources are included in the response. An identifier must begin with a letter and must contain only ASCII
     *        letters, digits, and hyphens. It can't end with a hyphen or contain two consecutive hyphens.</p>
     *        <p>
     *        Constraints:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        If <code>SourceIds</code> are supplied, <code>SourceType</code> must also be provided.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        If the source type is a DB instance, a <code>DBInstanceIdentifier</code> value must be supplied.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        If the source type is a DB cluster, a <code>DBClusterIdentifier</code> value must be supplied.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        If the source type is a DB parameter group, a <code>DBParameterGroupName</code> value must be supplied.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        If the source type is a DB security group, a <code>DBSecurityGroupName</code> value must be supplied.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        If the source type is a DB snapshot, a <code>DBSnapshotIdentifier</code> value must be supplied.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        If the source type is a DB cluster snapshot, a <code>DBClusterSnapshotIdentifier</code> value must be
     *        supplied.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        If the source type is an RDS Proxy, a <code>DBProxyName</code> value must be supplied.
     *        </p>
     *        </li>
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateEventSubscriptionRequest withSourceIds(String... sourceIds) {
        if (this.sourceIds == null) {
            setSourceIds(new com.amazonaws.internal.SdkInternalList<String>(sourceIds.length));
        }
        for (String ele : sourceIds) {
            this.sourceIds.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The list of identifiers of the event sources for which events are returned. If not specified, then all sources
     * are included in the response. An identifier must begin with a letter and must contain only ASCII letters, digits,
     * and hyphens. It can't end with a hyphen or contain two consecutive hyphens.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If <code>SourceIds</code> are supplied, <code>SourceType</code> must also be provided.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the source type is a DB instance, a <code>DBInstanceIdentifier</code> value must be supplied.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the source type is a DB cluster, a <code>DBClusterIdentifier</code> value must be supplied.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the source type is a DB parameter group, a <code>DBParameterGroupName</code> value must be supplied.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the source type is a DB security group, a <code>DBSecurityGroupName</code> value must be supplied.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the source type is a DB snapshot, a <code>DBSnapshotIdentifier</code> value must be supplied.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the source type is a DB cluster snapshot, a <code>DBClusterSnapshotIdentifier</code> value must be supplied.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the source type is an RDS Proxy, a <code>DBProxyName</code> value must be supplied.
     * </p>
     * </li>
     * </ul>
     * 
     * @param sourceIds
     *        The list of identifiers of the event sources for which events are returned. If not specified, then all
     *        sources are included in the response. An identifier must begin with a letter and must contain only ASCII
     *        letters, digits, and hyphens. It can't end with a hyphen or contain two consecutive hyphens.</p>
     *        <p>
     *        Constraints:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        If <code>SourceIds</code> are supplied, <code>SourceType</code> must also be provided.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        If the source type is a DB instance, a <code>DBInstanceIdentifier</code> value must be supplied.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        If the source type is a DB cluster, a <code>DBClusterIdentifier</code> value must be supplied.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        If the source type is a DB parameter group, a <code>DBParameterGroupName</code> value must be supplied.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        If the source type is a DB security group, a <code>DBSecurityGroupName</code> value must be supplied.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        If the source type is a DB snapshot, a <code>DBSnapshotIdentifier</code> value must be supplied.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        If the source type is a DB cluster snapshot, a <code>DBClusterSnapshotIdentifier</code> value must be
     *        supplied.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        If the source type is an RDS Proxy, a <code>DBProxyName</code> value must be supplied.
     *        </p>
     *        </li>
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateEventSubscriptionRequest withSourceIds(java.util.Collection<String> sourceIds) {
        setSourceIds(sourceIds);
        return this;
    }

    /**
     * <p>
     * Specifies whether to activate the subscription. If the event notification subscription isn't activated, the
     * subscription is created but not active.
     * </p>
     * 
     * @param enabled
     *        Specifies whether to activate the subscription. If the event notification subscription isn't activated,
     *        the subscription is created but not active.
     */

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    /**
     * <p>
     * Specifies whether to activate the subscription. If the event notification subscription isn't activated, the
     * subscription is created but not active.
     * </p>
     * 
     * @return Specifies whether to activate the subscription. If the event notification subscription isn't activated,
     *         the subscription is created but not active.
     */

    public Boolean getEnabled() {
        return this.enabled;
    }

    /**
     * <p>
     * Specifies whether to activate the subscription. If the event notification subscription isn't activated, the
     * subscription is created but not active.
     * </p>
     * 
     * @param enabled
     *        Specifies whether to activate the subscription. If the event notification subscription isn't activated,
     *        the subscription is created but not active.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateEventSubscriptionRequest withEnabled(Boolean enabled) {
        setEnabled(enabled);
        return this;
    }

    /**
     * <p>
     * Specifies whether to activate the subscription. If the event notification subscription isn't activated, the
     * subscription is created but not active.
     * </p>
     * 
     * @return Specifies whether to activate the subscription. If the event notification subscription isn't activated,
     *         the subscription is created but not active.
     */

    public Boolean isEnabled() {
        return this.enabled;
    }

    /**
     * @return
     */

    public java.util.List<Tag> getTags() {
        if (tags == null) {
            tags = new com.amazonaws.internal.SdkInternalList<Tag>();
        }
        return tags;
    }

    /**
     * @param tags
     */

    public void setTags(java.util.Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }

        this.tags = new com.amazonaws.internal.SdkInternalList<Tag>(tags);
    }

    /**
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setTags(java.util.Collection)} or {@link #withTags(java.util.Collection)} if you want to override the
     * existing values.
     * </p>
     * 
     * @param tags
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateEventSubscriptionRequest withTags(Tag... tags) {
        if (this.tags == null) {
            setTags(new com.amazonaws.internal.SdkInternalList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    /**
     * @param tags
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateEventSubscriptionRequest withTags(java.util.Collection<Tag> tags) {
        setTags(tags);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getSubscriptionName() != null)
            sb.append("SubscriptionName: ").append(getSubscriptionName()).append(",");
        if (getSnsTopicArn() != null)
            sb.append("SnsTopicArn: ").append(getSnsTopicArn()).append(",");
        if (getSourceType() != null)
            sb.append("SourceType: ").append(getSourceType()).append(",");
        if (getEventCategories() != null)
            sb.append("EventCategories: ").append(getEventCategories()).append(",");
        if (getSourceIds() != null)
            sb.append("SourceIds: ").append(getSourceIds()).append(",");
        if (getEnabled() != null)
            sb.append("Enabled: ").append(getEnabled()).append(",");
        if (getTags() != null)
            sb.append("Tags: ").append(getTags());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof CreateEventSubscriptionRequest == false)
            return false;
        CreateEventSubscriptionRequest other = (CreateEventSubscriptionRequest) obj;
        if (other.getSubscriptionName() == null ^ this.getSubscriptionName() == null)
            return false;
        if (other.getSubscriptionName() != null && other.getSubscriptionName().equals(this.getSubscriptionName()) == false)
            return false;
        if (other.getSnsTopicArn() == null ^ this.getSnsTopicArn() == null)
            return false;
        if (other.getSnsTopicArn() != null && other.getSnsTopicArn().equals(this.getSnsTopicArn()) == false)
            return false;
        if (other.getSourceType() == null ^ this.getSourceType() == null)
            return false;
        if (other.getSourceType() != null && other.getSourceType().equals(this.getSourceType()) == false)
            return false;
        if (other.getEventCategories() == null ^ this.getEventCategories() == null)
            return false;
        if (other.getEventCategories() != null && other.getEventCategories().equals(this.getEventCategories()) == false)
            return false;
        if (other.getSourceIds() == null ^ this.getSourceIds() == null)
            return false;
        if (other.getSourceIds() != null && other.getSourceIds().equals(this.getSourceIds()) == false)
            return false;
        if (other.getEnabled() == null ^ this.getEnabled() == null)
            return false;
        if (other.getEnabled() != null && other.getEnabled().equals(this.getEnabled()) == false)
            return false;
        if (other.getTags() == null ^ this.getTags() == null)
            return false;
        if (other.getTags() != null && other.getTags().equals(this.getTags()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getSubscriptionName() == null) ? 0 : getSubscriptionName().hashCode());
        hashCode = prime * hashCode + ((getSnsTopicArn() == null) ? 0 : getSnsTopicArn().hashCode());
        hashCode = prime * hashCode + ((getSourceType() == null) ? 0 : getSourceType().hashCode());
        hashCode = prime * hashCode + ((getEventCategories() == null) ? 0 : getEventCategories().hashCode());
        hashCode = prime * hashCode + ((getSourceIds() == null) ? 0 : getSourceIds().hashCode());
        hashCode = prime * hashCode + ((getEnabled() == null) ? 0 : getEnabled().hashCode());
        hashCode = prime * hashCode + ((getTags() == null) ? 0 : getTags().hashCode());
        return hashCode;
    }

    @Override
    public CreateEventSubscriptionRequest clone() {
        return (CreateEventSubscriptionRequest) super.clone();
    }

}
