/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.rds.model.AvailabilityZone;
import com.amazonaws.services.rds.model.AvailableProcessorFeature;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class OrderableDBInstanceOption
implements Serializable,
Cloneable {
    private String engine;
    private String engineVersion;
    private String dBInstanceClass;
    private String licenseModel;
    private String availabilityZoneGroup;
    private SdkInternalList<AvailabilityZone> availabilityZones;
    private Boolean multiAZCapable;
    private Boolean readReplicaCapable;
    private Boolean vpc;
    private Boolean supportsStorageEncryption;
    private String storageType;
    private Boolean supportsIops;
    private Boolean supportsEnhancedMonitoring;
    private Boolean supportsIAMDatabaseAuthentication;
    private Boolean supportsPerformanceInsights;
    private Integer minStorageSize;
    private Integer maxStorageSize;
    private Integer minIopsPerDbInstance;
    private Integer maxIopsPerDbInstance;
    private Double minIopsPerGib;
    private Double maxIopsPerGib;
    private SdkInternalList<AvailableProcessorFeature> availableProcessorFeatures;
    private SdkInternalList<String> supportedEngineModes;
    private Boolean supportsStorageAutoscaling;
    private Boolean supportsKerberosAuthentication;
    private Boolean outpostCapable;
    private SdkInternalList<String> supportedActivityStreamModes;
    private Boolean supportsGlobalDatabases;
    private Boolean supportsClusters;
    private SdkInternalList<String> supportedNetworkTypes;
    private Boolean supportsStorageThroughput;
    private Integer minStorageThroughputPerDbInstance;
    private Integer maxStorageThroughputPerDbInstance;
    private Double minStorageThroughputPerIops;
    private Double maxStorageThroughputPerIops;

    public void setEngine(String engine) {
        this.engine = engine;
    }

    public String getEngine() {
        return this.engine;
    }

    public OrderableDBInstanceOption withEngine(String engine) {
        this.setEngine(engine);
        return this;
    }

    public void setEngineVersion(String engineVersion) {
        this.engineVersion = engineVersion;
    }

    public String getEngineVersion() {
        return this.engineVersion;
    }

    public OrderableDBInstanceOption withEngineVersion(String engineVersion) {
        this.setEngineVersion(engineVersion);
        return this;
    }

    public void setDBInstanceClass(String dBInstanceClass) {
        this.dBInstanceClass = dBInstanceClass;
    }

    public String getDBInstanceClass() {
        return this.dBInstanceClass;
    }

    public OrderableDBInstanceOption withDBInstanceClass(String dBInstanceClass) {
        this.setDBInstanceClass(dBInstanceClass);
        return this;
    }

    public void setLicenseModel(String licenseModel) {
        this.licenseModel = licenseModel;
    }

    public String getLicenseModel() {
        return this.licenseModel;
    }

    public OrderableDBInstanceOption withLicenseModel(String licenseModel) {
        this.setLicenseModel(licenseModel);
        return this;
    }

    public void setAvailabilityZoneGroup(String availabilityZoneGroup) {
        this.availabilityZoneGroup = availabilityZoneGroup;
    }

    public String getAvailabilityZoneGroup() {
        return this.availabilityZoneGroup;
    }

    public OrderableDBInstanceOption withAvailabilityZoneGroup(String availabilityZoneGroup) {
        this.setAvailabilityZoneGroup(availabilityZoneGroup);
        return this;
    }

    public List<AvailabilityZone> getAvailabilityZones() {
        if (this.availabilityZones == null) {
            this.availabilityZones = new SdkInternalList();
        }
        return this.availabilityZones;
    }

    public void setAvailabilityZones(Collection<AvailabilityZone> availabilityZones) {
        if (availabilityZones == null) {
            this.availabilityZones = null;
            return;
        }
        this.availabilityZones = new SdkInternalList(availabilityZones);
    }

    public OrderableDBInstanceOption withAvailabilityZones(AvailabilityZone ... availabilityZones) {
        if (this.availabilityZones == null) {
            this.setAvailabilityZones((Collection<AvailabilityZone>)new SdkInternalList(availabilityZones.length));
        }
        for (AvailabilityZone ele : availabilityZones) {
            this.availabilityZones.add((Object)ele);
        }
        return this;
    }

    public OrderableDBInstanceOption withAvailabilityZones(Collection<AvailabilityZone> availabilityZones) {
        this.setAvailabilityZones(availabilityZones);
        return this;
    }

    public void setMultiAZCapable(Boolean multiAZCapable) {
        this.multiAZCapable = multiAZCapable;
    }

    public Boolean getMultiAZCapable() {
        return this.multiAZCapable;
    }

    public OrderableDBInstanceOption withMultiAZCapable(Boolean multiAZCapable) {
        this.setMultiAZCapable(multiAZCapable);
        return this;
    }

    public Boolean isMultiAZCapable() {
        return this.multiAZCapable;
    }

    public void setReadReplicaCapable(Boolean readReplicaCapable) {
        this.readReplicaCapable = readReplicaCapable;
    }

    public Boolean getReadReplicaCapable() {
        return this.readReplicaCapable;
    }

    public OrderableDBInstanceOption withReadReplicaCapable(Boolean readReplicaCapable) {
        this.setReadReplicaCapable(readReplicaCapable);
        return this;
    }

    public Boolean isReadReplicaCapable() {
        return this.readReplicaCapable;
    }

    public void setVpc(Boolean vpc) {
        this.vpc = vpc;
    }

    public Boolean getVpc() {
        return this.vpc;
    }

    public OrderableDBInstanceOption withVpc(Boolean vpc) {
        this.setVpc(vpc);
        return this;
    }

    public Boolean isVpc() {
        return this.vpc;
    }

    public void setSupportsStorageEncryption(Boolean supportsStorageEncryption) {
        this.supportsStorageEncryption = supportsStorageEncryption;
    }

    public Boolean getSupportsStorageEncryption() {
        return this.supportsStorageEncryption;
    }

    public OrderableDBInstanceOption withSupportsStorageEncryption(Boolean supportsStorageEncryption) {
        this.setSupportsStorageEncryption(supportsStorageEncryption);
        return this;
    }

    public Boolean isSupportsStorageEncryption() {
        return this.supportsStorageEncryption;
    }

    public void setStorageType(String storageType) {
        this.storageType = storageType;
    }

    public String getStorageType() {
        return this.storageType;
    }

    public OrderableDBInstanceOption withStorageType(String storageType) {
        this.setStorageType(storageType);
        return this;
    }

    public void setSupportsIops(Boolean supportsIops) {
        this.supportsIops = supportsIops;
    }

    public Boolean getSupportsIops() {
        return this.supportsIops;
    }

    public OrderableDBInstanceOption withSupportsIops(Boolean supportsIops) {
        this.setSupportsIops(supportsIops);
        return this;
    }

    public Boolean isSupportsIops() {
        return this.supportsIops;
    }

    public void setSupportsEnhancedMonitoring(Boolean supportsEnhancedMonitoring) {
        this.supportsEnhancedMonitoring = supportsEnhancedMonitoring;
    }

    public Boolean getSupportsEnhancedMonitoring() {
        return this.supportsEnhancedMonitoring;
    }

    public OrderableDBInstanceOption withSupportsEnhancedMonitoring(Boolean supportsEnhancedMonitoring) {
        this.setSupportsEnhancedMonitoring(supportsEnhancedMonitoring);
        return this;
    }

    public Boolean isSupportsEnhancedMonitoring() {
        return this.supportsEnhancedMonitoring;
    }

    public void setSupportsIAMDatabaseAuthentication(Boolean supportsIAMDatabaseAuthentication) {
        this.supportsIAMDatabaseAuthentication = supportsIAMDatabaseAuthentication;
    }

    public Boolean getSupportsIAMDatabaseAuthentication() {
        return this.supportsIAMDatabaseAuthentication;
    }

    public OrderableDBInstanceOption withSupportsIAMDatabaseAuthentication(Boolean supportsIAMDatabaseAuthentication) {
        this.setSupportsIAMDatabaseAuthentication(supportsIAMDatabaseAuthentication);
        return this;
    }

    public Boolean isSupportsIAMDatabaseAuthentication() {
        return this.supportsIAMDatabaseAuthentication;
    }

    public void setSupportsPerformanceInsights(Boolean supportsPerformanceInsights) {
        this.supportsPerformanceInsights = supportsPerformanceInsights;
    }

    public Boolean getSupportsPerformanceInsights() {
        return this.supportsPerformanceInsights;
    }

    public OrderableDBInstanceOption withSupportsPerformanceInsights(Boolean supportsPerformanceInsights) {
        this.setSupportsPerformanceInsights(supportsPerformanceInsights);
        return this;
    }

    public Boolean isSupportsPerformanceInsights() {
        return this.supportsPerformanceInsights;
    }

    public void setMinStorageSize(Integer minStorageSize) {
        this.minStorageSize = minStorageSize;
    }

    public Integer getMinStorageSize() {
        return this.minStorageSize;
    }

    public OrderableDBInstanceOption withMinStorageSize(Integer minStorageSize) {
        this.setMinStorageSize(minStorageSize);
        return this;
    }

    public void setMaxStorageSize(Integer maxStorageSize) {
        this.maxStorageSize = maxStorageSize;
    }

    public Integer getMaxStorageSize() {
        return this.maxStorageSize;
    }

    public OrderableDBInstanceOption withMaxStorageSize(Integer maxStorageSize) {
        this.setMaxStorageSize(maxStorageSize);
        return this;
    }

    public void setMinIopsPerDbInstance(Integer minIopsPerDbInstance) {
        this.minIopsPerDbInstance = minIopsPerDbInstance;
    }

    public Integer getMinIopsPerDbInstance() {
        return this.minIopsPerDbInstance;
    }

    public OrderableDBInstanceOption withMinIopsPerDbInstance(Integer minIopsPerDbInstance) {
        this.setMinIopsPerDbInstance(minIopsPerDbInstance);
        return this;
    }

    public void setMaxIopsPerDbInstance(Integer maxIopsPerDbInstance) {
        this.maxIopsPerDbInstance = maxIopsPerDbInstance;
    }

    public Integer getMaxIopsPerDbInstance() {
        return this.maxIopsPerDbInstance;
    }

    public OrderableDBInstanceOption withMaxIopsPerDbInstance(Integer maxIopsPerDbInstance) {
        this.setMaxIopsPerDbInstance(maxIopsPerDbInstance);
        return this;
    }

    public void setMinIopsPerGib(Double minIopsPerGib) {
        this.minIopsPerGib = minIopsPerGib;
    }

    public Double getMinIopsPerGib() {
        return this.minIopsPerGib;
    }

    public OrderableDBInstanceOption withMinIopsPerGib(Double minIopsPerGib) {
        this.setMinIopsPerGib(minIopsPerGib);
        return this;
    }

    public void setMaxIopsPerGib(Double maxIopsPerGib) {
        this.maxIopsPerGib = maxIopsPerGib;
    }

    public Double getMaxIopsPerGib() {
        return this.maxIopsPerGib;
    }

    public OrderableDBInstanceOption withMaxIopsPerGib(Double maxIopsPerGib) {
        this.setMaxIopsPerGib(maxIopsPerGib);
        return this;
    }

    public List<AvailableProcessorFeature> getAvailableProcessorFeatures() {
        if (this.availableProcessorFeatures == null) {
            this.availableProcessorFeatures = new SdkInternalList();
        }
        return this.availableProcessorFeatures;
    }

    public void setAvailableProcessorFeatures(Collection<AvailableProcessorFeature> availableProcessorFeatures) {
        if (availableProcessorFeatures == null) {
            this.availableProcessorFeatures = null;
            return;
        }
        this.availableProcessorFeatures = new SdkInternalList(availableProcessorFeatures);
    }

    public OrderableDBInstanceOption withAvailableProcessorFeatures(AvailableProcessorFeature ... availableProcessorFeatures) {
        if (this.availableProcessorFeatures == null) {
            this.setAvailableProcessorFeatures((Collection<AvailableProcessorFeature>)new SdkInternalList(availableProcessorFeatures.length));
        }
        for (AvailableProcessorFeature ele : availableProcessorFeatures) {
            this.availableProcessorFeatures.add((Object)ele);
        }
        return this;
    }

    public OrderableDBInstanceOption withAvailableProcessorFeatures(Collection<AvailableProcessorFeature> availableProcessorFeatures) {
        this.setAvailableProcessorFeatures(availableProcessorFeatures);
        return this;
    }

    public List<String> getSupportedEngineModes() {
        if (this.supportedEngineModes == null) {
            this.supportedEngineModes = new SdkInternalList();
        }
        return this.supportedEngineModes;
    }

    public void setSupportedEngineModes(Collection<String> supportedEngineModes) {
        if (supportedEngineModes == null) {
            this.supportedEngineModes = null;
            return;
        }
        this.supportedEngineModes = new SdkInternalList(supportedEngineModes);
    }

    public OrderableDBInstanceOption withSupportedEngineModes(String ... supportedEngineModes) {
        if (this.supportedEngineModes == null) {
            this.setSupportedEngineModes((Collection<String>)new SdkInternalList(supportedEngineModes.length));
        }
        for (String ele : supportedEngineModes) {
            this.supportedEngineModes.add((Object)ele);
        }
        return this;
    }

    public OrderableDBInstanceOption withSupportedEngineModes(Collection<String> supportedEngineModes) {
        this.setSupportedEngineModes(supportedEngineModes);
        return this;
    }

    public void setSupportsStorageAutoscaling(Boolean supportsStorageAutoscaling) {
        this.supportsStorageAutoscaling = supportsStorageAutoscaling;
    }

    public Boolean getSupportsStorageAutoscaling() {
        return this.supportsStorageAutoscaling;
    }

    public OrderableDBInstanceOption withSupportsStorageAutoscaling(Boolean supportsStorageAutoscaling) {
        this.setSupportsStorageAutoscaling(supportsStorageAutoscaling);
        return this;
    }

    public Boolean isSupportsStorageAutoscaling() {
        return this.supportsStorageAutoscaling;
    }

    public void setSupportsKerberosAuthentication(Boolean supportsKerberosAuthentication) {
        this.supportsKerberosAuthentication = supportsKerberosAuthentication;
    }

    public Boolean getSupportsKerberosAuthentication() {
        return this.supportsKerberosAuthentication;
    }

    public OrderableDBInstanceOption withSupportsKerberosAuthentication(Boolean supportsKerberosAuthentication) {
        this.setSupportsKerberosAuthentication(supportsKerberosAuthentication);
        return this;
    }

    public Boolean isSupportsKerberosAuthentication() {
        return this.supportsKerberosAuthentication;
    }

    public void setOutpostCapable(Boolean outpostCapable) {
        this.outpostCapable = outpostCapable;
    }

    public Boolean getOutpostCapable() {
        return this.outpostCapable;
    }

    public OrderableDBInstanceOption withOutpostCapable(Boolean outpostCapable) {
        this.setOutpostCapable(outpostCapable);
        return this;
    }

    public Boolean isOutpostCapable() {
        return this.outpostCapable;
    }

    public List<String> getSupportedActivityStreamModes() {
        if (this.supportedActivityStreamModes == null) {
            this.supportedActivityStreamModes = new SdkInternalList();
        }
        return this.supportedActivityStreamModes;
    }

    public void setSupportedActivityStreamModes(Collection<String> supportedActivityStreamModes) {
        if (supportedActivityStreamModes == null) {
            this.supportedActivityStreamModes = null;
            return;
        }
        this.supportedActivityStreamModes = new SdkInternalList(supportedActivityStreamModes);
    }

    public OrderableDBInstanceOption withSupportedActivityStreamModes(String ... supportedActivityStreamModes) {
        if (this.supportedActivityStreamModes == null) {
            this.setSupportedActivityStreamModes((Collection<String>)new SdkInternalList(supportedActivityStreamModes.length));
        }
        for (String ele : supportedActivityStreamModes) {
            this.supportedActivityStreamModes.add((Object)ele);
        }
        return this;
    }

    public OrderableDBInstanceOption withSupportedActivityStreamModes(Collection<String> supportedActivityStreamModes) {
        this.setSupportedActivityStreamModes(supportedActivityStreamModes);
        return this;
    }

    public void setSupportsGlobalDatabases(Boolean supportsGlobalDatabases) {
        this.supportsGlobalDatabases = supportsGlobalDatabases;
    }

    public Boolean getSupportsGlobalDatabases() {
        return this.supportsGlobalDatabases;
    }

    public OrderableDBInstanceOption withSupportsGlobalDatabases(Boolean supportsGlobalDatabases) {
        this.setSupportsGlobalDatabases(supportsGlobalDatabases);
        return this;
    }

    public Boolean isSupportsGlobalDatabases() {
        return this.supportsGlobalDatabases;
    }

    public void setSupportsClusters(Boolean supportsClusters) {
        this.supportsClusters = supportsClusters;
    }

    public Boolean getSupportsClusters() {
        return this.supportsClusters;
    }

    public OrderableDBInstanceOption withSupportsClusters(Boolean supportsClusters) {
        this.setSupportsClusters(supportsClusters);
        return this;
    }

    public Boolean isSupportsClusters() {
        return this.supportsClusters;
    }

    public List<String> getSupportedNetworkTypes() {
        if (this.supportedNetworkTypes == null) {
            this.supportedNetworkTypes = new SdkInternalList();
        }
        return this.supportedNetworkTypes;
    }

    public void setSupportedNetworkTypes(Collection<String> supportedNetworkTypes) {
        if (supportedNetworkTypes == null) {
            this.supportedNetworkTypes = null;
            return;
        }
        this.supportedNetworkTypes = new SdkInternalList(supportedNetworkTypes);
    }

    public OrderableDBInstanceOption withSupportedNetworkTypes(String ... supportedNetworkTypes) {
        if (this.supportedNetworkTypes == null) {
            this.setSupportedNetworkTypes((Collection<String>)new SdkInternalList(supportedNetworkTypes.length));
        }
        for (String ele : supportedNetworkTypes) {
            this.supportedNetworkTypes.add((Object)ele);
        }
        return this;
    }

    public OrderableDBInstanceOption withSupportedNetworkTypes(Collection<String> supportedNetworkTypes) {
        this.setSupportedNetworkTypes(supportedNetworkTypes);
        return this;
    }

    public void setSupportsStorageThroughput(Boolean supportsStorageThroughput) {
        this.supportsStorageThroughput = supportsStorageThroughput;
    }

    public Boolean getSupportsStorageThroughput() {
        return this.supportsStorageThroughput;
    }

    public OrderableDBInstanceOption withSupportsStorageThroughput(Boolean supportsStorageThroughput) {
        this.setSupportsStorageThroughput(supportsStorageThroughput);
        return this;
    }

    public Boolean isSupportsStorageThroughput() {
        return this.supportsStorageThroughput;
    }

    public void setMinStorageThroughputPerDbInstance(Integer minStorageThroughputPerDbInstance) {
        this.minStorageThroughputPerDbInstance = minStorageThroughputPerDbInstance;
    }

    public Integer getMinStorageThroughputPerDbInstance() {
        return this.minStorageThroughputPerDbInstance;
    }

    public OrderableDBInstanceOption withMinStorageThroughputPerDbInstance(Integer minStorageThroughputPerDbInstance) {
        this.setMinStorageThroughputPerDbInstance(minStorageThroughputPerDbInstance);
        return this;
    }

    public void setMaxStorageThroughputPerDbInstance(Integer maxStorageThroughputPerDbInstance) {
        this.maxStorageThroughputPerDbInstance = maxStorageThroughputPerDbInstance;
    }

    public Integer getMaxStorageThroughputPerDbInstance() {
        return this.maxStorageThroughputPerDbInstance;
    }

    public OrderableDBInstanceOption withMaxStorageThroughputPerDbInstance(Integer maxStorageThroughputPerDbInstance) {
        this.setMaxStorageThroughputPerDbInstance(maxStorageThroughputPerDbInstance);
        return this;
    }

    public void setMinStorageThroughputPerIops(Double minStorageThroughputPerIops) {
        this.minStorageThroughputPerIops = minStorageThroughputPerIops;
    }

    public Double getMinStorageThroughputPerIops() {
        return this.minStorageThroughputPerIops;
    }

    public OrderableDBInstanceOption withMinStorageThroughputPerIops(Double minStorageThroughputPerIops) {
        this.setMinStorageThroughputPerIops(minStorageThroughputPerIops);
        return this;
    }

    public void setMaxStorageThroughputPerIops(Double maxStorageThroughputPerIops) {
        this.maxStorageThroughputPerIops = maxStorageThroughputPerIops;
    }

    public Double getMaxStorageThroughputPerIops() {
        return this.maxStorageThroughputPerIops;
    }

    public OrderableDBInstanceOption withMaxStorageThroughputPerIops(Double maxStorageThroughputPerIops) {
        this.setMaxStorageThroughputPerIops(maxStorageThroughputPerIops);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEngine() != null) {
            sb.append("Engine: ").append(this.getEngine()).append(",");
        }
        if (this.getEngineVersion() != null) {
            sb.append("EngineVersion: ").append(this.getEngineVersion()).append(",");
        }
        if (this.getDBInstanceClass() != null) {
            sb.append("DBInstanceClass: ").append(this.getDBInstanceClass()).append(",");
        }
        if (this.getLicenseModel() != null) {
            sb.append("LicenseModel: ").append(this.getLicenseModel()).append(",");
        }
        if (this.getAvailabilityZoneGroup() != null) {
            sb.append("AvailabilityZoneGroup: ").append(this.getAvailabilityZoneGroup()).append(",");
        }
        if (this.getAvailabilityZones() != null) {
            sb.append("AvailabilityZones: ").append(this.getAvailabilityZones()).append(",");
        }
        if (this.getMultiAZCapable() != null) {
            sb.append("MultiAZCapable: ").append(this.getMultiAZCapable()).append(",");
        }
        if (this.getReadReplicaCapable() != null) {
            sb.append("ReadReplicaCapable: ").append(this.getReadReplicaCapable()).append(",");
        }
        if (this.getVpc() != null) {
            sb.append("Vpc: ").append(this.getVpc()).append(",");
        }
        if (this.getSupportsStorageEncryption() != null) {
            sb.append("SupportsStorageEncryption: ").append(this.getSupportsStorageEncryption()).append(",");
        }
        if (this.getStorageType() != null) {
            sb.append("StorageType: ").append(this.getStorageType()).append(",");
        }
        if (this.getSupportsIops() != null) {
            sb.append("SupportsIops: ").append(this.getSupportsIops()).append(",");
        }
        if (this.getSupportsEnhancedMonitoring() != null) {
            sb.append("SupportsEnhancedMonitoring: ").append(this.getSupportsEnhancedMonitoring()).append(",");
        }
        if (this.getSupportsIAMDatabaseAuthentication() != null) {
            sb.append("SupportsIAMDatabaseAuthentication: ").append(this.getSupportsIAMDatabaseAuthentication()).append(",");
        }
        if (this.getSupportsPerformanceInsights() != null) {
            sb.append("SupportsPerformanceInsights: ").append(this.getSupportsPerformanceInsights()).append(",");
        }
        if (this.getMinStorageSize() != null) {
            sb.append("MinStorageSize: ").append(this.getMinStorageSize()).append(",");
        }
        if (this.getMaxStorageSize() != null) {
            sb.append("MaxStorageSize: ").append(this.getMaxStorageSize()).append(",");
        }
        if (this.getMinIopsPerDbInstance() != null) {
            sb.append("MinIopsPerDbInstance: ").append(this.getMinIopsPerDbInstance()).append(",");
        }
        if (this.getMaxIopsPerDbInstance() != null) {
            sb.append("MaxIopsPerDbInstance: ").append(this.getMaxIopsPerDbInstance()).append(",");
        }
        if (this.getMinIopsPerGib() != null) {
            sb.append("MinIopsPerGib: ").append(this.getMinIopsPerGib()).append(",");
        }
        if (this.getMaxIopsPerGib() != null) {
            sb.append("MaxIopsPerGib: ").append(this.getMaxIopsPerGib()).append(",");
        }
        if (this.getAvailableProcessorFeatures() != null) {
            sb.append("AvailableProcessorFeatures: ").append(this.getAvailableProcessorFeatures()).append(",");
        }
        if (this.getSupportedEngineModes() != null) {
            sb.append("SupportedEngineModes: ").append(this.getSupportedEngineModes()).append(",");
        }
        if (this.getSupportsStorageAutoscaling() != null) {
            sb.append("SupportsStorageAutoscaling: ").append(this.getSupportsStorageAutoscaling()).append(",");
        }
        if (this.getSupportsKerberosAuthentication() != null) {
            sb.append("SupportsKerberosAuthentication: ").append(this.getSupportsKerberosAuthentication()).append(",");
        }
        if (this.getOutpostCapable() != null) {
            sb.append("OutpostCapable: ").append(this.getOutpostCapable()).append(",");
        }
        if (this.getSupportedActivityStreamModes() != null) {
            sb.append("SupportedActivityStreamModes: ").append(this.getSupportedActivityStreamModes()).append(",");
        }
        if (this.getSupportsGlobalDatabases() != null) {
            sb.append("SupportsGlobalDatabases: ").append(this.getSupportsGlobalDatabases()).append(",");
        }
        if (this.getSupportsClusters() != null) {
            sb.append("SupportsClusters: ").append(this.getSupportsClusters()).append(",");
        }
        if (this.getSupportedNetworkTypes() != null) {
            sb.append("SupportedNetworkTypes: ").append(this.getSupportedNetworkTypes()).append(",");
        }
        if (this.getSupportsStorageThroughput() != null) {
            sb.append("SupportsStorageThroughput: ").append(this.getSupportsStorageThroughput()).append(",");
        }
        if (this.getMinStorageThroughputPerDbInstance() != null) {
            sb.append("MinStorageThroughputPerDbInstance: ").append(this.getMinStorageThroughputPerDbInstance()).append(",");
        }
        if (this.getMaxStorageThroughputPerDbInstance() != null) {
            sb.append("MaxStorageThroughputPerDbInstance: ").append(this.getMaxStorageThroughputPerDbInstance()).append(",");
        }
        if (this.getMinStorageThroughputPerIops() != null) {
            sb.append("MinStorageThroughputPerIops: ").append(this.getMinStorageThroughputPerIops()).append(",");
        }
        if (this.getMaxStorageThroughputPerIops() != null) {
            sb.append("MaxStorageThroughputPerIops: ").append(this.getMaxStorageThroughputPerIops());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OrderableDBInstanceOption)) {
            return false;
        }
        OrderableDBInstanceOption other = (OrderableDBInstanceOption)obj;
        if (other.getEngine() == null ^ this.getEngine() == null) {
            return false;
        }
        if (other.getEngine() != null && !other.getEngine().equals(this.getEngine())) {
            return false;
        }
        if (other.getEngineVersion() == null ^ this.getEngineVersion() == null) {
            return false;
        }
        if (other.getEngineVersion() != null && !other.getEngineVersion().equals(this.getEngineVersion())) {
            return false;
        }
        if (other.getDBInstanceClass() == null ^ this.getDBInstanceClass() == null) {
            return false;
        }
        if (other.getDBInstanceClass() != null && !other.getDBInstanceClass().equals(this.getDBInstanceClass())) {
            return false;
        }
        if (other.getLicenseModel() == null ^ this.getLicenseModel() == null) {
            return false;
        }
        if (other.getLicenseModel() != null && !other.getLicenseModel().equals(this.getLicenseModel())) {
            return false;
        }
        if (other.getAvailabilityZoneGroup() == null ^ this.getAvailabilityZoneGroup() == null) {
            return false;
        }
        if (other.getAvailabilityZoneGroup() != null && !other.getAvailabilityZoneGroup().equals(this.getAvailabilityZoneGroup())) {
            return false;
        }
        if (other.getAvailabilityZones() == null ^ this.getAvailabilityZones() == null) {
            return false;
        }
        if (other.getAvailabilityZones() != null && !other.getAvailabilityZones().equals(this.getAvailabilityZones())) {
            return false;
        }
        if (other.getMultiAZCapable() == null ^ this.getMultiAZCapable() == null) {
            return false;
        }
        if (other.getMultiAZCapable() != null && !other.getMultiAZCapable().equals(this.getMultiAZCapable())) {
            return false;
        }
        if (other.getReadReplicaCapable() == null ^ this.getReadReplicaCapable() == null) {
            return false;
        }
        if (other.getReadReplicaCapable() != null && !other.getReadReplicaCapable().equals(this.getReadReplicaCapable())) {
            return false;
        }
        if (other.getVpc() == null ^ this.getVpc() == null) {
            return false;
        }
        if (other.getVpc() != null && !other.getVpc().equals(this.getVpc())) {
            return false;
        }
        if (other.getSupportsStorageEncryption() == null ^ this.getSupportsStorageEncryption() == null) {
            return false;
        }
        if (other.getSupportsStorageEncryption() != null && !other.getSupportsStorageEncryption().equals(this.getSupportsStorageEncryption())) {
            return false;
        }
        if (other.getStorageType() == null ^ this.getStorageType() == null) {
            return false;
        }
        if (other.getStorageType() != null && !other.getStorageType().equals(this.getStorageType())) {
            return false;
        }
        if (other.getSupportsIops() == null ^ this.getSupportsIops() == null) {
            return false;
        }
        if (other.getSupportsIops() != null && !other.getSupportsIops().equals(this.getSupportsIops())) {
            return false;
        }
        if (other.getSupportsEnhancedMonitoring() == null ^ this.getSupportsEnhancedMonitoring() == null) {
            return false;
        }
        if (other.getSupportsEnhancedMonitoring() != null && !other.getSupportsEnhancedMonitoring().equals(this.getSupportsEnhancedMonitoring())) {
            return false;
        }
        if (other.getSupportsIAMDatabaseAuthentication() == null ^ this.getSupportsIAMDatabaseAuthentication() == null) {
            return false;
        }
        if (other.getSupportsIAMDatabaseAuthentication() != null && !other.getSupportsIAMDatabaseAuthentication().equals(this.getSupportsIAMDatabaseAuthentication())) {
            return false;
        }
        if (other.getSupportsPerformanceInsights() == null ^ this.getSupportsPerformanceInsights() == null) {
            return false;
        }
        if (other.getSupportsPerformanceInsights() != null && !other.getSupportsPerformanceInsights().equals(this.getSupportsPerformanceInsights())) {
            return false;
        }
        if (other.getMinStorageSize() == null ^ this.getMinStorageSize() == null) {
            return false;
        }
        if (other.getMinStorageSize() != null && !other.getMinStorageSize().equals(this.getMinStorageSize())) {
            return false;
        }
        if (other.getMaxStorageSize() == null ^ this.getMaxStorageSize() == null) {
            return false;
        }
        if (other.getMaxStorageSize() != null && !other.getMaxStorageSize().equals(this.getMaxStorageSize())) {
            return false;
        }
        if (other.getMinIopsPerDbInstance() == null ^ this.getMinIopsPerDbInstance() == null) {
            return false;
        }
        if (other.getMinIopsPerDbInstance() != null && !other.getMinIopsPerDbInstance().equals(this.getMinIopsPerDbInstance())) {
            return false;
        }
        if (other.getMaxIopsPerDbInstance() == null ^ this.getMaxIopsPerDbInstance() == null) {
            return false;
        }
        if (other.getMaxIopsPerDbInstance() != null && !other.getMaxIopsPerDbInstance().equals(this.getMaxIopsPerDbInstance())) {
            return false;
        }
        if (other.getMinIopsPerGib() == null ^ this.getMinIopsPerGib() == null) {
            return false;
        }
        if (other.getMinIopsPerGib() != null && !other.getMinIopsPerGib().equals(this.getMinIopsPerGib())) {
            return false;
        }
        if (other.getMaxIopsPerGib() == null ^ this.getMaxIopsPerGib() == null) {
            return false;
        }
        if (other.getMaxIopsPerGib() != null && !other.getMaxIopsPerGib().equals(this.getMaxIopsPerGib())) {
            return false;
        }
        if (other.getAvailableProcessorFeatures() == null ^ this.getAvailableProcessorFeatures() == null) {
            return false;
        }
        if (other.getAvailableProcessorFeatures() != null && !other.getAvailableProcessorFeatures().equals(this.getAvailableProcessorFeatures())) {
            return false;
        }
        if (other.getSupportedEngineModes() == null ^ this.getSupportedEngineModes() == null) {
            return false;
        }
        if (other.getSupportedEngineModes() != null && !other.getSupportedEngineModes().equals(this.getSupportedEngineModes())) {
            return false;
        }
        if (other.getSupportsStorageAutoscaling() == null ^ this.getSupportsStorageAutoscaling() == null) {
            return false;
        }
        if (other.getSupportsStorageAutoscaling() != null && !other.getSupportsStorageAutoscaling().equals(this.getSupportsStorageAutoscaling())) {
            return false;
        }
        if (other.getSupportsKerberosAuthentication() == null ^ this.getSupportsKerberosAuthentication() == null) {
            return false;
        }
        if (other.getSupportsKerberosAuthentication() != null && !other.getSupportsKerberosAuthentication().equals(this.getSupportsKerberosAuthentication())) {
            return false;
        }
        if (other.getOutpostCapable() == null ^ this.getOutpostCapable() == null) {
            return false;
        }
        if (other.getOutpostCapable() != null && !other.getOutpostCapable().equals(this.getOutpostCapable())) {
            return false;
        }
        if (other.getSupportedActivityStreamModes() == null ^ this.getSupportedActivityStreamModes() == null) {
            return false;
        }
        if (other.getSupportedActivityStreamModes() != null && !other.getSupportedActivityStreamModes().equals(this.getSupportedActivityStreamModes())) {
            return false;
        }
        if (other.getSupportsGlobalDatabases() == null ^ this.getSupportsGlobalDatabases() == null) {
            return false;
        }
        if (other.getSupportsGlobalDatabases() != null && !other.getSupportsGlobalDatabases().equals(this.getSupportsGlobalDatabases())) {
            return false;
        }
        if (other.getSupportsClusters() == null ^ this.getSupportsClusters() == null) {
            return false;
        }
        if (other.getSupportsClusters() != null && !other.getSupportsClusters().equals(this.getSupportsClusters())) {
            return false;
        }
        if (other.getSupportedNetworkTypes() == null ^ this.getSupportedNetworkTypes() == null) {
            return false;
        }
        if (other.getSupportedNetworkTypes() != null && !other.getSupportedNetworkTypes().equals(this.getSupportedNetworkTypes())) {
            return false;
        }
        if (other.getSupportsStorageThroughput() == null ^ this.getSupportsStorageThroughput() == null) {
            return false;
        }
        if (other.getSupportsStorageThroughput() != null && !other.getSupportsStorageThroughput().equals(this.getSupportsStorageThroughput())) {
            return false;
        }
        if (other.getMinStorageThroughputPerDbInstance() == null ^ this.getMinStorageThroughputPerDbInstance() == null) {
            return false;
        }
        if (other.getMinStorageThroughputPerDbInstance() != null && !other.getMinStorageThroughputPerDbInstance().equals(this.getMinStorageThroughputPerDbInstance())) {
            return false;
        }
        if (other.getMaxStorageThroughputPerDbInstance() == null ^ this.getMaxStorageThroughputPerDbInstance() == null) {
            return false;
        }
        if (other.getMaxStorageThroughputPerDbInstance() != null && !other.getMaxStorageThroughputPerDbInstance().equals(this.getMaxStorageThroughputPerDbInstance())) {
            return false;
        }
        if (other.getMinStorageThroughputPerIops() == null ^ this.getMinStorageThroughputPerIops() == null) {
            return false;
        }
        if (other.getMinStorageThroughputPerIops() != null && !other.getMinStorageThroughputPerIops().equals(this.getMinStorageThroughputPerIops())) {
            return false;
        }
        if (other.getMaxStorageThroughputPerIops() == null ^ this.getMaxStorageThroughputPerIops() == null) {
            return false;
        }
        return other.getMaxStorageThroughputPerIops() == null || other.getMaxStorageThroughputPerIops().equals(this.getMaxStorageThroughputPerIops());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEngine() == null ? 0 : this.getEngine().hashCode());
        hashCode = 31 * hashCode + (this.getEngineVersion() == null ? 0 : this.getEngineVersion().hashCode());
        hashCode = 31 * hashCode + (this.getDBInstanceClass() == null ? 0 : this.getDBInstanceClass().hashCode());
        hashCode = 31 * hashCode + (this.getLicenseModel() == null ? 0 : this.getLicenseModel().hashCode());
        hashCode = 31 * hashCode + (this.getAvailabilityZoneGroup() == null ? 0 : this.getAvailabilityZoneGroup().hashCode());
        hashCode = 31 * hashCode + (this.getAvailabilityZones() == null ? 0 : this.getAvailabilityZones().hashCode());
        hashCode = 31 * hashCode + (this.getMultiAZCapable() == null ? 0 : this.getMultiAZCapable().hashCode());
        hashCode = 31 * hashCode + (this.getReadReplicaCapable() == null ? 0 : this.getReadReplicaCapable().hashCode());
        hashCode = 31 * hashCode + (this.getVpc() == null ? 0 : this.getVpc().hashCode());
        hashCode = 31 * hashCode + (this.getSupportsStorageEncryption() == null ? 0 : this.getSupportsStorageEncryption().hashCode());
        hashCode = 31 * hashCode + (this.getStorageType() == null ? 0 : this.getStorageType().hashCode());
        hashCode = 31 * hashCode + (this.getSupportsIops() == null ? 0 : this.getSupportsIops().hashCode());
        hashCode = 31 * hashCode + (this.getSupportsEnhancedMonitoring() == null ? 0 : this.getSupportsEnhancedMonitoring().hashCode());
        hashCode = 31 * hashCode + (this.getSupportsIAMDatabaseAuthentication() == null ? 0 : this.getSupportsIAMDatabaseAuthentication().hashCode());
        hashCode = 31 * hashCode + (this.getSupportsPerformanceInsights() == null ? 0 : this.getSupportsPerformanceInsights().hashCode());
        hashCode = 31 * hashCode + (this.getMinStorageSize() == null ? 0 : this.getMinStorageSize().hashCode());
        hashCode = 31 * hashCode + (this.getMaxStorageSize() == null ? 0 : this.getMaxStorageSize().hashCode());
        hashCode = 31 * hashCode + (this.getMinIopsPerDbInstance() == null ? 0 : this.getMinIopsPerDbInstance().hashCode());
        hashCode = 31 * hashCode + (this.getMaxIopsPerDbInstance() == null ? 0 : this.getMaxIopsPerDbInstance().hashCode());
        hashCode = 31 * hashCode + (this.getMinIopsPerGib() == null ? 0 : this.getMinIopsPerGib().hashCode());
        hashCode = 31 * hashCode + (this.getMaxIopsPerGib() == null ? 0 : this.getMaxIopsPerGib().hashCode());
        hashCode = 31 * hashCode + (this.getAvailableProcessorFeatures() == null ? 0 : this.getAvailableProcessorFeatures().hashCode());
        hashCode = 31 * hashCode + (this.getSupportedEngineModes() == null ? 0 : this.getSupportedEngineModes().hashCode());
        hashCode = 31 * hashCode + (this.getSupportsStorageAutoscaling() == null ? 0 : this.getSupportsStorageAutoscaling().hashCode());
        hashCode = 31 * hashCode + (this.getSupportsKerberosAuthentication() == null ? 0 : this.getSupportsKerberosAuthentication().hashCode());
        hashCode = 31 * hashCode + (this.getOutpostCapable() == null ? 0 : this.getOutpostCapable().hashCode());
        hashCode = 31 * hashCode + (this.getSupportedActivityStreamModes() == null ? 0 : this.getSupportedActivityStreamModes().hashCode());
        hashCode = 31 * hashCode + (this.getSupportsGlobalDatabases() == null ? 0 : this.getSupportsGlobalDatabases().hashCode());
        hashCode = 31 * hashCode + (this.getSupportsClusters() == null ? 0 : this.getSupportsClusters().hashCode());
        hashCode = 31 * hashCode + (this.getSupportedNetworkTypes() == null ? 0 : this.getSupportedNetworkTypes().hashCode());
        hashCode = 31 * hashCode + (this.getSupportsStorageThroughput() == null ? 0 : this.getSupportsStorageThroughput().hashCode());
        hashCode = 31 * hashCode + (this.getMinStorageThroughputPerDbInstance() == null ? 0 : this.getMinStorageThroughputPerDbInstance().hashCode());
        hashCode = 31 * hashCode + (this.getMaxStorageThroughputPerDbInstance() == null ? 0 : this.getMaxStorageThroughputPerDbInstance().hashCode());
        hashCode = 31 * hashCode + (this.getMinStorageThroughputPerIops() == null ? 0 : this.getMinStorageThroughputPerIops().hashCode());
        hashCode = 31 * hashCode + (this.getMaxStorageThroughputPerIops() == null ? 0 : this.getMaxStorageThroughputPerIops().hashCode());
        return hashCode;
    }

    public OrderableDBInstanceOption clone() {
        try {
            return (OrderableDBInstanceOption)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

