/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.rds.model.DescribeDBProxyTargetGroupsRequest;
import com.amazonaws.services.rds.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeDBProxyTargetGroupsRequestMarshaller
implements Marshaller<Request<DescribeDBProxyTargetGroupsRequest>, DescribeDBProxyTargetGroupsRequest> {
    public Request<DescribeDBProxyTargetGroupsRequest> marshall(DescribeDBProxyTargetGroupsRequest describeDBProxyTargetGroupsRequest) {
        if (describeDBProxyTargetGroupsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeDBProxyTargetGroupsRequest, "AmazonRDS");
        request.addParameter("Action", "DescribeDBProxyTargetGroups");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeDBProxyTargetGroupsRequest.getDBProxyName() != null) {
            request.addParameter("DBProxyName", StringUtils.fromString((String)describeDBProxyTargetGroupsRequest.getDBProxyName()));
        }
        if (describeDBProxyTargetGroupsRequest.getTargetGroupName() != null) {
            request.addParameter("TargetGroupName", StringUtils.fromString((String)describeDBProxyTargetGroupsRequest.getTargetGroupName()));
        }
        if (!describeDBProxyTargetGroupsRequest.getFilters().isEmpty() || !((SdkInternalList)describeDBProxyTargetGroupsRequest.getFilters()).isAutoConstruct()) {
            SdkInternalList filtersList = (SdkInternalList)describeDBProxyTargetGroupsRequest.getFilters();
            int filtersListIndex = 1;
            for (Filter filtersListValue : filtersList) {
                if (filtersListValue.getName() != null) {
                    request.addParameter("Filters.Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)filtersListValue.getName()));
                }
                if (!filtersListValue.getValues().isEmpty() || !((SdkInternalList)filtersListValue.getValues()).isAutoConstruct()) {
                    SdkInternalList valuesList = (SdkInternalList)filtersListValue.getValues();
                    int valuesListIndex = 1;
                    for (String valuesListValue : valuesList) {
                        if (valuesListValue != null) {
                            request.addParameter("Filters.Filter." + filtersListIndex + ".Values.Value." + valuesListIndex, StringUtils.fromString((String)valuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeDBProxyTargetGroupsRequest.getMarker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)describeDBProxyTargetGroupsRequest.getMarker()));
        }
        if (describeDBProxyTargetGroupsRequest.getMaxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describeDBProxyTargetGroupsRequest.getMaxRecords()));
        }
        return request;
    }
}

