/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.quicksight.model.TopicConstantValue;
import java.util.List;

@SdkInternalApi
public class TopicConstantValueMarshaller {
    private static final MarshallingInfo<String> CONSTANTTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConstantType").build();
    private static final MarshallingInfo<String> VALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Value").build();
    private static final MarshallingInfo<String> MINIMUM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Minimum").build();
    private static final MarshallingInfo<String> MAXIMUM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Maximum").build();
    private static final MarshallingInfo<List> VALUELIST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ValueList").build();
    private static final TopicConstantValueMarshaller instance = new TopicConstantValueMarshaller();

    public static TopicConstantValueMarshaller getInstance() {
        return instance;
    }

    public void marshall(TopicConstantValue topicConstantValue, ProtocolMarshaller protocolMarshaller) {
        if (topicConstantValue == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)topicConstantValue.getConstantType(), CONSTANTTYPE_BINDING);
            protocolMarshaller.marshall((Object)topicConstantValue.getValue(), VALUE_BINDING);
            protocolMarshaller.marshall((Object)topicConstantValue.getMinimum(), MINIMUM_BINDING);
            protocolMarshaller.marshall((Object)topicConstantValue.getMaximum(), MAXIMUM_BINDING);
            protocolMarshaller.marshall(topicConstantValue.getValueList(), VALUELIST_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

