/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.quicksight.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * The options that determine the thousands separator configuration.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ThousandSeparatorOptions"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ThousandSeparatorOptions implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * Determines the thousands separator symbol.
     * </p>
     */
    private String symbol;
    /**
     * <p>
     * Determines the visibility of the thousands separator.
     * </p>
     */
    private String visibility;

    /**
     * <p>
     * Determines the thousands separator symbol.
     * </p>
     * 
     * @param symbol
     *        Determines the thousands separator symbol.
     * @see NumericSeparatorSymbol
     */

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    /**
     * <p>
     * Determines the thousands separator symbol.
     * </p>
     * 
     * @return Determines the thousands separator symbol.
     * @see NumericSeparatorSymbol
     */

    public String getSymbol() {
        return this.symbol;
    }

    /**
     * <p>
     * Determines the thousands separator symbol.
     * </p>
     * 
     * @param symbol
     *        Determines the thousands separator symbol.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see NumericSeparatorSymbol
     */

    public ThousandSeparatorOptions withSymbol(String symbol) {
        setSymbol(symbol);
        return this;
    }

    /**
     * <p>
     * Determines the thousands separator symbol.
     * </p>
     * 
     * @param symbol
     *        Determines the thousands separator symbol.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see NumericSeparatorSymbol
     */

    public ThousandSeparatorOptions withSymbol(NumericSeparatorSymbol symbol) {
        this.symbol = symbol.toString();
        return this;
    }

    /**
     * <p>
     * Determines the visibility of the thousands separator.
     * </p>
     * 
     * @param visibility
     *        Determines the visibility of the thousands separator.
     * @see Visibility
     */

    public void setVisibility(String visibility) {
        this.visibility = visibility;
    }

    /**
     * <p>
     * Determines the visibility of the thousands separator.
     * </p>
     * 
     * @return Determines the visibility of the thousands separator.
     * @see Visibility
     */

    public String getVisibility() {
        return this.visibility;
    }

    /**
     * <p>
     * Determines the visibility of the thousands separator.
     * </p>
     * 
     * @param visibility
     *        Determines the visibility of the thousands separator.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see Visibility
     */

    public ThousandSeparatorOptions withVisibility(String visibility) {
        setVisibility(visibility);
        return this;
    }

    /**
     * <p>
     * Determines the visibility of the thousands separator.
     * </p>
     * 
     * @param visibility
     *        Determines the visibility of the thousands separator.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see Visibility
     */

    public ThousandSeparatorOptions withVisibility(Visibility visibility) {
        this.visibility = visibility.toString();
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getSymbol() != null)
            sb.append("Symbol: ").append(getSymbol()).append(",");
        if (getVisibility() != null)
            sb.append("Visibility: ").append(getVisibility());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ThousandSeparatorOptions == false)
            return false;
        ThousandSeparatorOptions other = (ThousandSeparatorOptions) obj;
        if (other.getSymbol() == null ^ this.getSymbol() == null)
            return false;
        if (other.getSymbol() != null && other.getSymbol().equals(this.getSymbol()) == false)
            return false;
        if (other.getVisibility() == null ^ this.getVisibility() == null)
            return false;
        if (other.getVisibility() != null && other.getVisibility().equals(this.getVisibility()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getSymbol() == null) ? 0 : getSymbol().hashCode());
        hashCode = prime * hashCode + ((getVisibility() == null) ? 0 : getVisibility().hashCode());
        return hashCode;
    }

    @Override
    public ThousandSeparatorOptions clone() {
        try {
            return (ThousandSeparatorOptions) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.quicksight.model.transform.ThousandSeparatorOptionsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
