/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.quicksight.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * The scope configuration for a <code>FilterGroup</code>.
 * </p>
 * <p>
 * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/FilterScopeConfiguration"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class FilterScopeConfiguration implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The configuration for applying a filter to specific sheets.
     * </p>
     */
    private SelectedSheetsFilterScopeConfiguration selectedSheets;
    /**
     * <p>
     * The configuration that applies a filter to all sheets. When you choose <code>AllSheets</code> as the value for a
     * <code>FilterScopeConfiguration</code>, this filter is applied to all visuals of all sheets in an Analysis,
     * Dashboard, or Template. The <code>AllSheetsFilterScopeConfiguration</code> is chosen.
     * </p>
     */
    private AllSheetsFilterScopeConfiguration allSheets;

    /**
     * <p>
     * The configuration for applying a filter to specific sheets.
     * </p>
     * 
     * @param selectedSheets
     *        The configuration for applying a filter to specific sheets.
     */

    public void setSelectedSheets(SelectedSheetsFilterScopeConfiguration selectedSheets) {
        this.selectedSheets = selectedSheets;
    }

    /**
     * <p>
     * The configuration for applying a filter to specific sheets.
     * </p>
     * 
     * @return The configuration for applying a filter to specific sheets.
     */

    public SelectedSheetsFilterScopeConfiguration getSelectedSheets() {
        return this.selectedSheets;
    }

    /**
     * <p>
     * The configuration for applying a filter to specific sheets.
     * </p>
     * 
     * @param selectedSheets
     *        The configuration for applying a filter to specific sheets.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public FilterScopeConfiguration withSelectedSheets(SelectedSheetsFilterScopeConfiguration selectedSheets) {
        setSelectedSheets(selectedSheets);
        return this;
    }

    /**
     * <p>
     * The configuration that applies a filter to all sheets. When you choose <code>AllSheets</code> as the value for a
     * <code>FilterScopeConfiguration</code>, this filter is applied to all visuals of all sheets in an Analysis,
     * Dashboard, or Template. The <code>AllSheetsFilterScopeConfiguration</code> is chosen.
     * </p>
     * 
     * @param allSheets
     *        The configuration that applies a filter to all sheets. When you choose <code>AllSheets</code> as the value
     *        for a <code>FilterScopeConfiguration</code>, this filter is applied to all visuals of all sheets in an
     *        Analysis, Dashboard, or Template. The <code>AllSheetsFilterScopeConfiguration</code> is chosen.
     */

    public void setAllSheets(AllSheetsFilterScopeConfiguration allSheets) {
        this.allSheets = allSheets;
    }

    /**
     * <p>
     * The configuration that applies a filter to all sheets. When you choose <code>AllSheets</code> as the value for a
     * <code>FilterScopeConfiguration</code>, this filter is applied to all visuals of all sheets in an Analysis,
     * Dashboard, or Template. The <code>AllSheetsFilterScopeConfiguration</code> is chosen.
     * </p>
     * 
     * @return The configuration that applies a filter to all sheets. When you choose <code>AllSheets</code> as the
     *         value for a <code>FilterScopeConfiguration</code>, this filter is applied to all visuals of all sheets in
     *         an Analysis, Dashboard, or Template. The <code>AllSheetsFilterScopeConfiguration</code> is chosen.
     */

    public AllSheetsFilterScopeConfiguration getAllSheets() {
        return this.allSheets;
    }

    /**
     * <p>
     * The configuration that applies a filter to all sheets. When you choose <code>AllSheets</code> as the value for a
     * <code>FilterScopeConfiguration</code>, this filter is applied to all visuals of all sheets in an Analysis,
     * Dashboard, or Template. The <code>AllSheetsFilterScopeConfiguration</code> is chosen.
     * </p>
     * 
     * @param allSheets
     *        The configuration that applies a filter to all sheets. When you choose <code>AllSheets</code> as the value
     *        for a <code>FilterScopeConfiguration</code>, this filter is applied to all visuals of all sheets in an
     *        Analysis, Dashboard, or Template. The <code>AllSheetsFilterScopeConfiguration</code> is chosen.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public FilterScopeConfiguration withAllSheets(AllSheetsFilterScopeConfiguration allSheets) {
        setAllSheets(allSheets);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getSelectedSheets() != null)
            sb.append("SelectedSheets: ").append(getSelectedSheets()).append(",");
        if (getAllSheets() != null)
            sb.append("AllSheets: ").append(getAllSheets());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof FilterScopeConfiguration == false)
            return false;
        FilterScopeConfiguration other = (FilterScopeConfiguration) obj;
        if (other.getSelectedSheets() == null ^ this.getSelectedSheets() == null)
            return false;
        if (other.getSelectedSheets() != null && other.getSelectedSheets().equals(this.getSelectedSheets()) == false)
            return false;
        if (other.getAllSheets() == null ^ this.getAllSheets() == null)
            return false;
        if (other.getAllSheets() != null && other.getAllSheets().equals(this.getAllSheets()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getSelectedSheets() == null) ? 0 : getSelectedSheets().hashCode());
        hashCode = prime * hashCode + ((getAllSheets() == null) ? 0 : getAllSheets().hashCode());
        return hashCode;
    }

    @Override
    public FilterScopeConfiguration clone() {
        try {
            return (FilterScopeConfiguration) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.quicksight.model.transform.FilterScopeConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
