/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.quicksight.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/BatchCreateTopicReviewedAnswer"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class BatchCreateTopicReviewedAnswerResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable,
        Cloneable {

    /**
     * <p>
     * The ID for the topic reviewed answer that you want to create. This ID is unique per Amazon Web Services Region
     * for each Amazon Web Services account.
     * </p>
     */
    private String topicId;
    /**
     * <p>
     * The Amazon Resource Name (ARN) of the topic.
     * </p>
     */
    private String topicArn;
    /**
     * <p>
     * The definition of Answers that are successfully created.
     * </p>
     */
    private java.util.List<SucceededTopicReviewedAnswer> succeededAnswers;
    /**
     * <p>
     * The definition of Answers that are invalid and not created.
     * </p>
     */
    private java.util.List<InvalidTopicReviewedAnswer> invalidAnswers;
    /**
     * <p>
     * The HTTP status of the request.
     * </p>
     */
    private Integer status;
    /**
     * <p>
     * The Amazon Web Services request ID for this operation.
     * </p>
     */
    private String requestId;

    /**
     * <p>
     * The ID for the topic reviewed answer that you want to create. This ID is unique per Amazon Web Services Region
     * for each Amazon Web Services account.
     * </p>
     * 
     * @param topicId
     *        The ID for the topic reviewed answer that you want to create. This ID is unique per Amazon Web Services
     *        Region for each Amazon Web Services account.
     */

    public void setTopicId(String topicId) {
        this.topicId = topicId;
    }

    /**
     * <p>
     * The ID for the topic reviewed answer that you want to create. This ID is unique per Amazon Web Services Region
     * for each Amazon Web Services account.
     * </p>
     * 
     * @return The ID for the topic reviewed answer that you want to create. This ID is unique per Amazon Web Services
     *         Region for each Amazon Web Services account.
     */

    public String getTopicId() {
        return this.topicId;
    }

    /**
     * <p>
     * The ID for the topic reviewed answer that you want to create. This ID is unique per Amazon Web Services Region
     * for each Amazon Web Services account.
     * </p>
     * 
     * @param topicId
     *        The ID for the topic reviewed answer that you want to create. This ID is unique per Amazon Web Services
     *        Region for each Amazon Web Services account.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public BatchCreateTopicReviewedAnswerResult withTopicId(String topicId) {
        setTopicId(topicId);
        return this;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the topic.
     * </p>
     * 
     * @param topicArn
     *        The Amazon Resource Name (ARN) of the topic.
     */

    public void setTopicArn(String topicArn) {
        this.topicArn = topicArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the topic.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the topic.
     */

    public String getTopicArn() {
        return this.topicArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the topic.
     * </p>
     * 
     * @param topicArn
     *        The Amazon Resource Name (ARN) of the topic.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public BatchCreateTopicReviewedAnswerResult withTopicArn(String topicArn) {
        setTopicArn(topicArn);
        return this;
    }

    /**
     * <p>
     * The definition of Answers that are successfully created.
     * </p>
     * 
     * @return The definition of Answers that are successfully created.
     */

    public java.util.List<SucceededTopicReviewedAnswer> getSucceededAnswers() {
        return succeededAnswers;
    }

    /**
     * <p>
     * The definition of Answers that are successfully created.
     * </p>
     * 
     * @param succeededAnswers
     *        The definition of Answers that are successfully created.
     */

    public void setSucceededAnswers(java.util.Collection<SucceededTopicReviewedAnswer> succeededAnswers) {
        if (succeededAnswers == null) {
            this.succeededAnswers = null;
            return;
        }

        this.succeededAnswers = new java.util.ArrayList<SucceededTopicReviewedAnswer>(succeededAnswers);
    }

    /**
     * <p>
     * The definition of Answers that are successfully created.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setSucceededAnswers(java.util.Collection)} or {@link #withSucceededAnswers(java.util.Collection)} if you
     * want to override the existing values.
     * </p>
     * 
     * @param succeededAnswers
     *        The definition of Answers that are successfully created.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public BatchCreateTopicReviewedAnswerResult withSucceededAnswers(SucceededTopicReviewedAnswer... succeededAnswers) {
        if (this.succeededAnswers == null) {
            setSucceededAnswers(new java.util.ArrayList<SucceededTopicReviewedAnswer>(succeededAnswers.length));
        }
        for (SucceededTopicReviewedAnswer ele : succeededAnswers) {
            this.succeededAnswers.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The definition of Answers that are successfully created.
     * </p>
     * 
     * @param succeededAnswers
     *        The definition of Answers that are successfully created.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public BatchCreateTopicReviewedAnswerResult withSucceededAnswers(java.util.Collection<SucceededTopicReviewedAnswer> succeededAnswers) {
        setSucceededAnswers(succeededAnswers);
        return this;
    }

    /**
     * <p>
     * The definition of Answers that are invalid and not created.
     * </p>
     * 
     * @return The definition of Answers that are invalid and not created.
     */

    public java.util.List<InvalidTopicReviewedAnswer> getInvalidAnswers() {
        return invalidAnswers;
    }

    /**
     * <p>
     * The definition of Answers that are invalid and not created.
     * </p>
     * 
     * @param invalidAnswers
     *        The definition of Answers that are invalid and not created.
     */

    public void setInvalidAnswers(java.util.Collection<InvalidTopicReviewedAnswer> invalidAnswers) {
        if (invalidAnswers == null) {
            this.invalidAnswers = null;
            return;
        }

        this.invalidAnswers = new java.util.ArrayList<InvalidTopicReviewedAnswer>(invalidAnswers);
    }

    /**
     * <p>
     * The definition of Answers that are invalid and not created.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setInvalidAnswers(java.util.Collection)} or {@link #withInvalidAnswers(java.util.Collection)} if you want
     * to override the existing values.
     * </p>
     * 
     * @param invalidAnswers
     *        The definition of Answers that are invalid and not created.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public BatchCreateTopicReviewedAnswerResult withInvalidAnswers(InvalidTopicReviewedAnswer... invalidAnswers) {
        if (this.invalidAnswers == null) {
            setInvalidAnswers(new java.util.ArrayList<InvalidTopicReviewedAnswer>(invalidAnswers.length));
        }
        for (InvalidTopicReviewedAnswer ele : invalidAnswers) {
            this.invalidAnswers.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The definition of Answers that are invalid and not created.
     * </p>
     * 
     * @param invalidAnswers
     *        The definition of Answers that are invalid and not created.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public BatchCreateTopicReviewedAnswerResult withInvalidAnswers(java.util.Collection<InvalidTopicReviewedAnswer> invalidAnswers) {
        setInvalidAnswers(invalidAnswers);
        return this;
    }

    /**
     * <p>
     * The HTTP status of the request.
     * </p>
     * 
     * @param status
     *        The HTTP status of the request.
     */

    public void setStatus(Integer status) {
        this.status = status;
    }

    /**
     * <p>
     * The HTTP status of the request.
     * </p>
     * 
     * @return The HTTP status of the request.
     */

    public Integer getStatus() {
        return this.status;
    }

    /**
     * <p>
     * The HTTP status of the request.
     * </p>
     * 
     * @param status
     *        The HTTP status of the request.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public BatchCreateTopicReviewedAnswerResult withStatus(Integer status) {
        setStatus(status);
        return this;
    }

    /**
     * <p>
     * The Amazon Web Services request ID for this operation.
     * </p>
     * 
     * @param requestId
     *        The Amazon Web Services request ID for this operation.
     */

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    /**
     * <p>
     * The Amazon Web Services request ID for this operation.
     * </p>
     * 
     * @return The Amazon Web Services request ID for this operation.
     */

    public String getRequestId() {
        return this.requestId;
    }

    /**
     * <p>
     * The Amazon Web Services request ID for this operation.
     * </p>
     * 
     * @param requestId
     *        The Amazon Web Services request ID for this operation.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public BatchCreateTopicReviewedAnswerResult withRequestId(String requestId) {
        setRequestId(requestId);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getTopicId() != null)
            sb.append("TopicId: ").append(getTopicId()).append(",");
        if (getTopicArn() != null)
            sb.append("TopicArn: ").append(getTopicArn()).append(",");
        if (getSucceededAnswers() != null)
            sb.append("SucceededAnswers: ").append(getSucceededAnswers()).append(",");
        if (getInvalidAnswers() != null)
            sb.append("InvalidAnswers: ").append(getInvalidAnswers()).append(",");
        if (getStatus() != null)
            sb.append("Status: ").append(getStatus()).append(",");
        if (getRequestId() != null)
            sb.append("RequestId: ").append(getRequestId());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof BatchCreateTopicReviewedAnswerResult == false)
            return false;
        BatchCreateTopicReviewedAnswerResult other = (BatchCreateTopicReviewedAnswerResult) obj;
        if (other.getTopicId() == null ^ this.getTopicId() == null)
            return false;
        if (other.getTopicId() != null && other.getTopicId().equals(this.getTopicId()) == false)
            return false;
        if (other.getTopicArn() == null ^ this.getTopicArn() == null)
            return false;
        if (other.getTopicArn() != null && other.getTopicArn().equals(this.getTopicArn()) == false)
            return false;
        if (other.getSucceededAnswers() == null ^ this.getSucceededAnswers() == null)
            return false;
        if (other.getSucceededAnswers() != null && other.getSucceededAnswers().equals(this.getSucceededAnswers()) == false)
            return false;
        if (other.getInvalidAnswers() == null ^ this.getInvalidAnswers() == null)
            return false;
        if (other.getInvalidAnswers() != null && other.getInvalidAnswers().equals(this.getInvalidAnswers()) == false)
            return false;
        if (other.getStatus() == null ^ this.getStatus() == null)
            return false;
        if (other.getStatus() != null && other.getStatus().equals(this.getStatus()) == false)
            return false;
        if (other.getRequestId() == null ^ this.getRequestId() == null)
            return false;
        if (other.getRequestId() != null && other.getRequestId().equals(this.getRequestId()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getTopicId() == null) ? 0 : getTopicId().hashCode());
        hashCode = prime * hashCode + ((getTopicArn() == null) ? 0 : getTopicArn().hashCode());
        hashCode = prime * hashCode + ((getSucceededAnswers() == null) ? 0 : getSucceededAnswers().hashCode());
        hashCode = prime * hashCode + ((getInvalidAnswers() == null) ? 0 : getInvalidAnswers().hashCode());
        hashCode = prime * hashCode + ((getStatus() == null) ? 0 : getStatus().hashCode());
        hashCode = prime * hashCode + ((getRequestId() == null) ? 0 : getRequestId().hashCode());
        return hashCode;
    }

    @Override
    public BatchCreateTopicReviewedAnswerResult clone() {
        try {
            return (BatchCreateTopicReviewedAnswerResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
