/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.DynamicDefaultValue;
import com.amazonaws.services.quicksight.model.transform.StringDefaultValuesMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class StringDefaultValues
implements Serializable,
Cloneable,
StructuredPojo {
    private DynamicDefaultValue dynamicValue;
    private List<String> staticValues;

    public void setDynamicValue(DynamicDefaultValue dynamicValue) {
        this.dynamicValue = dynamicValue;
    }

    public DynamicDefaultValue getDynamicValue() {
        return this.dynamicValue;
    }

    public StringDefaultValues withDynamicValue(DynamicDefaultValue dynamicValue) {
        this.setDynamicValue(dynamicValue);
        return this;
    }

    public List<String> getStaticValues() {
        return this.staticValues;
    }

    public void setStaticValues(Collection<String> staticValues) {
        if (staticValues == null) {
            this.staticValues = null;
            return;
        }
        this.staticValues = new ArrayList<String>(staticValues);
    }

    public StringDefaultValues withStaticValues(String ... staticValues) {
        if (this.staticValues == null) {
            this.setStaticValues(new ArrayList<String>(staticValues.length));
        }
        for (String ele : staticValues) {
            this.staticValues.add(ele);
        }
        return this;
    }

    public StringDefaultValues withStaticValues(Collection<String> staticValues) {
        this.setStaticValues(staticValues);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDynamicValue() != null) {
            sb.append("DynamicValue: ").append(this.getDynamicValue()).append(",");
        }
        if (this.getStaticValues() != null) {
            sb.append("StaticValues: ").append("***Sensitive Data Redacted***");
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StringDefaultValues)) {
            return false;
        }
        StringDefaultValues other = (StringDefaultValues)obj;
        if (other.getDynamicValue() == null ^ this.getDynamicValue() == null) {
            return false;
        }
        if (other.getDynamicValue() != null && !other.getDynamicValue().equals(this.getDynamicValue())) {
            return false;
        }
        if (other.getStaticValues() == null ^ this.getStaticValues() == null) {
            return false;
        }
        return other.getStaticValues() == null || other.getStaticValues().equals(this.getStaticValues());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDynamicValue() == null ? 0 : this.getDynamicValue().hashCode());
        hashCode = 31 * hashCode + (this.getStaticValues() == null ? 0 : this.getStaticValues().hashCode());
        return hashCode;
    }

    public StringDefaultValues clone() {
        try {
            return (StringDefaultValues)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StringDefaultValuesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

