/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.quicksight.model.Tag;
import com.amazonaws.services.quicksight.model.TopicDetails;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateTopicRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String awsAccountId;
    private String topicId;
    private TopicDetails topic;
    private List<Tag> tags;

    public void setAwsAccountId(String awsAccountId) {
        this.awsAccountId = awsAccountId;
    }

    public String getAwsAccountId() {
        return this.awsAccountId;
    }

    public CreateTopicRequest withAwsAccountId(String awsAccountId) {
        this.setAwsAccountId(awsAccountId);
        return this;
    }

    public void setTopicId(String topicId) {
        this.topicId = topicId;
    }

    public String getTopicId() {
        return this.topicId;
    }

    public CreateTopicRequest withTopicId(String topicId) {
        this.setTopicId(topicId);
        return this;
    }

    public void setTopic(TopicDetails topic) {
        this.topic = topic;
    }

    public TopicDetails getTopic() {
        return this.topic;
    }

    public CreateTopicRequest withTopic(TopicDetails topic) {
        this.setTopic(topic);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreateTopicRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateTopicRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAwsAccountId() != null) {
            sb.append("AwsAccountId: ").append(this.getAwsAccountId()).append(",");
        }
        if (this.getTopicId() != null) {
            sb.append("TopicId: ").append(this.getTopicId()).append(",");
        }
        if (this.getTopic() != null) {
            sb.append("Topic: ").append(this.getTopic()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTopicRequest)) {
            return false;
        }
        CreateTopicRequest other = (CreateTopicRequest)obj;
        if (other.getAwsAccountId() == null ^ this.getAwsAccountId() == null) {
            return false;
        }
        if (other.getAwsAccountId() != null && !other.getAwsAccountId().equals(this.getAwsAccountId())) {
            return false;
        }
        if (other.getTopicId() == null ^ this.getTopicId() == null) {
            return false;
        }
        if (other.getTopicId() != null && !other.getTopicId().equals(this.getTopicId())) {
            return false;
        }
        if (other.getTopic() == null ^ this.getTopic() == null) {
            return false;
        }
        if (other.getTopic() != null && !other.getTopic().equals(this.getTopic())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAwsAccountId() == null ? 0 : this.getAwsAccountId().hashCode());
        hashCode = 31 * hashCode + (this.getTopicId() == null ? 0 : this.getTopicId().hashCode());
        hashCode = 31 * hashCode + (this.getTopic() == null ? 0 : this.getTopic().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreateTopicRequest clone() {
        return (CreateTopicRequest)super.clone();
    }
}

